package com.zurrtum.create.client.content.kinetics.mechanicalArm;

import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmBlock;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmBlockEntity.Phase;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_811;
import net.minecraft.class_918;

public class ArmRenderer extends KineticBlockEntityRenderer<ArmBlockEntity> {

    public ArmRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    protected void renderSafe(ArmBlockEntity be, float pt, class_4587 ms, class_4597 buffer, int light, int overlay) {
        super.renderSafe(be, pt, ms, buffer, light, overlay);

        class_1799 item = be.heldItem;
        boolean hasItem = !item.method_7960();
        class_1937 world = be.method_10997();
        boolean usingFlywheel = VisualizationManager.supportsVisualization(world);

        if (usingFlywheel && !hasItem)
            return;

        class_918 itemRenderer = class_310.method_1551().method_1480();

        boolean isBlockItem;
        if (hasItem) {
            itemRenderer.field_55296.method_65598(itemRenderer.field_55297, item, class_811.field_4319, world, null, 0);
            if (item.method_7909() instanceof class_1747) {
                isBlockItem = itemRenderer.field_55297.method_65608();
            } else {
                isBlockItem = false;
            }
        } else {
            isBlockItem = false;
        }

        class_4588 builder = buffer.getBuffer(be.goggles ? class_1921.method_23581() : class_1921.method_23577());
        class_2680 blockState = be.method_11010();

        class_4587 msLocal = new class_4587();
        var msr = TransformStack.of(msLocal);

        float baseAngle;
        float lowerArmAngle;
        float upperArmAngle;
        float headAngle;
        int color;
        boolean inverted = blockState.method_11654(ArmBlock.CEILING);

        boolean rave = be.phase == Phase.DANCING && be.getSpeed() != 0;
        if (rave) {
            float renderTick = AnimationTickHolder.getRenderTime(world) + (be.hashCode() % 64);
            baseAngle = (renderTick * 10) % 360;
            lowerArmAngle = class_3532.method_48781((class_3532.method_15374(renderTick / 4) + 1) / 2, -45, 15);
            upperArmAngle = class_3532.method_48781((class_3532.method_15374(renderTick / 8) + 1) / 4, -45, 95);
            headAngle = -lowerArmAngle;
            color = Color.rainbowColor(AnimationTickHolder.getTicks() * 100).getRGB();
        } else {
            baseAngle = be.baseAngle.getValue(pt);
            lowerArmAngle = be.lowerArmAngle.getValue(pt) - 135;
            upperArmAngle = be.upperArmAngle.getValue(pt) - 90;
            headAngle = be.headAngle.getValue(pt);
            color = 0xFFFFFF;
        }

        msr.center();

        if (inverted)
            msr.rotateXDegrees(180);

        if (usingFlywheel)
            doItemTransforms(msr, baseAngle, lowerArmAngle, upperArmAngle, headAngle);
        else
            renderArm(
                builder,
                ms,
                msLocal,
                msr,
                blockState,
                color,
                baseAngle,
                lowerArmAngle,
                upperArmAngle,
                headAngle,
                be.goggles,
                inverted && be.goggles,
                hasItem,
                isBlockItem,
                light
            );

        if (hasItem) {
            ms.method_22903();
            float itemScale = isBlockItem ? .5f : .625f;
            msr.rotateXDegrees(90);
            msLocal.method_46416(0, isBlockItem ? -9 / 16f : -10 / 16f, 0);
            msLocal.method_22905(itemScale, itemScale, itemScale);

            ms.method_23760().method_23761().mul(msLocal.method_23760().method_23761());

            itemRenderer.field_55297.method_65604(ms, buffer, light, overlay);
            ms.method_22909();
        }

    }

    private void renderArm(
        class_4588 builder,
        class_4587 ms,
        class_4587 msLocal,
        TransformStack msr,
        class_2680 blockState,
        int color,
        float baseAngle,
        float lowerArmAngle,
        float upperArmAngle,
        float headAngle,
        boolean goggles,
        boolean inverted,
        boolean hasItem,
        boolean isBlockItem,
        int light
    ) {
        SuperByteBuffer base = CachedBuffers.partial(AllPartialModels.ARM_BASE, blockState).light(light);
        SuperByteBuffer lowerBody = CachedBuffers.partial(AllPartialModels.ARM_LOWER_BODY, blockState).light(light);
        SuperByteBuffer upperBody = CachedBuffers.partial(AllPartialModels.ARM_UPPER_BODY, blockState).light(light);
        SuperByteBuffer claw = CachedBuffers.partial(goggles ? AllPartialModels.ARM_CLAW_BASE_GOGGLES : AllPartialModels.ARM_CLAW_BASE, blockState)
            .light(light);
        SuperByteBuffer upperClawGrip = CachedBuffers.partial(AllPartialModels.ARM_CLAW_GRIP_UPPER, blockState).light(light);
        SuperByteBuffer lowerClawGrip = CachedBuffers.partial(AllPartialModels.ARM_CLAW_GRIP_LOWER, blockState).light(light);

        transformBase(msr, baseAngle);
        base.transform(msLocal).renderInto(ms, builder);

        transformLowerArm(msr, lowerArmAngle);
        lowerBody.color(color).transform(msLocal).renderInto(ms, builder);

        transformUpperArm(msr, upperArmAngle);
        upperBody.color(color).transform(msLocal).renderInto(ms, builder);

        transformHead(msr, headAngle);

        if (inverted)
            msr.rotateZDegrees(180);
        claw.transform(msLocal).renderInto(ms, builder);

        if (inverted)
            msr.rotateZDegrees(180);

        for (int flip : Iterate.positiveAndNegative) {
            msLocal.method_22903();
            transformClawHalf(msr, hasItem, isBlockItem, flip);
            (flip > 0 ? lowerClawGrip : upperClawGrip).transform(msLocal).renderInto(ms, builder);
            msLocal.method_22909();
        }
    }

    private void doItemTransforms(TransformStack msr, float baseAngle, float lowerArmAngle, float upperArmAngle, float headAngle) {

        transformBase(msr, baseAngle);
        transformLowerArm(msr, lowerArmAngle);
        transformUpperArm(msr, upperArmAngle);
        transformHead(msr, headAngle);
    }

    public static void transformClawHalf(TransformStack msr, boolean hasItem, boolean isBlockItem, int flip) {
        msr.translate(0, -flip * (hasItem ? isBlockItem ? 3 / 16f : 5 / 64f : 1 / 16f), -6 / 16d);
    }

    public static void transformHead(TransformStack msr, float headAngle) {
        msr.translate(0, 0, -15 / 16d);
        msr.rotateXDegrees(headAngle - 45f);
    }

    public static void transformUpperArm(TransformStack msr, float upperArmAngle) {
        msr.translate(0, 0, -14 / 16d);
        msr.rotateXDegrees(upperArmAngle - 90);
    }

    public static void transformLowerArm(TransformStack msr, float lowerArmAngle) {
        msr.translate(0, 2 / 16d, 0);
        msr.rotateXDegrees(lowerArmAngle + 135);
    }

    public static void transformBase(TransformStack msr, float baseAngle) {
        msr.translate(0, 4 / 16d, 0);
        msr.rotateYDegrees(baseAngle);
    }

    @Override
    public boolean method_3563() {
        return true;
    }

    @Override
    protected SuperByteBuffer getRotatedModel(ArmBlockEntity be, class_2680 state) {
        return CachedBuffers.partial(AllPartialModels.ARM_COG, state);
    }

}
