package com.zurrtum.create.client.content.kinetics.saw;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.contraptions.render.ContraptionMatrices;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.filtering.FilteringRenderer;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.saw.SawBlock;
import com.zurrtum.create.content.kinetics.saw.SawBlockEntity;
import com.zurrtum.create.content.logistics.box.PackageItem;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_918;

import static net.minecraft.class_2741.field_12525;

public class SawRenderer extends SafeBlockEntityRenderer<SawBlockEntity> {

    public SawRenderer(class_5614.class_5615 context) {
    }

    @Override
    protected void renderSafe(SawBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        renderBlade(be, ms, buffer, light);
        renderItems(be, partialTicks, ms, buffer, light, overlay);
        FilteringRenderer.renderOnBlockEntity(be, partialTicks, ms, buffer, light, overlay);

        if (VisualizationManager.supportsVisualization(be.method_10997()))
            return;

        renderShaft(be, ms, buffer, light, overlay);
    }

    protected void renderBlade(SawBlockEntity be, class_4587 ms, class_4597 buffer, int light) {
        class_2680 blockState = be.method_11010();
        PartialModel partial;
        float speed = be.getSpeed();
        boolean rotate = false;

        if (SawBlock.isHorizontal(blockState)) {
            if (speed > 0) {
                partial = AllPartialModels.SAW_BLADE_HORIZONTAL_ACTIVE;
            } else if (speed < 0) {
                partial = AllPartialModels.SAW_BLADE_HORIZONTAL_REVERSED;
            } else {
                partial = AllPartialModels.SAW_BLADE_HORIZONTAL_INACTIVE;
            }
        } else {
            if (be.getSpeed() > 0) {
                partial = AllPartialModels.SAW_BLADE_VERTICAL_ACTIVE;
            } else if (speed < 0) {
                partial = AllPartialModels.SAW_BLADE_VERTICAL_REVERSED;
            } else {
                partial = AllPartialModels.SAW_BLADE_VERTICAL_INACTIVE;
            }

            if (blockState.method_11654(SawBlock.AXIS_ALONG_FIRST_COORDINATE))
                rotate = true;
        }

        SuperByteBuffer superBuffer = CachedBuffers.partialFacing(partial, blockState);
        if (rotate) {
            superBuffer.rotateCentered(AngleHelper.rad(90), class_2350.field_11036);
        }
        superBuffer.color(0xFFFFFF).light(light).renderInto(ms, buffer.getBuffer(class_1921.method_23579()));
    }

    protected void renderShaft(SawBlockEntity be, class_4587 ms, class_4597 buffer, int light, int overlay) {
        KineticBlockEntityRenderer.renderRotatingBuffer(be, getRotatedModel(be), ms, buffer.getBuffer(class_1921.method_23577()), light);
    }

    protected void renderItems(SawBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        if (be.method_11010().method_11654(SawBlock.FACING) != class_2350.field_11036)
            return;
        if (be.inventory.method_5442())
            return;

        boolean alongZ = !be.method_11010().method_11654(SawBlock.AXIS_ALONG_FIRST_COORDINATE);

        float duration = be.inventory.recipeDuration;
        boolean moving = duration != 0;
        float offset = moving ? be.inventory.remainingTime / duration : 0;
        float processingSpeed = class_3532.method_15363(Math.abs(be.getSpeed()) / 32, 1, 128);
        if (moving) {
            offset = class_3532.method_15363(offset + ((-partialTicks + .5f) * processingSpeed) / duration, 0.125f, 1f);
            if (!be.inventory.appliedRecipe)
                offset += 1;
            offset /= 2;
        }

        if (be.getSpeed() == 0)
            offset = .5f;
        if (be.getSpeed() < 0 ^ alongZ)
            offset = 1 - offset;

        int outputs = 0;
        for (int i = 1, size = be.inventory.method_5439(); i < size; i++)
            if (!be.inventory.method_5438(i).method_7960())
                outputs++;

        ms.method_22903();
        if (alongZ)
            ms.method_22907(class_7833.field_40716.rotationDegrees(90));
        ms.method_22904(outputs <= 1 ? .5 : .25, 0, offset);
        ms.method_46416(alongZ ? -1 : 0, 0, 0);

        int renderedI = 0;
        class_918 itemRenderer = class_310.method_1551().method_1480();
        for (int i = 0, size = be.inventory.method_5439(); i < size; i++) {
            class_1799 stack = be.inventory.method_5438(i);
            if (stack.method_7960())
                continue;
            itemRenderer.field_55296.method_65598(itemRenderer.field_55297, stack, class_811.field_4319, be.method_10997(), null, 0);
            boolean blockItem = itemRenderer.field_55297.method_65608();

            ms.method_22903();
            ms.method_46416(0, blockItem ? .925f : 13f / 16f, 0);

            if (i > 0 && outputs > 1) {
                ms.method_22904((0.5 / (outputs - 1)) * renderedI, 0, 0);
                TransformStack.of(ms).nudge(i * 133);
            }

            boolean box = PackageItem.isPackage(stack);
            if (box) {
                ms.method_46416(0, 4 / 16f, 0);
                ms.method_22905(1.5f, 1.5f, 1.5f);
            } else
                ms.method_22905(.5f, .5f, .5f);

            if (!box)
                ms.method_22907(class_7833.field_40714.rotationDegrees(90));

            itemRenderer.field_55297.method_65604(ms, buffer, light, overlay);
            renderedI++;

            ms.method_22909();
        }

        ms.method_22909();
    }

    protected SuperByteBuffer getRotatedModel(KineticBlockEntity be) {
        class_2680 state = be.method_11010();
        if (state.method_11654(field_12525).method_10166().method_10179())
            return CachedBuffers.partialFacing(AllPartialModels.SHAFT_HALF, state.method_26204().method_9598(state, class_2470.field_11464));
        return CachedBuffers.block(KineticBlockEntityRenderer.KINETIC_BLOCK, getRenderedBlockState(be));
    }

    protected class_2680 getRenderedBlockState(KineticBlockEntity be) {
        return KineticBlockEntityRenderer.shaft(KineticBlockEntityRenderer.getRotationAxisOf(be));
    }

    public static void renderInContraption(
        MovementContext context,
        VirtualRenderWorld renderWorld,
        ContraptionMatrices matrices,
        class_4597 buffer
    ) {
        class_2680 state = context.state;
        class_2350 facing = state.method_11654(SawBlock.FACING);

        class_243 facingVec = class_243.method_24954(context.state.method_11654(SawBlock.FACING).method_62675());
        facingVec = context.rotation.apply(facingVec);

        class_2350 closestToFacing = class_2350.method_10142(facingVec.field_1352, facingVec.field_1351, facingVec.field_1350);

        boolean horizontal = closestToFacing.method_10166().method_10179();
        boolean backwards = VecHelper.isVecPointingTowards(context.relativeMotion, facing.method_10153());
        boolean moving = context.getAnimationSpeed() != 0;
        boolean shouldAnimate = (context.contraption.stalled && horizontal) || (!context.contraption.stalled && !backwards && moving);

        SuperByteBuffer superBuffer;
        if (SawBlock.isHorizontal(state)) {
            if (shouldAnimate)
                superBuffer = CachedBuffers.partial(AllPartialModels.SAW_BLADE_HORIZONTAL_ACTIVE, state);
            else
                superBuffer = CachedBuffers.partial(AllPartialModels.SAW_BLADE_HORIZONTAL_INACTIVE, state);
        } else {
            if (shouldAnimate)
                superBuffer = CachedBuffers.partial(AllPartialModels.SAW_BLADE_VERTICAL_ACTIVE, state);
            else
                superBuffer = CachedBuffers.partial(AllPartialModels.SAW_BLADE_VERTICAL_INACTIVE, state);
        }

        superBuffer.transform(matrices.getModel()).center().rotateYDegrees(AngleHelper.horizontalAngle(facing))
            .rotateXDegrees(AngleHelper.verticalAngle(facing));

        if (!SawBlock.isHorizontal(state)) {
            superBuffer.rotateZDegrees(state.method_11654(SawBlock.AXIS_ALONG_FIRST_COORDINATE) ? 90 : 0);
        }

        superBuffer.uncenter().light(class_761.method_23794(renderWorld, context.localPos))
            .useLevelLight(context.world, matrices.getWorld())
            .renderInto(matrices.getViewProjection(), buffer.getBuffer(class_1921.method_23579()));
    }

}
