package com.zurrtum.create.client.content.logistics.filter;

import com.zurrtum.create.client.content.logistics.AddressEditBox;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.content.logistics.box.PackageStyles;
import com.zurrtum.create.content.logistics.filter.PackageFilterMenu;
import com.zurrtum.create.foundation.gui.menu.MenuType;
import com.zurrtum.create.infrastructure.packet.c2s.FilterScreenPacket;
import com.zurrtum.create.infrastructure.packet.c2s.FilterScreenPacket.Option;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_9129;
import org.lwjgl.glfw.GLFW;

public class PackageFilterScreen extends AbstractFilterScreen<PackageFilterMenu> {

    private AddressEditBox addressBox;
    private boolean deferFocus;

    public PackageFilterScreen(PackageFilterMenu menu, class_1661 inv, class_2561 title) {
        super(menu, inv, title, AllGuiTextures.PACKAGE_FILTER);
    }

    public static PackageFilterScreen create(
        class_310 mc,
        MenuType<class_1799> type,
        int syncId,
        class_1661 inventory,
        class_2561 title,
        class_9129 extraData
    ) {
        return type.create(PackageFilterScreen::new, syncId, inventory, title, getStack(extraData));
    }

    @Override
    protected void method_37432() {
        super.method_37432();
        if (deferFocus) {
            deferFocus = false;
            method_25395(addressBox);
        }
        addressBox.tick();
    }

    @Override
    protected void method_25426() {
        setWindowOffset(-11, 7);
        super.method_25426();

        addressBox = new AddressEditBox(this, field_22793, field_2776 + 44, field_2800 + 28, 129, 9, false);
        addressBox.method_1868(0xffffffff);
        addressBox.method_1852(field_2797.address);
        addressBox.method_1863(this::onAddressEdited);
        method_37063(addressBox);

        method_25395(addressBox);
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);

        graphics.method_51427(PackageStyles.getDefaultBox(), field_2776 + 16, field_2800 + 23);
    }

    public void onAddressEdited(String s) {
        field_2797.address = s;
        class_2487 tag = new class_2487();
        tag.method_10582("Address", s);
        field_22787.field_1724.field_3944.method_52787(new FilterScreenPacket(Option.UPDATE_ADDRESS, tag));
    }

    @Override
    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        return super.method_25402(pMouseX, pMouseY, pButton);
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (addressBox.method_25401(mouseX, mouseY, scrollX, scrollY))
            return true;
        return super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    @Override
    public boolean method_25404(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == GLFW.GLFW_KEY_ENTER)
            method_25395(null);
        return super.method_25404(pKeyCode, pScanCode, pModifiers);
    }

    @Override
    public boolean method_25400(char pCodePoint, int pModifiers) {
        return super.method_25400(pCodePoint, pModifiers);
    }

    @Override
    protected void contentsCleared() {
        addressBox.method_1852("");
        deferFocus = true;
    }

    @Override
    protected boolean isButtonEnabled(IconButton button) {
        return false;
    }

}