package com.zurrtum.create.client.content.logistics.packagerLink;

import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.zurrtum.create.client.content.logistics.factoryBoard.FactoryPanelConnectionHandler;
import com.zurrtum.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.zurrtum.create.content.logistics.packagerLink.LogisticallyLinkedBlockItem;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_265;
import net.minecraft.class_310;
import net.minecraft.class_4844;
import net.minecraft.class_746;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class LogisticallyLinkedClientHandler {

    private static UUID previouslyHeldFrequency;

    public static void tick(class_310 mc) {
        previouslyHeldFrequency = null;

        class_746 player = mc.field_1724;
        if (player == null)
            return;
        class_1799 mainHandItem = player.method_6047();
        if (!(mainHandItem.method_7909() instanceof LogisticallyLinkedBlockItem) || !LogisticallyLinkedBlockItem.isTuned(mainHandItem))
            return;

        class_2487 tag = mainHandItem.method_58695(class_9334.field_49611, class_9279.field_49302).method_57461();
        Optional<UUID> uuid = tag.method_67491("Freq", class_4844.field_25122);
        if (uuid.isEmpty())
            return;

        previouslyHeldFrequency = uuid.get();

        for (LogisticallyLinkedBehaviour behaviour : LogisticallyLinkedBehaviour.getAllPresent(previouslyHeldFrequency, false, true)) {
            SmartBlockEntity be = behaviour.blockEntity;
            class_265 shape = be.method_11010().method_26218(player.method_37908(), be.method_11016());
            if (shape.method_1110())
                continue;
            if (!player.method_24515().method_19771(be.method_11016(), 64))
                continue;
            List<class_238> list = shape.method_1090();
            for (int i = 0, size = list.size(); i < size; i++) {
                class_238 aabb = list.get(i);
                Outliner.getInstance().showAABB(Pair.of(behaviour, i), aabb.method_1014(-1 / 128f).method_996(be.method_11016()), 2).lineWidth(1 / 32f)
                    .disableLineNormals().colored(AnimationTickHolder.getTicks() % 16 < 8 ? 0x708DAD : 0x90ADCD);
            }

        }
    }

    public static void tickPanel(FactoryPanelBehaviour fpb) {
        if (previouslyHeldFrequency == null)
            return;
        if (!previouslyHeldFrequency.equals(fpb.getNetwork()))
            return;
        class_746 player = class_310.method_1551().field_1724;
        if (player == null)
            return;
        if (!player.method_24515().method_19771(fpb.getPos(), 64))
            return;

        Outliner.getInstance()
            .showAABB(fpb, FactoryPanelConnectionHandler.getBB(fpb.blockEntity.method_11010(), fpb.getPanelPosition()).method_1014(-1.5 / 128f))
            .lineWidth(1 / 32f).disableLineNormals().colored(AnimationTickHolder.getTicks() % 16 < 8 ? 0x708DAD : 0x90ADCD);
    }

}
