package com.zurrtum.create.client.content.logistics.tunnel;

import com.zurrtum.create.client.AllSpriteShifts;
import com.zurrtum.create.client.foundation.block.connected.CTSpriteShiftEntry;
import com.zurrtum.create.client.foundation.block.connected.CTType;
import com.zurrtum.create.client.foundation.block.connected.ConnectedTextureBehaviour;
import com.zurrtum.create.content.logistics.tunnel.BrassTunnelBlockEntity;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class BrassTunnelCTBehaviour extends ConnectedTextureBehaviour.Base {

    @Override
    public @Nullable CTType getDataType(class_1920 world, class_2338 pos, class_2680 state, class_2350 direction) {
        if (!(world.method_8321(pos) instanceof BrassTunnelBlockEntity tunnelBE) || !tunnelBE.hasDistributionBehaviour())
            return null;
        return super.getDataType(world, pos, state, direction);
    }

    @Override
    public CTSpriteShiftEntry getShift(class_2680 state, class_2350 direction, @Nullable class_1058 sprite) {
        return direction == class_2350.field_11036 ? AllSpriteShifts.BRASS_TUNNEL_TOP : null;
    }

    @Override
    protected boolean reverseUVs(class_2680 state, class_2350 face) {
        return true;
    }

    @Override
    public boolean connectsTo(class_2680 state, class_2680 other, class_1920 reader, class_2338 pos, class_2338 otherPos, class_2350 face) {
        int yDiff = otherPos.method_10264() - pos.method_10264();
        int zDiff = otherPos.method_10260() - pos.method_10260();
        if (yDiff != 0)
            return false;

        if (!(reader.method_8321(pos) instanceof BrassTunnelBlockEntity tunnelBE))
            return false;
        boolean leftSide = zDiff > 0;
        return tunnelBE.isConnected(leftSide);
    }

}
