package com.zurrtum.create.client.content.processing.burner;

import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderBehaviour;
import com.zurrtum.create.client.content.contraptions.render.ContraptionMatrices;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlock;
import com.zurrtum.create.content.trains.entity.CarriageContraption;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import net.minecraft.class_1297;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4597;
import net.minecraft.class_5819;

public class BlazeBurnerMovementRenderBehaviour implements MovementRenderBehaviour {
    public void tick(MovementContext context) {
        if (!shouldRender(context))
            return;

        class_5819 r = context.world.method_8409();
        class_243 c = context.position;
        class_243 v = c.method_1019(VecHelper.offsetRandomly(class_243.field_1353, r, .125f).method_18805(1, 0, 1));
        if (r.method_43048(3) == 0 && context.motion.method_1033() < 1 / 64f)
            context.world.method_8406(class_2398.field_11237, v.field_1352, v.field_1351, v.field_1350, 0, 0, 0);

        LerpedFloat headAngle = getHeadAngle(context);
        boolean quickTurn = shouldRenderHat(context) && !class_3532.method_20390(context.relativeMotion.method_1033(), 0);
        headAngle.chase(
            headAngle.getValue() + AngleHelper.getShortestAngleDiff(headAngle.getValue(), getTargetAngle(context)),
            .5f,
            quickTurn ? LerpedFloat.Chaser.EXP : LerpedFloat.Chaser.exp(5)
        );
        headAngle.tickChaser();
    }

    private boolean shouldRender(MovementContext context) {
        return context.state.method_61767(BlazeBurnerBlock.HEAT_LEVEL, BlazeBurnerBlock.HeatLevel.NONE) != BlazeBurnerBlock.HeatLevel.NONE;
    }

    private LerpedFloat getHeadAngle(MovementContext context) {
        if (!(context.temporaryData instanceof LerpedFloat))
            context.temporaryData = LerpedFloat.angular().startWithValue(getTargetAngle(context));
        return (LerpedFloat) context.temporaryData;
    }

    private float getTargetAngle(MovementContext context) {
        if (shouldRenderHat(context) && !class_3532.method_20390(
            context.relativeMotion.method_1033(),
            0
        ) && context.contraption.entity instanceof CarriageContraptionEntity cce) {

            float angle = AngleHelper.deg(-class_3532.method_15349(context.relativeMotion.field_1352, context.relativeMotion.field_1350));
            return cce.getInitialOrientation().method_10166() == class_2350.class_2351.field_11048 ? angle + 180 : angle;
        }

        class_1297 player = class_310.method_1551().field_1719;
        if (player != null && !player.method_5767() && context.position != null) {
            class_243 applyRotation = context.contraption.entity.reverseRotation(player.method_19538().method_1020(context.position), 1);
            double dx = applyRotation.field_1352;
            double dz = applyRotation.field_1350;
            return AngleHelper.deg(-class_3532.method_15349(dz, dx)) - 90;
        }
        return 0;
    }

    private boolean shouldRenderHat(MovementContext context) {
        class_2487 data = context.data;
        if (!data.method_10545("Conductor"))
            data.method_10556("Conductor", determineIfConducting(context));
        return data.method_68566("Conductor", false) && (context.contraption.entity instanceof CarriageContraptionEntity cce) && cce.hasSchedule();
    }

    private boolean determineIfConducting(MovementContext context) {
        Contraption contraption = context.contraption;
        if (!(contraption instanceof CarriageContraption carriageContraption))
            return false;
        class_2350 assemblyDirection = carriageContraption.getAssemblyDirection();
        for (class_2350 direction : Iterate.directionsInAxis(assemblyDirection.method_10166()))
            if (carriageContraption.inControl(context.localPos, direction))
                return true;
        return false;
    }

    @Override
    public void renderInContraption(
        MovementContext context,
        VirtualRenderWorld renderWorld,
        ContraptionMatrices matrices,
        class_4597 buffer
    ) {
        if (!shouldRender(context))
            return;
        BlazeBurnerRenderer.renderInContraption(context, renderWorld, matrices, buffer, getHeadAngle(context), shouldRenderHat(context));
    }
}
