package com.zurrtum.create.client.content.schematics.client;

import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.animation.LerpedFloat.Chaser;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import net.minecraft.class_2338;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_238;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_3492;
import net.minecraft.class_4587;

import static java.lang.Math.abs;

public class SchematicTransformation {

    private class_243 chasingPos;
    private class_243 prevChasingPos;
    private class_2338 target;

    private LerpedFloat scaleFrontBack, scaleLeftRight;
    private LerpedFloat rotation;
    private double xOrigin;
    private double zOrigin;

    public SchematicTransformation() {
        chasingPos = class_243.field_1353;
        prevChasingPos = class_243.field_1353;
        target = class_2338.field_10980;
        scaleFrontBack = LerpedFloat.linear();
        scaleLeftRight = LerpedFloat.linear();
        rotation = LerpedFloat.angular();
    }

    public void init(class_2338 anchor, class_3492 settings, class_238 bounds) {
        int leftRight = settings.method_15114() == class_2415.field_11300 ? -1 : 1;
        int frontBack = settings.method_15114() == class_2415.field_11301 ? -1 : 1;
        getScaleFB().chase(0, 0.45f, Chaser.EXP).startWithValue(frontBack);
        getScaleLR().chase(0, 0.45f, Chaser.EXP).startWithValue(leftRight);
        xOrigin = bounds.method_17939() / 2f;
        zOrigin = bounds.method_17941() / 2f;

        int r = -(settings.method_15113().ordinal() * 90);
        rotation.chase(0, 0.45f, Chaser.EXP).startWithValue(r);

        target = fromAnchor(anchor);
        chasingPos = class_243.method_24954(target);
        prevChasingPos = chasingPos;
    }

    public void applyTransformations(class_4587 ms, class_243 camera) {
        float pt = AnimationTickHolder.getPartialTicks();

        // Translation
        TransformStack.of(ms).translate(VecHelper.lerp(pt, prevChasingPos, chasingPos).method_1020(camera));
        class_243 rotationOffset = getRotationOffset(true);

        // Rotation & Mirror
        float fb = getScaleFB().getValue(pt);
        float lr = getScaleLR().getValue(pt);
        float rot = rotation.getValue(pt) + ((fb < 0 && lr < 0) ? 180 : 0);
        ms.method_22904(xOrigin, 0, zOrigin);
        TransformStack.of(ms).translate(rotationOffset).rotateYDegrees(rot).translateBack(rotationOffset);
        ms.method_22905(abs(fb), 1, abs(lr));
        ms.method_22904(-xOrigin, 0, -zOrigin);

    }

    public boolean isFlipped() {
        return getMirrorModifier(class_2351.field_11048) < 0 != getMirrorModifier(class_2351.field_11051) < 0;
    }

    public class_243 getRotationOffset(boolean ignoreMirrors) {
        class_243 rotationOffset = class_243.field_1353;
        if ((int) (zOrigin * 2) % 2 != (int) (xOrigin * 2) % 2) {
            boolean xGreaterZ = xOrigin > zOrigin;
            float xIn = (xGreaterZ ? 0 : .5f);
            float zIn = (!xGreaterZ ? 0 : .5f);
            if (!ignoreMirrors) {
                xIn *= getMirrorModifier(class_2351.field_11048);
                zIn *= getMirrorModifier(class_2351.field_11051);
            }
            rotationOffset = new class_243(xIn, 0, zIn);
        }
        return rotationOffset;
    }

    public class_243 toLocalSpace(class_243 vec) {
        float pt = AnimationTickHolder.getPartialTicks();
        class_243 rotationOffset = getRotationOffset(true);

        vec = vec.method_1020(VecHelper.lerp(pt, prevChasingPos, chasingPos));
        vec = vec.method_1023(xOrigin + rotationOffset.field_1352, 0, zOrigin + rotationOffset.field_1350);
        vec = VecHelper.rotate(vec, -rotation.getValue(pt), class_2351.field_11052);
        vec = vec.method_1031(rotationOffset.field_1352, 0, rotationOffset.field_1350);
        vec = vec.method_18805(getScaleFB().getValue(pt), 1, getScaleLR().getValue(pt));
        vec = vec.method_1031(xOrigin, 0, zOrigin);

        return vec;
    }

    public class_3492 toSettings() {
        class_3492 settings = new class_3492();

        int i = (int) rotation.getChaseTarget();

        boolean mirrorlr = getScaleLR().getChaseTarget() < 0;
        boolean mirrorfb = getScaleFB().getChaseTarget() < 0;
        if (mirrorlr && mirrorfb) {
            mirrorlr = mirrorfb = false;
            i += 180;
        }
        i = i % 360;
        if (i < 0)
            i += 360;

        class_2470 rotation = class_2470.field_11467;
        switch (i) {
            case 90:
                rotation = class_2470.field_11465;
                break;
            case 180:
                rotation = class_2470.field_11464;
                break;
            case 270:
                rotation = class_2470.field_11463;
                break;
            default:
        }

        settings.method_15123(rotation);
        if (mirrorfb)
            settings.method_15125(class_2415.field_11301);
        if (mirrorlr)
            settings.method_15125(class_2415.field_11300);

        return settings;
    }

    public class_2338 getAnchor() {
        class_243 vec = class_243.field_1353.method_1031(.5, 0, .5);
        class_243 rotationOffset = getRotationOffset(false);
        vec = vec.method_1023(xOrigin, 0, zOrigin);
        vec = vec.method_1023(rotationOffset.field_1352, 0, rotationOffset.field_1350);
        vec = vec.method_18805(getScaleFB().getChaseTarget(), 1, getScaleLR().getChaseTarget());
        vec = VecHelper.rotate(vec, rotation.getChaseTarget(), class_2351.field_11052);
        vec = vec.method_1031(xOrigin, 0, zOrigin);
        vec = vec.method_1031(target.method_10263(), target.method_10264(), target.method_10260());
        return class_2338.method_49637(vec.field_1352, vec.field_1351, vec.field_1350);
    }

    public class_2338 fromAnchor(class_2338 pos) {
        class_243 vec = class_243.field_1353.method_1031(.5, 0, .5);
        class_243 rotationOffset = getRotationOffset(false);
        vec = vec.method_1023(xOrigin, 0, zOrigin);
        vec = vec.method_1023(rotationOffset.field_1352, 0, rotationOffset.field_1350);
        vec = vec.method_18805(getScaleFB().getChaseTarget(), 1, getScaleLR().getChaseTarget());
        vec = VecHelper.rotate(vec, rotation.getChaseTarget(), class_2351.field_11052);
        vec = vec.method_1031(xOrigin, 0, zOrigin);
        return pos.method_10059(class_2338.method_49637(vec.field_1352, vec.field_1351, vec.field_1350));
    }

    public int getRotationTarget() {
        return (int) rotation.getChaseTarget();
    }

    public int getMirrorModifier(class_2351 axis) {
        if (axis == class_2351.field_11051)
            return (int) getScaleLR().getChaseTarget();
        return (int) getScaleFB().getChaseTarget();
    }

    public float getCurrentRotation() {
        float pt = AnimationTickHolder.getPartialTicks();
        return rotation.getValue(pt);
    }

    public void tick() {
        prevChasingPos = chasingPos;
        chasingPos = VecHelper.lerp(0.45f, chasingPos, class_243.method_24954(target));
        getScaleLR().tickChaser();
        getScaleFB().tickChaser();
        rotation.tickChaser();
    }

    public void flip(class_2351 axis) {
        if (axis == class_2351.field_11048)
            getScaleLR().updateChaseTarget(getScaleLR().getChaseTarget() * -1);
        if (axis == class_2351.field_11051)
            getScaleFB().updateChaseTarget(getScaleFB().getChaseTarget() * -1);
    }

    public void rotate90(boolean clockwise) {
        rotation.updateChaseTarget(rotation.getChaseTarget() + (clockwise ? -90 : 90));
    }

    public void move(int xIn, int yIn, int zIn) {
        moveTo(target.method_10069(xIn, yIn, zIn));
    }

    public void startAt(class_2338 pos) {
        chasingPos = class_243.method_24954(pos);
        prevChasingPos = chasingPos;
        moveTo(pos);
    }

    public void moveTo(class_2338 pos) {
        target = pos;
    }

    public void moveTo(int xIn, int yIn, int zIn) {
        moveTo(new class_2338(xIn, yIn, zIn));
    }

    public LerpedFloat getScaleFB() {
        return scaleFrontBack;
    }

    public LerpedFloat getScaleLR() {
        return scaleLeftRight;
    }

}