package com.zurrtum.create.client.content.schematics.client.tools;

import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllSpecialTextures;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.outliner.AABBOutline;
import com.zurrtum.create.client.catnip.render.SuperRenderTypeBuffer;
import com.zurrtum.create.client.content.schematics.client.SchematicHandler;
import com.zurrtum.create.client.content.schematics.client.SchematicTransformation;
import com.zurrtum.create.client.foundation.utility.RaycastHelper;
import com.zurrtum.create.client.foundation.utility.RaycastHelper.PredicateTraceResult;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239.class_240;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_746;

public abstract class SchematicToolBase implements ISchematicTool {

    protected SchematicHandler schematicHandler;

    protected class_2338 selectedPos;
    protected class_243 chasingSelectedPos;
    protected class_243 lastChasingSelectedPos;

    protected boolean selectIgnoreBlocks;
    protected int selectionRange;
    protected boolean schematicSelected;
    protected boolean renderSelectedFace;
    protected class_2350 selectedFace;

    @Override
    public void init() {
        schematicHandler = Create.SCHEMATIC_HANDLER;
        selectedPos = null;
        selectedFace = null;
        schematicSelected = false;
        chasingSelectedPos = class_243.field_1353;
        lastChasingSelectedPos = class_243.field_1353;
    }

    @Override
    public void updateSelection(class_310 mc) {
        updateTargetPos();

        if (selectedPos == null)
            return;
        lastChasingSelectedPos = chasingSelectedPos;
        class_243 target = class_243.method_24954(selectedPos);
        if (target.method_1022(chasingSelectedPos) < 1 / 512f) {
            chasingSelectedPos = target;
            return;
        }

        chasingSelectedPos = chasingSelectedPos.method_1019(target.method_1020(chasingSelectedPos).method_1021(1 / 2f));
    }

    public void updateTargetPos() {
        class_746 player = class_310.method_1551().field_1724;

        // Select Blueprint
        if (schematicHandler.isDeployed()) {
            SchematicTransformation transformation = schematicHandler.getTransformation();
            class_238 localBounds = schematicHandler.getBounds();

            class_243 traceOrigin = RaycastHelper.getTraceOrigin(player);
            class_243 start = transformation.toLocalSpace(traceOrigin);
            class_243 end = transformation.toLocalSpace(RaycastHelper.getTraceTarget(player, 70, traceOrigin));
            PredicateTraceResult result = RaycastHelper.rayTraceUntil(start, end, pos -> localBounds.method_1006(VecHelper.getCenterOf(pos)));

            schematicSelected = !result.missed();
            selectedFace = schematicSelected ? result.getFacing() : null;
        }

        boolean snap = this.selectedPos == null;

        // Select location at distance
        if (selectIgnoreBlocks) {
            float pt = AnimationTickHolder.getPartialTicks();
            selectedPos = class_2338.method_49638(player.method_5836(pt).method_1019(player.method_5720().method_1021(selectionRange)));
            if (snap)
                lastChasingSelectedPos = chasingSelectedPos = class_243.method_24954(selectedPos);
            return;
        }

        // Select targeted Block
        selectedPos = null;
        class_3965 trace = RaycastHelper.rayTraceRange(player.method_37908(), player, 75);
        if (trace == null || trace.method_17783() != class_240.field_1332)
            return;

        class_2338 hit = class_2338.method_49638(trace.method_17784());
        boolean replaceable = player.method_37908().method_8320(hit).method_45474();
        if (trace.method_17780().method_10166().method_10178() && !replaceable)
            hit = hit.method_10093(trace.method_17780());
        selectedPos = hit;
        if (snap)
            lastChasingSelectedPos = chasingSelectedPos = class_243.method_24954(selectedPos);
    }

    @Override
    public void renderTool(class_310 mc, class_4587 ms, SuperRenderTypeBuffer buffer, class_243 camera) {
    }

    @Override
    public void renderOverlay(class_329 gui, class_332 graphics, float partialTicks, int width, int height) {
    }

    @Override
    public void renderOnSchematic(class_310 mc, class_4587 ms, SuperRenderTypeBuffer buffer) {
        if (!schematicHandler.isDeployed())
            return;

        ms.method_22903();
        AABBOutline outline = schematicHandler.getOutline();
        if (renderSelectedFace) {
            outline.getParams().highlightFace(selectedFace).withFaceTextures(
                AllSpecialTextures.CHECKERED,
                class_437.method_25441() ? AllSpecialTextures.HIGHLIGHT_CHECKERED : AllSpecialTextures.CHECKERED
            );
        }
        outline.getParams().colored(0x6886c5).withFaceTexture(AllSpecialTextures.CHECKERED).lineWidth(1 / 16f);
        outline.render(class_310.method_1551(), ms, buffer, class_243.field_1353, AnimationTickHolder.getPartialTicks());
        outline.getParams().clearTextures();
        ms.method_22909();
    }

}
