package com.zurrtum.create.client.content.trains.bogey;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllSpriteShifts;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.content.kinetics.simpleRelays.ShaftBlock;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;

public class StandardBogeyRenderer implements BogeyRenderer {
    @Override
    public void render(
        class_2487 bogeyData,
        float wheelAngle,
        float partialTick,
        class_4587 poseStack,
        class_4597 bufferSource,
        int light,
        int overlay,
        boolean inContraption
    ) {
        class_4588 buffer = bufferSource.getBuffer(class_1921.method_23579());

        SuperByteBuffer shaft = CachedBuffers.block(AllBlocks.SHAFT.method_9564().method_11657(ShaftBlock.AXIS, class_2350.class_2351.field_11051));
        for (int i : Iterate.zeroAndOne) {
            shaft.translate(-.5f, .25f, i * -1).center().rotateZDegrees(wheelAngle).uncenter().light(light).overlay(overlay)
                .renderInto(poseStack, buffer);
        }
    }

    public static class Small extends StandardBogeyRenderer {
        @Override
        public void render(
            class_2487 bogeyData,
            float wheelAngle,
            float partialTick,
            class_4587 poseStack,
            class_4597 bufferSource,
            int light,
            int overlay,
            boolean inContraption
        ) {
            super.render(bogeyData, wheelAngle, partialTick, poseStack, bufferSource, light, overlay, inContraption);

            class_4588 buffer = bufferSource.getBuffer(class_1921.method_23579());

            CachedBuffers.partial(AllPartialModels.BOGEY_FRAME, class_2246.field_10124.method_9564()).scale(1 - 1 / 512f).light(light).overlay(overlay)
                .renderInto(poseStack, buffer);

            SuperByteBuffer wheels = CachedBuffers.partial(AllPartialModels.SMALL_BOGEY_WHEELS, class_2246.field_10124.method_9564());
            for (int side : Iterate.positiveAndNegative) {
                wheels.translate(0, 12 / 16f, side).rotateXDegrees(wheelAngle).light(light).overlay(overlay).renderInto(poseStack, buffer);
            }
        }
    }

    public static class Large extends StandardBogeyRenderer {
        public static final float BELT_RADIUS_PX = 5f;
        public static final float BELT_RADIUS_IN_UV_SPACE = BELT_RADIUS_PX / 16f;

        @Override
        public void render(
            class_2487 bogeyData,
            float wheelAngle,
            float partialTick,
            class_4587 poseStack,
            class_4597 bufferSource,
            int light,
            int overlay,
            boolean inContraption
        ) {
            super.render(bogeyData, wheelAngle, partialTick, poseStack, bufferSource, light, overlay, inContraption);

            class_4588 buffer = bufferSource.getBuffer(class_1921.method_23579());

            SuperByteBuffer secondaryShaft = CachedBuffers.block(AllBlocks.SHAFT.method_9564().method_11657(ShaftBlock.AXIS, class_2350.class_2351.field_11048));
            for (int i : Iterate.zeroAndOne) {
                secondaryShaft.translate(-.5f, .25f, .5f + i * -2).center().rotateXDegrees(wheelAngle).uncenter().light(light).overlay(overlay)
                    .renderInto(poseStack, buffer);
            }

            CachedBuffers.partial(AllPartialModels.BOGEY_DRIVE, class_2246.field_10124.method_9564()).scale(1 - 1 / 512f).light(light).overlay(overlay)
                .renderInto(poseStack, buffer);

            float spriteSize = AllSpriteShifts.BOGEY_BELT.getTarget().method_4575() - AllSpriteShifts.BOGEY_BELT.getTarget().method_4593();

            float scroll = BELT_RADIUS_IN_UV_SPACE * class_3532.field_29847 * wheelAngle;
            scroll = scroll - class_3532.method_15375(scroll);
            scroll = scroll * spriteSize * 0.5f;

            CachedBuffers.partial(AllPartialModels.BOGEY_DRIVE_BELT, class_2246.field_10124.method_9564()).scale(1 - 1 / 512f).light(light).overlay(overlay)
                .shiftUVScrolling(AllSpriteShifts.BOGEY_BELT, scroll).renderInto(poseStack, buffer);

            CachedBuffers.partial(AllPartialModels.BOGEY_PISTON, class_2246.field_10124.method_9564())
                .translate(0, 0, 1 / 4f * Math.sin(AngleHelper.rad(wheelAngle))).light(light).overlay(overlay).renderInto(poseStack, buffer);

            CachedBuffers.partial(AllPartialModels.LARGE_BOGEY_WHEELS, class_2246.field_10124.method_9564()).translate(0, 1, 0).rotateXDegrees(wheelAngle)
                .light(light).overlay(overlay).renderInto(poseStack, buffer);

            CachedBuffers.partial(AllPartialModels.BOGEY_PIN, class_2246.field_10124.method_9564()).translate(0, 1, 0).rotateXDegrees(wheelAngle)
                .translate(0, 1 / 4f, 0).rotateXDegrees(-wheelAngle).light(light).overlay(overlay).renderInto(poseStack, buffer);
        }
    }
}
