package com.zurrtum.create.client.content.trains.entity;

import com.zurrtum.create.content.trains.entity.TrainIconType;
import net.minecraft.class_10799;
import net.minecraft.class_2960;
import net.minecraft.class_332;

import static com.zurrtum.create.Create.MOD_ID;

public record TrainIcon(TrainIconType type, class_2960 sheet, int x, int y) {
    public static final class_2960 ASSEMBLE = class_2960.method_60655(MOD_ID, "textures/gui/assemble.png");
    public static final int ENGINE = -1;
    public static final int FLIPPED_ENGINE = -2;

    public int render(int lengthOrEngine, class_332 graphics, int x, int y) {
        int offset = getIconOffset(lengthOrEngine);
        int width = getIconWidth(lengthOrEngine);
        graphics.method_25290(class_10799.field_56883, sheet, x, y, this.x + offset, this.y, width, 10, 256, 256);
        return width;
    }

    public int getIconWidth(int lengthOrEngine) {
        if (lengthOrEngine == FLIPPED_ENGINE)
            return 19;
        if (lengthOrEngine == ENGINE)
            return 19;
        if (lengthOrEngine < 3)
            return 7;
        if (lengthOrEngine < 9)
            return 13;
        return 19;
    }

    public int getIconOffset(int lengthOrEngine) {
        if (lengthOrEngine == FLIPPED_ENGINE)
            return 0;
        if (lengthOrEngine == ENGINE)
            return 62;
        if (lengthOrEngine < 3)
            return 34;
        if (lengthOrEngine < 9)
            return 20;
        return 42;
    }

}
