package com.zurrtum.create.client.content.trains.track;

import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.WorldAttached;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.utility.RaycastHelper;
import com.zurrtum.create.content.trains.track.*;
import com.zurrtum.create.infrastructure.component.BezierTrackPointLocation;
import net.minecraft.class_1921;
import net.minecraft.class_1934;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_238;
import net.minecraft.class_239.class_240;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5134;
import net.minecraft.class_746;
import net.minecraft.util.math.*;
import org.apache.commons.lang3.mutable.MutableBoolean;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;

public class TrackBlockOutline {

    public static WorldAttached<Map<class_2338, TrackBlockEntity>> TRACKS_WITH_TURNS = new WorldAttached<>(w -> new HashMap<>());

    public static BezierPointSelection result;

    public static void pickCurves(class_310 mc) {
        if (!(mc.field_1719 instanceof class_746 player))
            return;
        if (mc.field_1687 == null)
            return;

        class_243 origin = player.method_5836(AnimationTickHolder.getPartialTicks(mc.field_1687));

        double maxRange = mc.field_1765 == null ? Double.MAX_VALUE : mc.field_1765.method_17784().method_1025(origin);

        result = null;

        double range = player.method_45325(class_5134.field_47758);
        class_243 target = RaycastHelper.getTraceTarget(player, Math.min(maxRange, range) + 1, origin);
        Map<class_2338, TrackBlockEntity> turns = TRACKS_WITH_TURNS.get(mc.field_1687);

        for (TrackBlockEntity be : turns.values()) {
            for (BezierConnection bc : be.getConnections().values()) {
                if (!bc.isPrimary())
                    continue;

                class_238 bounds = bc.getBounds();
                if (!bounds.method_1006(origin) && bounds.method_992(origin, target).isEmpty())
                    continue;

                float[] stepLUT = bc.getStepLUT();
                int segments = (int) (bc.getLength() * 2);
                class_238 segmentBounds = AllShapes.TRACK_ORTHO.get(class_2350.field_11035).method_1107();
                segmentBounds = segmentBounds.method_989(-.5, segmentBounds.method_17940() / -2, -.5);

                int bestSegment = -1;
                double bestDistance = Double.MAX_VALUE;
                double newMaxRange = maxRange;

                for (int i = 0; i < stepLUT.length - 2; i++) {
                    float t = stepLUT[i] * i / segments;
                    float t1 = stepLUT[i + 1] * (i + 1) / segments;
                    float t2 = stepLUT[i + 2] * (i + 2) / segments;

                    class_243 v1 = bc.getPosition(t);
                    class_243 v2 = bc.getPosition(t2);
                    class_243 diff = v2.method_1020(v1);
                    class_243 angles = TrackRenderer.getModelAngles(bc.getNormal(t1), diff);

                    class_243 anchor = v1.method_1019(diff.method_1021(.5));
                    class_243 localOrigin = origin.method_1020(anchor);
                    class_243 localDirection = target.method_1020(origin);
                    localOrigin = VecHelper.rotate(localOrigin, AngleHelper.deg(-angles.field_1352), class_2351.field_11048);
                    localOrigin = VecHelper.rotate(localOrigin, AngleHelper.deg(-angles.field_1351), class_2351.field_11052);
                    localDirection = VecHelper.rotate(localDirection, AngleHelper.deg(-angles.field_1352), class_2351.field_11048);
                    localDirection = VecHelper.rotate(localDirection, AngleHelper.deg(-angles.field_1351), class_2351.field_11052);

                    Optional<class_243> clip = segmentBounds.method_992(localOrigin, localOrigin.method_1019(localDirection));
                    if (clip.isEmpty())
                        continue;

                    if (bestSegment != -1 && bestDistance < clip.get().method_1028(0, 0.25f, 0))
                        continue;

                    double distanceToSqr = clip.get().method_1025(localOrigin);
                    if (distanceToSqr > maxRange)
                        continue;

                    bestSegment = i;
                    newMaxRange = distanceToSqr;
                    bestDistance = clip.get().method_1028(0, 0.25f, 0);

                    BezierTrackPointLocation location = new BezierTrackPointLocation(bc.getKey(), i);
                    result = new BezierPointSelection(be, location, anchor, angles, diff.method_1029());
                }

                if (bestSegment != -1)
                    maxRange = newMaxRange;
            }
        }

        if (result == null)
            return;

        if (mc.field_1765 != null && mc.field_1765.method_17783() != class_240.field_1333) {
            class_243 priorLoc = mc.field_1765.method_17784();
            mc.field_1765 = class_3965.method_17778(priorLoc, class_2350.field_11036, class_2338.method_49638(priorLoc));
        }
    }

    public static void drawCurveSelection(class_310 mc, class_4587 ms, class_4597 buffer, class_243 camera) {
        if (mc.field_1690.field_1842 || mc.field_1761.method_2920() == class_1934.field_9219)
            return;

        BezierPointSelection result = TrackBlockOutline.result;
        if (result == null)
            return;

        class_4588 vb = buffer.getBuffer(class_1921.method_23594());
        class_243 vec = result.vec().method_1020(camera);
        class_243 angles = result.angles();
        TransformStack.of(ms).pushPose().translate(vec.field_1352, vec.field_1351 + .125f, vec.field_1350).rotateY((float) angles.field_1351).rotateX((float) angles.field_1352)
            .translate(-.5, -.125f, -.5);

        boolean holdingTrack = mc.field_1724.method_6047().method_31573(AllItemTags.TRACKS);
        renderShape(AllShapes.TRACK_ORTHO.get(class_2350.field_11035), ms, vb, holdingTrack ? false : null);
        ms.method_22909();
    }

    public static boolean drawCustomBlockSelection(
        class_310 mc,
        class_3965 target,
        class_4597 vertexConsumers,
        class_4184 camera,
        class_4587 ms
    ) {
        class_2338 pos = target.method_17777();
        class_2680 blockstate = mc.field_1687.method_8320(pos);

        if (!(blockstate.method_26204() instanceof TrackBlock))
            return false;
        if (!mc.field_1687.method_8621().method_11952(pos))
            return false;

        class_4588 vb = vertexConsumers.getBuffer(class_1921.method_23594());
        class_243 camPos = camera.method_19326();

        ms.method_22903();
        ms.method_22904(pos.method_10263() - camPos.field_1352, pos.method_10264() - camPos.field_1351, pos.method_10260() - camPos.field_1350);

        boolean holdingTrack = mc.field_1724.method_6047().method_31573(AllItemTags.TRACKS);
        TrackShape shape = blockstate.method_11654(TrackBlock.SHAPE);
        boolean canConnectFrom = !shape.isJunction() && !(mc.field_1687.method_8321(pos) instanceof TrackBlockEntity tbe && tbe.isTilted());

        MutableBoolean cancel = new MutableBoolean();
        walkShapes(
            shape, TransformStack.of(ms), s -> {
                renderShape(s, ms, vb, holdingTrack ? canConnectFrom : null);
                cancel.setTrue();
            }
        );

        ms.method_22909();
        return cancel.isTrue();
    }

    public static void renderShape(class_265 s, class_4587 ms, class_4588 vb, Boolean valid) {
        class_4587.class_4665 transform = ms.method_23760();
        s.method_1104((x1, y1, z1, x2, y2, z2) -> {
            float xDiff = (float) (x2 - x1);
            float yDiff = (float) (y2 - y1);
            float zDiff = (float) (z2 - z1);
            float length = class_3532.method_15355(xDiff * xDiff + yDiff * yDiff + zDiff * zDiff);

            xDiff /= length;
            yDiff /= length;
            zDiff /= length;

            float r = 0f;
            float g = 0f;
            float b = 0f;

            if (valid != null && valid) {
                g = 1f;
                b = 1f;
                r = 1f;
            }

            if (valid != null && !valid) {
                r = 1f;
                b = 0.125f;
                g = 0.25f;
            }

            vb.method_22918(transform.method_23761(), (float) x1, (float) y1, (float) z1).method_22915(r, g, b, .4f)
                .method_60831(transform.method_56822(), xDiff, yDiff, zDiff);
            vb.method_22918(transform.method_23761(), (float) x2, (float) y2, (float) z2).method_22915(r, g, b, .4f)
                .method_60831(transform.method_56822(), xDiff, yDiff, zDiff);

        });
    }

    private static final class_265 LONG_CROSS = class_259.method_1084(TrackVoxelShapes.longOrthogonalZ(), TrackVoxelShapes.longOrthogonalX());
    private static final class_265 LONG_ORTHO = TrackVoxelShapes.longOrthogonalZ();
    private static final class_265 LONG_ORTHO_OFFSET = TrackVoxelShapes.longOrthogonalZOffset();

    private static void walkShapes(TrackShape shape, TransformStack<?> msr, Consumer<class_265> renderer) {
        float angle45 = class_3532.field_29844 / 4;

        if (shape == TrackShape.XO || shape == TrackShape.CR_NDX || shape == TrackShape.CR_PDX)
            renderer.accept(AllShapes.TRACK_ORTHO.get(class_2350.field_11034));
        else if (shape == TrackShape.ZO || shape == TrackShape.CR_NDZ || shape == TrackShape.CR_PDZ)
            renderer.accept(AllShapes.TRACK_ORTHO.get(class_2350.field_11035));

        if (shape.isPortal()) {
            for (class_2350 d : Iterate.horizontalDirections) {
                if (TrackShape.asPortal(d) != shape)
                    continue;
                msr.rotateCentered(AngleHelper.rad(AngleHelper.horizontalAngle(d)), class_2350.field_11036);
                renderer.accept(LONG_ORTHO_OFFSET);
                return;
            }
        }

        if (shape == TrackShape.PD || shape == TrackShape.CR_PDX || shape == TrackShape.CR_PDZ) {
            msr.rotateCentered(angle45, class_2350.field_11036);
            renderer.accept(LONG_ORTHO);
        } else if (shape == TrackShape.ND || shape == TrackShape.CR_NDX || shape == TrackShape.CR_NDZ) {
            msr.rotateCentered(-class_3532.field_29844 / 4, class_2350.field_11036);
            renderer.accept(LONG_ORTHO);
        }

        if (shape == TrackShape.CR_O)
            renderer.accept(AllShapes.TRACK_CROSS);
        else if (shape == TrackShape.CR_D) {
            msr.rotateCentered(angle45, class_2350.field_11036);
            renderer.accept(LONG_CROSS);
        }

        if (!(shape == TrackShape.AE || shape == TrackShape.AN || shape == TrackShape.AW || shape == TrackShape.AS))
            return;

        msr.translate(0, 1, 0);
        msr.rotateCentered(class_3532.field_29844 - AngleHelper.rad(shape.getModelRotation()), class_2350.field_11036);
        msr.rotateX(angle45);
        msr.translate(0, -3 / 16f, 1 / 16f);
        renderer.accept(LONG_ORTHO);
    }

    public record BezierPointSelection(
        TrackBlockEntity blockEntity, BezierTrackPointLocation loc, class_243 vec, class_243 angles, class_243 direction
    ) {
    }

    public static void registerToCurveInteraction(TrackBlockEntity be) {
        TRACKS_WITH_TURNS.get(be.method_10997()).put(be.method_11016(), be);
    }

    public static void removeFromCurveInteraction(TrackBlockEntity be) {
        TRACKS_WITH_TURNS.get(be.method_10997()).remove(be.method_11016());
    }
}
