package com.zurrtum.create.client.flywheel.lib.transform;

import net.minecraft.class_2350;
import net.minecraft.class_3532;
import net.minecraft.class_7833;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;

public interface Rotate<Self extends Rotate<Self>> {
    Self rotate(Quaternionfc quaternion);

    default Self rotate(AxisAngle4f axisAngle) {
        return rotate(new Quaternionf(axisAngle));
    }

    default Self rotate(float radians, float axisX, float axisY, float axisZ) {
        if (radians == 0) {
            return self();
        }
        return rotate(new Quaternionf().setAngleAxis(radians, axisX, axisY, axisZ));

    }

    default Self rotate(float radians, class_7833 axis) {
        if (radians == 0) {
            return self();
        }
        return rotate(axis.rotation(radians));
    }

    default Self rotate(float radians, Vector3fc axis) {
        return rotate(radians, axis.x(), axis.y(), axis.z());
    }

    default Self rotate(float radians, class_2350 axis) {
        return rotate(radians, axis.method_10148(), axis.method_10164(), axis.method_10165());
    }

    default Self rotate(float radians, class_2350.class_2351 axis) {
        return rotate(radians, class_2350.method_10169(axis, class_2350.class_2352.field_11056));
    }

    default Self rotateDegrees(float degrees, float axisX, float axisY, float axisZ) {
        return rotate(class_3532.field_29847 * degrees, axisX, axisY, axisZ);
    }

    default Self rotateDegrees(float degrees, class_7833 axis) {
        return rotate(class_3532.field_29847 * degrees, axis);
    }

    default Self rotateDegrees(float degrees, Vector3fc axis) {
        return rotate(class_3532.field_29847 * degrees, axis);
    }

    default Self rotateDegrees(float degrees, class_2350 axis) {
        return rotate(class_3532.field_29847 * degrees, axis);
    }

    default Self rotateDegrees(float degrees, class_2350.class_2351 axis) {
        return rotate(class_3532.field_29847 * degrees, axis);
    }

    default Self rotateX(float radians) {
        return rotate(radians, class_7833.field_40714);
    }

    default Self rotateY(float radians) {
        return rotate(radians, class_7833.field_40716);
    }

    default Self rotateZ(float radians) {
        return rotate(radians, class_7833.field_40718);
    }

    default Self rotateXDegrees(float degrees) {
        return rotateX(class_3532.field_29847 * degrees);
    }

    default Self rotateYDegrees(float degrees) {
        return rotateY(class_3532.field_29847 * degrees);
    }

    default Self rotateZDegrees(float degrees) {
        return rotateZ(class_3532.field_29847 * degrees);
    }

    default Self rotateToFace(class_2350 facing) {
        return switch (facing) {
            case field_11033 -> rotateXDegrees(-90);
            case field_11036 -> rotateXDegrees(90);
            case field_11043 -> self();
            case field_11035 -> rotateYDegrees(180);
            case field_11039 -> rotateYDegrees(90);
            case field_11034 -> rotateYDegrees(270);
        };
    }

    default Self rotateTo(float fromX, float fromY, float fromZ, float toX, float toY, float toZ) {
        return rotate(new Quaternionf().rotationTo(fromX, fromY, fromZ, toX, toY, toZ));
    }

    default Self rotateTo(Vector3fc from, Vector3fc to) {
        return rotateTo(from.x(), from.y(), from.z(), to.x(), to.y(), to.z());
    }

    default Self rotateTo(class_2350 from, class_2350 to) {
        return rotateTo(from.method_10148(), from.method_10164(), from.method_10165(), to.method_10148(), to.method_10164(), to.method_10165());
    }

    @SuppressWarnings("unchecked")
    default Self self() {
        return (Self) this;
    }
}
