package com.zurrtum.create.client.foundation.blockEntity.behaviour.scrollValue;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBox;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBox.IconValueBox;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBox.TextValueBox;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_638;

public class ScrollValueRenderer {

    public static void tick(class_310 mc) {
        class_239 target = mc.field_1765;
        if (!(target instanceof class_3965 result))
            return;

        class_638 world = mc.field_1687;
        if (world == null) {
            return;
        }
        class_2338 pos = result.method_17777();
        class_2350 face = result.method_17780();

        if (!(world.method_8321(pos) instanceof SmartBlockEntity sbe)) {
            return;
        }

        ScrollValueBehaviour<?, ?> behaviour = sbe.getBehaviour(ScrollValueBehaviour.TYPE);
        if (behaviour == null) {
            return;
        }

        if (!behaviour.isActive()) {
            Outliner.getInstance().remove(behaviour);
            return;
        }

        class_1799 mainhandItem = mc.field_1724.method_5998(class_1268.field_5808);
        boolean clipboard = behaviour.bypassesInput(mainhandItem);
        if (behaviour.needsWrench && !mainhandItem.method_31574(AllItems.WRENCH) && !clipboard)
            return;
        boolean highlight = behaviour.testHit(target.method_17784()) && !clipboard;

        if (class_437.method_25441()) {
            List<? extends SmartBlockEntity> bulks = behaviour.getBulk();
            if (bulks != null) {
                for (SmartBlockEntity smartBlockEntity : bulks) {
                    if (smartBlockEntity.getBehaviour(ScrollValueBehaviour.TYPE) instanceof ScrollValueBehaviour<?, ?> other) {
                        addBox(smartBlockEntity.method_11016(), face, other, highlight);
                    }
                }
            } else {
                addBox(pos, face, behaviour, highlight);
            }
        } else {
            addBox(pos, face, behaviour, highlight);
        }

        if (!highlight)
            return;

        List<class_5250> tip = new ArrayList<>();
        tip.add(behaviour.label.method_27661());
        tip.add(CreateLang.translateDirect("gui.value_settings.hold_to_edit"));
        Create.VALUE_SETTINGS_HANDLER.showHoverTip(mc, tip);
    }

    protected static void addBox(class_2338 pos, class_2350 face, ScrollValueBehaviour<?, ?> behaviour, boolean highlight) {
        class_238 bb = new class_238(class_243.field_1353, class_243.field_1353).method_1014(.5f).method_1002(0, 0, -.5f).method_989(0, 0, -.125f);
        class_2561 label = behaviour.label;
        ValueBox box;

        if (behaviour instanceof ScrollOptionBehaviour<?> optionBehaviour) {
            box = new IconValueBox(label, optionBehaviour.getIconForSelected(), bb, pos);
        } else {
            box = new TextValueBox(label, bb, pos, class_2561.method_43470(behaviour.formatValue()));
        }

        box.passive(!highlight).wideOutline();

        Outliner.getInstance().showOutline(behaviour, box.transform(behaviour.slotPositioning)).highlightFace(face);
    }

}
