package com.zurrtum.create.client.foundation.entity.behaviour;

import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.AllSoundEvents.SoundEntry;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.animation.LerpedFloat.Chaser;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.trains.entity.*;
import com.zurrtum.create.content.trains.entity.Carriage.DimensionalCarriageEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.entity.behaviour.EntityBehaviour;
import net.minecraft.class_1101;
import net.minecraft.class_1113;
import net.minecraft.class_1146;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_359;

public class CarriageAudioBehaviour extends EntityBehaviour<CarriageContraptionEntity> {
    public static final BehaviourType<CarriageAudioBehaviour> TYPE = new BehaviourType<>();

    LerpedFloat distanceFactor;
    LerpedFloat speedFactor;
    LerpedFloat approachFactor;
    LerpedFloat seatCrossfade;

    LoopingSound minecartEsqueSound;
    LoopingSound sharedWheelSound;
    LoopingSound sharedWheelSoundSeated;
    LoopingSound sharedHonkSound;

    Couple<class_3414> bogeySounds;
    class_3414 closestBogeySound;

    boolean arrived;

    int tick;
    int prevSharedTick;

    public CarriageAudioBehaviour(CarriageContraptionEntity entity) {
        super(entity);
        distanceFactor = LerpedFloat.linear();
        speedFactor = LerpedFloat.linear();
        approachFactor = LerpedFloat.linear();
        seatCrossfade = LerpedFloat.linear();
        arrived = true;
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    @Override
    public void tick() {
        Contraption contraption = entity.getContraption();
        if (contraption == null)
            return;
        if (!(contraption instanceof CarriageContraption))
            return;
        Carriage carriage = entity.getCarriage();
        if (carriage == null)
            return;
        class_310 mc = class_310.method_1551();
        class_1297 camEntity = mc.field_1719;
        if (camEntity == null)
            return;
        DimensionalCarriageEntity dce = carriage.getDimensional(entity.method_37908());
        if (!dce.pointsInitialised)
            return;
        class_243 leadingAnchor = dce.leadingAnchor();
        if (leadingAnchor == null)
            return;
        class_243 trailingAnchor = dce.trailingAnchor();
        if (trailingAnchor == null)
            return;
        if (bogeySounds == null) {
            bogeySounds = carriage.bogeys.map(bogey -> bogey != null && bogey.getStyle() != null ? bogey.getStyle().soundEvent.get() : AllSoundEvents.TRAIN2.getMainEvent());
            closestBogeySound = bogeySounds.getFirst();
        }

        tick++;

        class_243 cam = camEntity.method_33571();
        class_243 contraptionMotion = entity.method_19538().method_1020(entity.getPrevPositionVec());
        class_243 combinedMotion = contraptionMotion.method_1020(camEntity.method_18798());

        Train train = carriage.train;

        if (arrived && contraptionMotion.method_1033() > 0.01f)
            arrived = false;
        if (arrived && entity.carriageIndex == 0)
            train.accumulatedSteamRelease /= 2;

        arrived |= entity.isStalled();

        if (entity.carriageIndex == 0)
            train.accumulatedSteamRelease = (float) Math.min(
                train.accumulatedSteamRelease + Math.min(
                    0.5f,
                    Math.abs(contraptionMotion.method_1033() / 10f)
                ), 10
            );

        class_243 toBogey1 = leadingAnchor.method_1020(cam);
        class_243 toBogey2 = trailingAnchor.method_1020(cam);
        double distance1 = toBogey1.method_1033();
        double distance2 = toBogey2.method_1033();

        Couple<CarriageBogey> bogeys = carriage.bogeys;
        CarriageBogey relevantBogey = bogeys.get(distance1 > distance2);
        if (relevantBogey == null) {
            relevantBogey = bogeys.getFirst();
        }
        if (relevantBogey != null) {
            closestBogeySound = relevantBogey.getStyle().soundEvent.get();
        }

        class_243 toCarriage = distance1 > distance2 ? toBogey2 : toBogey1;
        double distance = Math.min(distance1, distance2);
        class_243 soundLocation = cam.method_1019(toCarriage);

        double dot = toCarriage.method_1029().method_1026(combinedMotion.method_1029());

        speedFactor.chase(contraptionMotion.method_1033(), .25f, Chaser.exp(.05f));
        distanceFactor.chase(class_3532.method_15390(100, 0, (distance - 3) / 64d), .25f, Chaser.exp(50f));
        approachFactor.chase(class_3532.method_15390(50, 200, .5f * (dot + 1)), .25f, Chaser.exp(10f));
        seatCrossfade.chase(camEntity.method_5854() instanceof CarriageContraptionEntity ? 1 : 0, .1f, Chaser.EXP);

        speedFactor.tickChaser();
        distanceFactor.tickChaser();
        approachFactor.tickChaser();
        seatCrossfade.tickChaser();

        minecartEsqueSound = playIfMissing(mc, minecartEsqueSound, AllSoundEvents.TRAIN.getMainEvent());
        sharedWheelSound = playIfMissing(mc, sharedWheelSound, closestBogeySound);
        sharedWheelSoundSeated = playIfMissing(mc, sharedWheelSoundSeated, AllSoundEvents.TRAIN3.getMainEvent());

        float volume = Math.min(Math.min(speedFactor.getValue(), distanceFactor.getValue() / 100), approachFactor.getValue() / 300 + .0125f);

        if (entity.carriageIndex == 0) {
            float v = volume * (1 - seatCrossfade.getValue() * .35f) * .75f;
            if ((3 + tick) % 4 == 0)
                AllSoundEvents.STEAM.playAt(entity.method_37908(), soundLocation, v * ((tick + 7) % 8 == 0 ? 0.75f : .45f), 1.17f, false);
            if (tick % 16 == 0)
                AllSoundEvents.STEAM.playAt(entity.method_37908(), soundLocation, v * 1.5f, .8f, false);
        }

        if (!arrived && speedFactor.getValue() < .002f && train.accumulatedSteamRelease > 1) {
            arrived = true;
            float releaseVolume = train.accumulatedSteamRelease / 10f;
            entity.method_37908().method_8486(
                soundLocation.field_1352,
                soundLocation.field_1351,
                soundLocation.field_1350,
                class_3417.field_19198,
                class_3419.field_15254,
                .25f * releaseVolume,
                .78f,
                false
            );
            entity.method_37908().method_8486(
                soundLocation.field_1352,
                soundLocation.field_1351,
                soundLocation.field_1350,
                class_3417.field_15080,
                class_3419.field_15254,
                .2f * releaseVolume,
                1.5f,
                false
            );
            AllSoundEvents.STEAM.playAt(entity.method_37908(), soundLocation, .75f * releaseVolume, .5f, false);
        }

        float pitchModifier = ((entity.method_5628() * 10) % 13) / 36f;

        volume = Math.min(volume, distanceFactor.getValue() / 800);

        float pitch = class_3532.method_15363(speedFactor.getValue() * 2 + .25f, .75f, 1.95f) - pitchModifier;
        //		float pitch2 = Mth.clamp(speedFactor.getValue() * 2, 0.75f, 1.25f) - pitchModifier;

        minecartEsqueSound.setPitch(pitch * 1.5f);

        volume = Math.min(volume, distanceFactor.getValue() / 1000);

        for (Carriage trainCarriage : train.carriages) {
            DimensionalCarriageEntity mainDCE = carriage.getDimensionalIfPresent(entity.method_37908().method_27983());
            if (mainDCE == null)
                continue;
            CarriageContraptionEntity mainEntity = mainDCE.entity.get();
            if (mainEntity == null)
                continue;
            CarriageAudioBehaviour behaviour = mainEntity.getBehaviour(TYPE);
            if (behaviour != null)
                behaviour.submitSharedSoundVolume(mc, soundLocation, volume);
            if (trainCarriage != carriage) {
                finalizeSharedVolume(0);
                return;
            }
            break;
        }

        //		finalizeSharedVolume(volume);
        //		minecartEsqueSound.setLocation(soundLocation);
        //		sharedWheelSound.setPitch(pitch2);
        //		sharedWheelSound.setLocation(soundLocation);
        //		sharedWheelSoundSeated.setPitch(pitch2);
        //		sharedWheelSoundSeated.setLocation(soundLocation);

        if (train.honkTicks == 0) {
            if (sharedHonkSound != null) {
                sharedHonkSound.stopSound();
                sharedHonkSound = null;
            }
            return;
        }

        train.honkTicks--;
        train.determineHonk(entity.method_37908());

        if (train.lowHonk == null)
            return;

        boolean low = train.lowHonk;
        float honkPitch = (float) Math.pow(2, train.honkPitch / 12.0);

        SoundEntry endSound = !low ? AllSoundEvents.WHISTLE_TRAIN_MANUAL_END : AllSoundEvents.WHISTLE_TRAIN_MANUAL_LOW_END;
        SoundEntry continuousSound = !low ? AllSoundEvents.WHISTLE_TRAIN_MANUAL : AllSoundEvents.WHISTLE_TRAIN_MANUAL_LOW;

        if (train.honkTicks == 5)
            endSound.playAt(mc.field_1687, soundLocation, 1, honkPitch, false);
        if (train.honkTicks == 19)
            endSound.playAt(mc.field_1687, soundLocation, .5f, honkPitch, false);

        sharedHonkSound = playIfMissing(mc, sharedHonkSound, continuousSound.getMainEvent(), true);
        sharedHonkSound.setLocation(soundLocation);
        float fadeout = class_3532.method_15363((3 - train.honkTicks) / 3f, 0, 1);
        float fadein = class_3532.method_15363((train.honkTicks - 17) / 3f, 0, 1);
        sharedHonkSound.setVolume(1 - fadeout - fadein);
        sharedHonkSound.setPitch(honkPitch);

    }

    private LoopingSound playIfMissing(class_310 mc, LoopingSound loopingSound, class_3414 sound) {
        return playIfMissing(mc, loopingSound, sound, false);
    }

    private LoopingSound playIfMissing(class_310 mc, LoopingSound loopingSound, class_3414 sound, boolean continuouslyShowSubtitle) {
        if (loopingSound == null) {
            loopingSound = new LoopingSound(sound, class_3419.field_15254, continuouslyShowSubtitle);
            mc.method_1483().method_4873(loopingSound);
        }
        return loopingSound;
    }

    public void submitSharedSoundVolume(class_310 mc, class_243 location, float volume) {
        minecartEsqueSound = playIfMissing(mc, minecartEsqueSound, AllSoundEvents.TRAIN.getMainEvent());
        sharedWheelSound = playIfMissing(mc, sharedWheelSound, closestBogeySound);
        sharedWheelSoundSeated = playIfMissing(mc, sharedWheelSoundSeated, AllSoundEvents.TRAIN3.getMainEvent());

        boolean approach = true;

        if (tick != prevSharedTick) {
            prevSharedTick = tick;
            approach = false;
        } else if (sharedWheelSound.method_4781() > volume)
            return;

        class_243 currentLoc = new class_243(minecartEsqueSound.method_4784(), minecartEsqueSound.method_4779(), minecartEsqueSound.method_4778());
        class_243 newLoc = approach ? currentLoc.method_1019(location.method_1020(currentLoc).method_1021(.125f)) : location;

        minecartEsqueSound.setLocation(newLoc);
        sharedWheelSound.setLocation(newLoc);
        sharedWheelSoundSeated.setLocation(newLoc);
        finalizeSharedVolume(volume);
    }

    public void finalizeSharedVolume(float volume) {
        float crossfade = seatCrossfade.getValue();
        minecartEsqueSound.setVolume((1 - crossfade * .65f) * volume / 2);
        volume = Math.min(volume, Math.max((speedFactor.getValue() - .25f) / 4 + 0.01f, 0));
        sharedWheelSoundSeated.setVolume(volume * crossfade);
        sharedWheelSound.setVolume(volume * (1 - crossfade) * 1.5f);
    }

    @Override
    public void destroy() {
        if (minecartEsqueSound != null)
            minecartEsqueSound.stopSound();
        if (sharedWheelSound != null)
            sharedWheelSound.stopSound();
        if (sharedWheelSoundSeated != null)
            sharedWheelSoundSeated.stopSound();
        if (sharedHonkSound != null)
            sharedHonkSound.stopSound();
    }

    static class LoopingSound extends class_1101 {
        private static final class_359 OVERLAY = class_310.method_1551().field_1705.field_2027;

        private final boolean repeatSubtitle;
        private final class_1146 weighedSoundEvents = method_4783(class_310.method_1551().method_1483());
        private byte subtitleTimer = 0;

        protected LoopingSound(class_3414 soundEvent, class_3419 source, boolean repeatSubtitle) {
            super(soundEvent, source, class_1113.method_43221());
            this.field_5446 = true;
            this.field_5451 = 0;
            this.field_5442 = 0.0001f;
            this.repeatSubtitle = repeatSubtitle;
        }

        @Override
        public void method_16896() {
            if (repeatSubtitle) {
                subtitleTimer++;

                if (subtitleTimer == 20) {
                    OVERLAY.method_4884(this, weighedSoundEvents, field_5444.method_4770());
                    subtitleTimer = 0;
                }
            }
        }

        public void setVolume(float volume) {
            this.field_5442 = volume;
        }

        @Override
        public float method_4781() {
            return field_5442;
        }

        public void setPitch(float pitch) {
            this.field_5441 = pitch;
        }

        @Override
        public float method_4782() {
            return field_5441;
        }

        public void setLocation(class_243 location) {
            field_5439 = location.field_1352;
            field_5450 = location.field_1351;
            field_5449 = location.field_1350;
        }

        public void stopSound() {
            class_310.method_1551().method_1483().method_4870(this);
        }

    }
}
