package com.zurrtum.create.client.foundation.entity.behaviour;

import com.zurrtum.create.client.content.trains.entity.CarriageContraptionVisual;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.CarriageContraption;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.entity.behaviour.EntityBehaviour;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;

public class PortalCutoffBehaviour extends EntityBehaviour<CarriageContraptionEntity> {
    public static final BehaviourType<PortalCutoffBehaviour> TYPE = new BehaviourType<>();
    private CarriageContraptionVisual visual;

    public PortalCutoffBehaviour(CarriageContraptionEntity entity) {
        super(entity);
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    public void setVisual(CarriageContraptionVisual visual) {
        this.visual = visual;
    }

    public void updateRenderedPortalCutoff() {
        Carriage carriage = entity.getCarriage();
        if (carriage == null)
            return;

        // update portal slice
        entity.particleSlice.clear();
        entity.particleAvgY = 0;

        if (entity.getContraption() instanceof CarriageContraption cc) {
            class_2350 forward = cc.getAssemblyDirection().method_10170();
            class_2351 axis = forward.method_10166();
            boolean x = axis == class_2351.field_11048;
            for (class_2338 pos : entity.getContraption().getBlocks().keySet()) {
                if (!cc.atSeam(pos))
                    continue;
                int pX = x ? pos.method_10263() : pos.method_10260();
                pX *= forward.method_10171().method_10181();
                pos = new class_2338(pX, pos.method_10264(), 0);
                entity.particleSlice.add(pos);
                entity.particleAvgY += pos.method_10264();
            }

        }
        if (!entity.particleSlice.isEmpty())
            entity.particleAvgY /= entity.particleSlice.size();

        // update hidden bogeys (if instanced)
        if (visual == null)
            return;
        int bogeySpacing = carriage.bogeySpacing;

        carriage.bogeys.forEachWithContext((bogey, first) -> {
            if (bogey == null)
                return;

            class_2338 bogeyPos = bogey.isLeading ? class_2338.field_10980 : class_2338.field_10980.method_10079(
                entity.getInitialOrientation().method_10160(),
                bogeySpacing
            );
            visual.setBogeyVisibility(first, !entity.getContraption().isHiddenInPortal(bogeyPos));
        });
    }
}
