package com.zurrtum.create.client.foundation.gui;

import com.mojang.blaze3d.opengl.GlStateManager;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5684;

public class RemovedGuiUtils {
    public static final int DEFAULT_BACKGROUND_COLOR = 0xF0100010;
    public static final int DEFAULT_BORDER_COLOR_START = 0x505000FF;
    public static final int DEFAULT_BORDER_COLOR_END = (DEFAULT_BORDER_COLOR_START & 0xFEFEFE) >> 1 | DEFAULT_BORDER_COLOR_START & 0xFF000000;
    @NotNull
    private static class_1799 cachedTooltipStack = class_1799.field_8037;

    public static void preItemToolTip(@NotNull class_1799 stack) {
        cachedTooltipStack = stack;
    }

    public static void postItemToolTip() {
        cachedTooltipStack = class_1799.field_8037;
    }

    public static void drawHoveringText(
        class_332 graphics,
        List<? extends class_5348> textLines,
        int mouseX,
        int mouseY,
        int screenWidth,
        int screenHeight,
        int maxTextWidth,
        class_327 font
    ) {
        drawHoveringText(
            graphics,
            textLines,
            mouseX,
            mouseY,
            screenWidth,
            screenHeight,
            maxTextWidth,
            DEFAULT_BACKGROUND_COLOR,
            DEFAULT_BORDER_COLOR_START,
            DEFAULT_BORDER_COLOR_END,
            font
        );
    }

    public static void drawHoveringText(
        class_332 graphics,
        List<? extends class_5348> textLines,
        int mouseX,
        int mouseY,
        int screenWidth,
        int screenHeight,
        int maxTextWidth,
        int backgroundColor,
        int borderColorStart,
        int borderColorEnd,
        class_327 font
    ) {
        drawHoveringText(
            cachedTooltipStack,
            graphics,
            textLines,
            mouseX,
            mouseY,
            screenWidth,
            screenHeight,
            maxTextWidth,
            backgroundColor,
            borderColorStart,
            borderColorEnd,
            font
        );
    }

    public static void drawHoveringText(
        @NotNull final class_1799 stack,
        class_332 graphics,
        List<? extends class_5348> textLines,
        int mouseX,
        int mouseY,
        int screenWidth,
        int screenHeight,
        int maxTextWidth,
        class_327 font
    ) {
        drawHoveringText(
            stack,
            graphics,
            textLines,
            mouseX,
            mouseY,
            screenWidth,
            screenHeight,
            maxTextWidth,
            DEFAULT_BACKGROUND_COLOR,
            DEFAULT_BORDER_COLOR_START,
            DEFAULT_BORDER_COLOR_END,
            font
        );
    }

    public static void drawHoveringText(
        @NotNull final class_1799 stack,
        class_332 graphics,
        List<? extends class_5348> textLines,
        int mouseX,
        int mouseY,
        int screenWidth,
        int screenHeight,
        int maxTextWidth,
        int backgroundColor,
        int borderColorStart,
        int borderColorEnd,
        class_327 font
    ) {
        if (textLines.isEmpty())
            return;

        List<class_5684> list = new ArrayList<>();
        for (class_5348 textLine : textLines) {
            class_5481 charSequence = textLine instanceof class_2561 text ? text.method_30937() : class_2477.method_10517().method_30934(textLine);
            list.add(class_5684.method_32662(charSequence));
        }

        GlStateManager._disableDepthTest();
        int tooltipTextWidth = 0;

        for (class_5348 textLine : textLines) {
            int textLineWidth = font.method_27525(textLine);
            if (textLineWidth > tooltipTextWidth)
                tooltipTextWidth = textLineWidth;
        }

        boolean needsWrap = false;

        int titleLinesCount = 1;
        int tooltipX = mouseX + 12;
        if (tooltipX + tooltipTextWidth + 4 > screenWidth) {
            tooltipX = mouseX - 16 - tooltipTextWidth;
            if (tooltipX < 4) // if the tooltip doesn't fit on the screen
            {
                if (mouseX > screenWidth / 2)
                    tooltipTextWidth = mouseX - 12 - 8;
                else
                    tooltipTextWidth = screenWidth - 16 - mouseX;
                needsWrap = true;
            }
        }

        if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
            tooltipTextWidth = maxTextWidth;
            needsWrap = true;
        }

        if (needsWrap) {
            int wrappedTooltipWidth = 0;
            List<class_5348> wrappedTextLines = new ArrayList<>();
            for (int i = 0; i < textLines.size(); i++) {
                class_5348 textLine = textLines.get(i);
                List<class_5348> wrappedLine = font.method_27527().method_27495(textLine, tooltipTextWidth, class_2583.field_24360);
                if (i == 0)
                    titleLinesCount = wrappedLine.size();

                for (class_5348 line : wrappedLine) {
                    int lineWidth = font.method_27525(line);
                    if (lineWidth > wrappedTooltipWidth)
                        wrappedTooltipWidth = lineWidth;
                    wrappedTextLines.add(line);
                }
            }
            tooltipTextWidth = wrappedTooltipWidth;
            textLines = wrappedTextLines;

            if (mouseX > screenWidth / 2)
                tooltipX = mouseX - 16 - tooltipTextWidth;
            else
                tooltipX = mouseX + 12;
        }

        int tooltipY = mouseY - 12;
        int tooltipHeight = 8;

        if (textLines.size() > 1) {
            tooltipHeight += (textLines.size() - 1) * 10;
            if (textLines.size() > titleLinesCount)
                tooltipHeight += 2; // gap between title lines and next lines
        }

        if (tooltipY < 4)
            tooltipY = 4;
        else if (tooltipY + tooltipHeight + 4 > screenHeight)
            tooltipY = screenHeight - tooltipHeight - 4;

        graphics.method_25296(tooltipX - 3, tooltipY - 4, tooltipX + tooltipTextWidth + 3, tooltipY - 3, backgroundColor, backgroundColor);
        graphics.method_25296(
            tooltipX - 3,
            tooltipY + tooltipHeight + 3,
            tooltipX + tooltipTextWidth + 3,
            tooltipY + tooltipHeight + 4,
            backgroundColor,
            backgroundColor
        );
        graphics.method_25296(
            tooltipX - 3,
            tooltipY - 3,
            tooltipX + tooltipTextWidth + 3,
            tooltipY + tooltipHeight + 3,
            backgroundColor,
            backgroundColor
        );
        graphics.method_25296(tooltipX - 4, tooltipY - 3, tooltipX - 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
        graphics.method_25296(
            tooltipX + tooltipTextWidth + 3,
            tooltipY - 3,
            tooltipX + tooltipTextWidth + 4,
            tooltipY + tooltipHeight + 3,
            backgroundColor,
            backgroundColor
        );
        graphics.method_25296(tooltipX - 3, tooltipY - 3 + 1, tooltipX - 3 + 1, tooltipY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
        graphics.method_25296(
            tooltipX + tooltipTextWidth + 2,
            tooltipY - 3 + 1,
            tooltipX + tooltipTextWidth + 3,
            tooltipY + tooltipHeight + 3 - 1,
            borderColorStart,
            borderColorEnd
        );
        graphics.method_25296(tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY - 3 + 1, borderColorStart, borderColorStart);
        graphics.method_25296(
            tooltipX - 3,
            tooltipY + tooltipHeight + 2,
            tooltipX + tooltipTextWidth + 3,
            tooltipY + tooltipHeight + 3,
            borderColorEnd,
            borderColorEnd
        );

        for (int lineNumber = 0; lineNumber < list.size(); ++lineNumber) {
            class_5684 line = list.get(lineNumber);

            if (line != null)
                line.method_32665(graphics, font, tooltipX, tooltipY);

            if (lineNumber + 1 == titleLinesCount)
                tooltipY += 2;

            tooltipY += line == null ? 10 : line.method_32661(font);
        }

        GlStateManager._enableDepthTest();
    }
}
