package com.zurrtum.create.client.foundation.gui.render;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.flywheel.lib.model.baked.SinglePosVirtualBlockGetter;
import com.zurrtum.create.content.kinetics.saw.SawBlock;
import net.minecraft.class_10889;
import net.minecraft.class_11239;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_776;
import net.minecraft.class_7833;
import net.minecraft.client.render.*;
import java.util.List;

public class SawRenderer extends class_11239<SawRenderState> {
    public SawRenderer(class_4597.class_4598 vertexConsumers) {
        super(vertexConsumers);
    }

    @Override
    protected void render(SawRenderState state, class_4587 matrices) {
        class_310 mc = class_310.method_1551();
        mc.field_1773.method_71114().method_71034(class_308.class_11274.field_60028);
        matrices.method_22905(1, 1, -1);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(-15.5f));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(112.5f));
        matrices.method_46416(-0.5f, -0.2f, -0.5f);
        matrices.method_22905(1, -1, 1);

        class_2680 blockState;
        List<class_10889> parts;
        class_776 blockRenderManager = mc.method_1541();
        SinglePosVirtualBlockGetter world = SinglePosVirtualBlockGetter.createFullBright();
        class_4588 buffer = field_59933.getBuffer(class_4722.method_24074());

        matrices.method_22903();
        blockState = AllBlocks.SHAFT.method_9564().method_11657(class_2741.field_12496, class_2351.field_11048);
        world.blockState(blockState);
        parts = blockRenderManager.method_3349(blockState).method_68512(mc.field_1687.field_9229);
        matrices.method_46416(0.5f, 0.5f, 0.5f);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(getCurrentAngle()));
        matrices.method_46416(-0.5f, -0.5f, -0.5f);
        blockRenderManager.method_3355(blockState, class_2338.field_10980, world, matrices, buffer, false, parts);
        matrices.method_22909();

        blockState = AllBlocks.MECHANICAL_SAW.method_9564().method_11657(SawBlock.FACING, class_2350.field_11036);
        world.blockState(blockState);
        parts = blockRenderManager.method_3349(blockState).method_68512(mc.field_1687.field_9229);
        blockRenderManager.method_3355(blockState, class_2338.field_10980, world, matrices, buffer, false, parts);

        blockState = class_2246.field_10124.method_9564();
        world.blockState(blockState);
        parts = List.of(AllPartialModels.SAW_BLADE_VERTICAL_ACTIVE.get());
        matrices.method_46416(0.5f, 0.5f, 0.5f);
        matrices.method_22907(class_7833.field_40718.rotationDegrees(-90));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(-90));
        matrices.method_46416(-0.5f, -0.5f, -0.5f);
        blockRenderManager.method_3355(
            blockState,
            class_2338.field_10980,
            world,
            matrices,
            field_59933.getBuffer(class_1921.method_23579()),
            false,
            parts
        );
    }

    public static float getCurrentAngle() {
        return -(AnimationTickHolder.getRenderTime() * 4f) % 360;
    }

    @Override
    protected String method_70906() {
        return "Saw";
    }

    @Override
    public Class<SawRenderState> method_70903() {
        return SawRenderState.class;
    }

}
