package com.zurrtum.create.client.foundation.model;

import com.mojang.blaze3d.vertex.VertexFormat;
import com.zurrtum.create.client.model.NormalsBakedQuad;
import java.util.Arrays;
import net.minecraft.class_243;
import net.minecraft.class_290;
import net.minecraft.class_3532;
import net.minecraft.class_777;

public final class BakedQuadHelper {

    public static final VertexFormat FORMAT = class_290.field_1590;
    public static final int VERTEX_STRIDE = FORMAT.getVertexSize() / 4;

    public static final int X_OFFSET = 0;
    public static final int Y_OFFSET = 1;
    public static final int Z_OFFSET = 2;
    public static final int COLOR_OFFSET = 3;
    public static final int U_OFFSET = 4;
    public static final int V_OFFSET = 5;
    public static final int LIGHT_OFFSET = 6;
    public static final int NORMAL_OFFSET = 7;

    private BakedQuadHelper() {
    }

    public static class_777 clone(class_777 quad) {
        class_777 bakedQuad = new class_777(
            Arrays.copyOf(quad.comp_3721(), quad.comp_3721().length),
            quad.comp_3722(),
            quad.comp_3723(),
            quad.comp_3724(),
            quad.comp_3725(),
            quad.comp_3726()
        );
        if (NormalsBakedQuad.hasNormals(quad)) {
            NormalsBakedQuad.markNormals(bakedQuad);
        }
        return bakedQuad;
    }

    public static class_777 cloneWithCustomGeometry(class_777 quad, int[] vertexData) {
        class_777 bakedQuad = new class_777(vertexData, quad.comp_3722(), quad.comp_3723(), quad.comp_3724(), quad.comp_3725(), quad.comp_3726());
        if (NormalsBakedQuad.hasNormals(quad)) {
            NormalsBakedQuad.markNormals(bakedQuad);
        }
        return bakedQuad;
    }

    public static class_243 getXYZ(int[] vertexData, int vertex) {
        float x = Float.intBitsToFloat(vertexData[vertex * VERTEX_STRIDE + X_OFFSET]);
        float y = Float.intBitsToFloat(vertexData[vertex * VERTEX_STRIDE + Y_OFFSET]);
        float z = Float.intBitsToFloat(vertexData[vertex * VERTEX_STRIDE + Z_OFFSET]);
        return new class_243(x, y, z);
    }

    public static void setXYZ(int[] vertexData, int vertex, class_243 xyz) {
        vertexData[vertex * VERTEX_STRIDE + X_OFFSET] = Float.floatToRawIntBits((float) xyz.field_1352);
        vertexData[vertex * VERTEX_STRIDE + Y_OFFSET] = Float.floatToRawIntBits((float) xyz.field_1351);
        vertexData[vertex * VERTEX_STRIDE + Z_OFFSET] = Float.floatToRawIntBits((float) xyz.field_1350);
    }

    public static class_243 getNormalXYZ(int[] vertexData, int vertex) {
        int data = vertexData[vertex * VERTEX_STRIDE + NORMAL_OFFSET];
        float x = (byte) (data >> 24 & 0xFF) / 127f;
        float y = (byte) (data >> 16 & 0xFF) / 127f;
        float z = (byte) (data >> 8 & 0xFF) / 127f;
        return new class_243(x, y, z);
    }

    public static void setNormalXYZ(int[] vertexData, int vertex, class_243 xyz) {
        int x = Byte.toUnsignedInt((byte) (class_3532.method_15350(xyz.field_1352, -1.0f, 1.0f) * 127));
        int y = Byte.toUnsignedInt((byte) (class_3532.method_15350(xyz.field_1351, -1.0f, 1.0f) * 127));
        int z = Byte.toUnsignedInt((byte) (class_3532.method_15350(xyz.field_1350, -1.0f, 1.0f) * 127));
        int data = (x << 24) | (y << 16) | (z << 8);
        vertexData[vertex * VERTEX_STRIDE + NORMAL_OFFSET] = data;
    }

    public static float getU(int[] vertexData, int vertex) {
        return Float.intBitsToFloat(vertexData[vertex * VERTEX_STRIDE + U_OFFSET]);
    }

    public static float getV(int[] vertexData, int vertex) {
        return Float.intBitsToFloat(vertexData[vertex * VERTEX_STRIDE + V_OFFSET]);
    }

    public static void setU(int[] vertexData, int vertex, float u) {
        vertexData[vertex * VERTEX_STRIDE + U_OFFSET] = Float.floatToRawIntBits(u);
    }

    public static void setV(int[] vertexData, int vertex, float v) {
        vertexData[vertex * VERTEX_STRIDE + V_OFFSET] = Float.floatToRawIntBits(v);
    }

}
