package com.zurrtum.create.client.infrastructure.particle;

import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.infrastructure.particle.AirParticleData;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4002;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_708;
import net.minecraft.class_761;

public class AirParticle extends class_708 {

    private float originX, originY, originZ;
    private float targetX, targetY, targetZ;
    private float drag;

    private float twirlRadius, twirlAngleOffset;
    private class_2350.class_2351 twirlAxis;

    protected AirParticle(
        class_638 world,
        AirParticleData data,
        double x,
        double y,
        double z,
        double dx,
        double dy,
        double dz,
        class_4002 sprite
    ) {
        super(world, x, y, z, sprite, world.field_9229.method_43057() * .5f);
        field_17867 *= 0.75F;
        field_3862 = false;

        method_3063(x, y, z);
        originX = (float) (field_3858 = x);
        originY = (float) (field_3838 = y);
        originZ = (float) (field_3856 = z);
        targetX = (float) (x + dx);
        targetY = (float) (y + dy);
        targetZ = (float) (z + dz);
        drag = data.drag();

        twirlRadius = world.field_9229.method_43057() / 6;
        twirlAngleOffset = world.field_9229.method_43057() * 360;
        twirlAxis = world.field_9229.method_43056() ? class_2350.class_2351.field_11048 : class_2350.class_2351.field_11051;

        // speed in m/ticks
        double length = new class_243(dx, dy, dz).method_1033();
        field_3847 = Math.min((int) (length / data.speed()), 60);
        selectSprite(7);
        method_3083(.25f);

        if (length == 0) {
            method_3085();
            method_3083(0);
        }
    }

    @Override
    public void method_3070() {
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
        if (this.field_3866++ >= this.field_3847) {
            this.method_3085();
            return;
        }

        float progress = (float) Math.pow(((float) field_3866) / field_3847, drag);
        float angle = (progress * 2 * 360 + twirlAngleOffset) % 360;
        class_243 twirl = VecHelper.rotate(new class_243(0, twirlRadius, 0), angle, twirlAxis);

        float x = (float) (class_3532.method_16439(progress, originX, targetX) + twirl.field_1352);
        float y = (float) (class_3532.method_16439(progress, originY, targetY) + twirl.field_1351);
        float z = (float) (class_3532.method_16439(progress, originZ, targetZ) + twirl.field_1350);

        field_3852 = x - this.field_3874;
        field_3869 = y - this.field_3854;
        field_3850 = z - this.field_3871;

        method_18142(field_17866);
        this.method_3069(this.field_3852, this.field_3869, this.field_3850);
    }

    public int method_3068(float partialTick) {
        class_2338 blockpos = class_2338.method_49637(this.field_3874, this.field_3854, this.field_3871);
        return this.field_3851.method_8477(blockpos) ? class_761.method_23794(field_3851, blockpos) : 0;
    }

    private void selectSprite(int index) {
        method_18141(field_17866.method_18138(index, 8));
    }

    public static class Factory implements class_707<AirParticleData> {
        private final class_4002 spriteSet;

        public Factory(class_4002 animatedSprite) {
            this.spriteSet = animatedSprite;
        }

        public class_703 createParticle(
            AirParticleData data,
            class_638 worldIn,
            double x,
            double y,
            double z,
            double xSpeed,
            double ySpeed,
            double zSpeed
        ) {
            return new AirParticle(worldIn, data, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }

}
