package com.zurrtum.create.client.infrastructure.ponder.scenes;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.client.foundation.ponder.CreateSceneBuilder;
import com.zurrtum.create.client.ponder.api.PonderPalette;
import com.zurrtum.create.client.ponder.api.element.ElementLink;
import com.zurrtum.create.client.ponder.api.element.EntityElement;
import com.zurrtum.create.client.ponder.api.scene.SceneBuilder;
import com.zurrtum.create.client.ponder.api.scene.SceneBuildingUtil;
import com.zurrtum.create.client.ponder.api.scene.Selection;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCrafterBlock;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCrafterBlockEntity;
import java.util.Collection;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;

public class CrafterScenes {

    public static void setup(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("mechanical_crafter", "Setting up Mechanical Crafters");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.world().modifyKineticSpeed(util.select().everywhere(), f -> 1.5f * f);

        Selection redstone = util.select().fromTo(3, 1, 0, 3, 1, 1);
        Selection kinetics = util.select().fromTo(4, 1, 2, 4, 1, 5);
        class_2338 depotPos = util.grid().at(0, 1, 2);
        Selection crafters = util.select().fromTo(1, 1, 2, 3, 3, 2);

        scene.world().modifyBlocks(crafters, s -> s.method_11657(MechanicalCrafterBlock.POINTING, Pointing.DOWN), false);
        scene.world().setKineticSpeed(crafters, 0);

        for (int y = 0; y < 3; y++) {
            for (int x = 0; x < 3; x++) {
                scene.world().showSection(util.select().position(y == 1 ? x + 1 : 3 - x, y + 1, 2), class_2350.field_11033);
                scene.idle(2);
            }
        }

        scene.overlay().showText(70).text("An array of Mechanical Crafters can be used to automate any Crafting Recipe")
            .pointAt(util.vector().blockSurface(util.grid().at(1, 2, 2), class_2350.field_11039)).attachKeyFrame().placeNearTarget();
        scene.idle(80);

        scene.overlay().showControls(util.vector().blockSurface(util.grid().at(2, 3, 2), class_2350.field_11043), Pointing.RIGHT, 40).rightClick()
            .withItem(AllItems.WRENCH.method_7854());
        scene.idle(7);
        scene.world().cycleBlockProperty(util.grid().at(2, 3, 2), MechanicalCrafterBlock.POINTING);
        scene.idle(10);
        scene.overlay().showText(50).text("Using a Wrench, the Crafters' paths can be arranged")
            .pointAt(util.vector().blockSurface(util.grid().at(2, 3, 2), class_2350.field_11043)).attachKeyFrame().placeNearTarget();
        scene.idle(60);

        class_2338[] positions = new class_2338[]{util.grid().at(3, 1, 2), util.grid().at(2, 1, 2), util.grid().at(1, 1, 2)};

        for (class_2338 pos : positions) {
            scene.overlay().showControls(util.vector().blockSurface(pos, class_2350.field_11043), Pointing.RIGHT, 10).rightClick()
                .withItem(AllItems.WRENCH.method_7854());
            scene.idle(7);
            scene.world().cycleBlockProperty(pos, MechanicalCrafterBlock.POINTING);
            scene.idle(15);
        }

        scene.overlay().showText(100).text("For a valid setup, all paths have to converge into one exit at any side")
            .pointAt(util.vector().blockSurface(util.grid().at(1, 1, 2), class_2350.field_11039).method_1031(0, 0, -.5f)).colored(PonderPalette.GREEN)
            .attachKeyFrame().placeNearTarget();
        scene.idle(60);

        Collection<Couple<class_2338>> couples = ImmutableList.of(
            Couple.create(util.grid().at(3, 3, 2), util.grid().at(3, 2, 2)),
            Couple.create(util.grid().at(3, 2, 2), util.grid().at(3, 1, 2)),
            Couple.create(util.grid().at(2, 3, 2), util.grid().at(1, 3, 2)),
            Couple.create(util.grid().at(3, 1, 2), util.grid().at(2, 1, 2)),
            Couple.create(util.grid().at(1, 3, 2), util.grid().at(1, 2, 2)),
            Couple.create(util.grid().at(2, 2, 2), util.grid().at(2, 1, 2)),
            Couple.create(util.grid().at(1, 2, 2), util.grid().at(1, 1, 2)),
            Couple.create(util.grid().at(2, 1, 2), util.grid().at(1, 1, 2)),
            Couple.create(util.grid().at(1, 1, 2), util.grid().at(0, 1, 2))
        );

        for (Couple<class_2338> c : couples) {
            scene.idle(5);
            class_243 p1 = util.vector().blockSurface(c.getFirst(), class_2350.field_11043).method_1031(0, 0, -0.125);
            class_243 p2 = util.vector().blockSurface(c.getSecond(), class_2350.field_11043).method_1031(0, 0, -0.125);
            class_238 point = new class_238(p1, p1);
            class_238 line = new class_238(p1, p2);
            scene.overlay().chaseBoundingBoxOutline(PonderPalette.GREEN, p1, point, 2);
            scene.idle(1);
            scene.overlay().chaseBoundingBoxOutline(PonderPalette.GREEN, p1, line, 30);
        }

        scene.world().showSection(util.select().position(depotPos), class_2350.field_11034);
        scene.idle(20);
        scene.overlay().showText(60).text("The outputs will be placed into the inventory at the exit")
            .pointAt(util.vector().blockSurface(util.grid().at(0, 1, 2), class_2350.field_11043)).placeNearTarget();
        scene.idle(70);

        scene.rotateCameraY(60);
        scene.idle(20);
        scene.world().showSection(kinetics, class_2350.field_11043);
        scene.overlay().showText(60).text("Mechanical Crafters require Rotational Force to operate")
            .pointAt(util.vector().blockSurface(util.grid().at(4, 1, 2), class_2350.field_11043)).attachKeyFrame().placeNearTarget();
        scene.idle(8);
        scene.world().setKineticSpeed(crafters, -48);
        scene.world()
            .multiplyKineticSpeed(
                util.select().position(3, 2, 2).add(util.select().position(2, 3, 2)).add(util.select().position(1, 2, 2))
                    .add(util.select().position(2, 1, 2)), -1
            );
        scene.idle(55);
        scene.rotateCameraY(-60);

        scene.idle(40);
        class_1799 planks = new class_1799(class_1802.field_8118);
        scene.overlay().showControls(util.vector().blockSurface(util.grid().at(1, 3, 2), class_2350.field_11043), Pointing.RIGHT, 40).rightClick()
            .withItem(planks);
        scene.idle(7);
        Class<MechanicalCrafterBlockEntity> type = MechanicalCrafterBlockEntity.class;
        scene.world().modifyBlockEntity(util.grid().at(1, 3, 2), type, mct -> mct.getInventory().insert(planks.method_7972()));

        scene.idle(10);
        scene.overlay().showText(50).text("Right-Click the front to insert Items manually")
            .pointAt(util.vector().blockSurface(util.grid().at(1, 3, 2), class_2350.field_11043)).attachKeyFrame().placeNearTarget();
        scene.idle(60);

        class_1799 redstoneDust = new class_1799(class_1802.field_8725);
        class_1799 iron = new class_1799(class_1802.field_8620);
        class_1799 cobble = new class_1799(class_1802.field_20412);

        scene.world().setCraftingResult(util.grid().at(1, 1, 2), new class_1799(class_1802.field_8249));

        scene.world().modifyBlockEntity(util.grid().at(2, 3, 2), type, mct -> mct.getInventory().insert(planks.method_7972()));
        scene.idle(5);
        scene.world().modifyBlockEntity(util.grid().at(3, 3, 2), type, mct -> mct.getInventory().insert(planks.method_7972()));
        scene.idle(5);
        scene.world().modifyBlockEntity(util.grid().at(3, 2, 2), type, mct -> mct.getInventory().insert(cobble.method_7972()));
        scene.idle(5);
        scene.world().modifyBlockEntity(util.grid().at(2, 2, 2), type, mct -> mct.getInventory().insert(iron.method_7972()));
        scene.idle(5);
        scene.world().modifyBlockEntity(util.grid().at(1, 2, 2), type, mct -> mct.getInventory().insert(cobble.method_7972()));
        scene.idle(5);
        scene.world().modifyBlockEntity(util.grid().at(1, 1, 2), type, mct -> mct.getInventory().insert(cobble.method_7972()));
        scene.idle(5);
        scene.world().modifyBlockEntity(util.grid().at(2, 1, 2), type, mct -> mct.getInventory().insert(redstoneDust.method_7972()));
        scene.idle(5);
        scene.world().modifyBlockEntity(util.grid().at(3, 1, 2), type, mct -> mct.getInventory().insert(cobble.method_7972()));

        scene.overlay().showText(80).attachKeyFrame().text("Once every slot of a path contains an Item, the crafting process will begin")
            .pointAt(util.vector().blockSurface(util.grid().at(1, 3, 2), class_2350.field_11039)).placeNearTarget();
        scene.idle(180);

        scene.world().removeItemsFromBelt(depotPos);

        class_1799 stick = new class_1799(class_1802.field_8600);

        scene.world().setCraftingResult(util.grid().at(1, 1, 2), new class_1799(class_1802.field_8403));

        scene.world().modifyBlockEntity(util.grid().at(1, 3, 2), type, mct -> mct.getInventory().insert(iron.method_7972()));
        scene.idle(2);
        scene.world().modifyBlockEntity(util.grid().at(2, 3, 2), type, mct -> mct.getInventory().insert(iron.method_7972()));
        scene.idle(2);
        scene.world().modifyBlockEntity(util.grid().at(3, 3, 2), type, mct -> mct.getInventory().insert(iron.method_7972()));
        scene.idle(2);
        scene.world().modifyBlockEntity(util.grid().at(2, 2, 2), type, mct -> mct.getInventory().insert(stick.method_7972()));
        scene.idle(2);
        scene.world().modifyBlockEntity(util.grid().at(2, 1, 2), type, mct -> mct.getInventory().insert(stick.method_7972()));
        scene.world().showSection(redstone, class_2350.field_11035);
        scene.idle(10);

        scene.overlay().showText(90).attachKeyFrame().colored(PonderPalette.RED)
            .text("For recipes not fully occupying the crafter setup, the start can be forced using a Redstone Pulse")
            .pointAt(util.vector().blockSurface(util.grid().at(1, 2, 2), class_2350.field_11043)).placeNearTarget();
        scene.idle(100);
        scene.effects().indicateRedstone(util.grid().at(3, 1, 0));
        scene.world().toggleRedstonePower(redstone);
        scene.idle(20);
        scene.world().toggleRedstonePower(redstone);
    }

    public static void connect(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("mechanical_crafter_connect", "Connecting Inventories of Crafters");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);

        for (int y = 0; y < 3; y++) {
            for (int x = 0; x < 2; x++) {
                scene.world().showSection(util.select().position(y == 1 ? x + 1 : 2 - x, y + 1, 2), class_2350.field_11033);
                scene.idle(2);
            }
        }

        Class<MechanicalCrafterBlockEntity> type = MechanicalCrafterBlockEntity.class;
        class_2338 depotPos = util.grid().at(0, 1, 2);
        Selection funnel = util.select().fromTo(4, 1, 5, 4, 1, 2).add(util.select().fromTo(3, 2, 2, 3, 1, 2));
        Selection kinetics = util.select().position(3, 3, 2).add(util.select().fromTo(3, 3, 3, 3, 1, 3));
        scene.idle(5);

        scene.world().showSection(kinetics, class_2350.field_11043);
        scene.idle(5);
        scene.world().showSection(util.select().position(depotPos), class_2350.field_11034);
        scene.idle(10);
        scene.world().showSection(funnel, class_2350.field_11039);
        scene.rotateCameraY(60);
        class_1799 planks = new class_1799(class_1802.field_8118);
        scene.world().createItemOnBelt(util.grid().at(4, 1, 2), class_2350.field_11034, planks.method_7972());
        scene.idle(22);

        scene.world().modifyBlockEntity(util.grid().at(2, 2, 2), type, mct -> mct.getInventory().insert(planks.method_7972()));
        scene.world().removeItemsFromBelt(util.grid().at(3, 1, 2));
        scene.world().flapFunnel(util.grid().at(3, 2, 2), false);

        scene.overlay().showOutlineWithText(util.select().position(2, 2, 2), 70).attachKeyFrame().placeNearTarget()
            .pointAt(util.vector().blockSurface(util.grid().at(2, 2, 2), class_2350.field_11043)).text("Items can be inserted to Crafters automatically");
        scene.idle(80);

        scene.rotateCameraY(-60 - 90 - 30);
        scene.idle(40);

        class_243 v = util.vector().blockSurface(util.grid().at(2, 2, 2), class_2350.field_11039);
        class_238 bb = new class_238(v, v).method_1009(.125f, .5, .5);
        v = v.method_1031(0, 0, .5);

        scene.overlay().chaseBoundingBoxOutline(PonderPalette.WHITE, new Object(), bb, 45);
        scene.overlay().showControls(v, Pointing.LEFT, 40).rightClick().withItem(AllItems.WRENCH.method_7854());
        scene.idle(7);
        scene.world().connectCrafterInvs(util.grid().at(2, 2, 2), util.grid().at(1, 2, 2));
        scene.idle(40);
        scene.overlay().showOutlineWithText(util.select().fromTo(2, 2, 2, 1, 2, 2), 70).attachKeyFrame().placeNearTarget().pointAt(v)
            .text("Using the Wrench at their backs, Mechanical Crafter inputs can be combined");
        scene.idle(80);
        scene.overlay().showControls(v.method_1031(0, 1, 0), Pointing.LEFT, 20).rightClick().withItem(AllItems.WRENCH.method_7854());
        scene.idle(7);
        scene.world().connectCrafterInvs(util.grid().at(2, 3, 2), util.grid().at(1, 3, 2));
        scene.idle(20);
        scene.overlay().showControls(v.method_1031(0, -1, 0), Pointing.LEFT, 20).rightClick().withItem(AllItems.WRENCH.method_7854());
        scene.idle(7);
        scene.world().connectCrafterInvs(util.grid().at(2, 1, 2), util.grid().at(1, 1, 2));
        scene.idle(20);
        scene.overlay().showControls(v.method_1031(.5, -.5, 0), Pointing.LEFT, 20).rightClick().withItem(AllItems.WRENCH.method_7854());
        scene.idle(7);
        scene.world().connectCrafterInvs(util.grid().at(2, 1, 2), util.grid().at(2, 2, 2));
        scene.idle(10);
        scene.overlay().showControls(v.method_1031(.5, .5, 0), Pointing.LEFT, 20).rightClick().withItem(AllItems.WRENCH.method_7854());
        scene.idle(7);
        scene.world().connectCrafterInvs(util.grid().at(2, 2, 2), util.grid().at(2, 3, 2));
        scene.idle(20);

        scene.rotateCameraY(90 + 30);
        scene.idle(40);
        scene.overlay().showOutlineWithText(util.select().fromTo(1, 1, 2, 2, 3, 2), 70).attachKeyFrame().placeNearTarget()
            .text("All connected Crafters can now be accessed by the same input location");
        scene.idle(60);
        scene.overlay().showControls(util.vector().centerOf(util.grid().at(4, 2, 2)), Pointing.DOWN, 40).withItem(planks);
        scene.idle(7);
        scene.world().createItemOnBelt(util.grid().at(4, 1, 2), class_2350.field_11034, planks.method_46651(16));
        scene.idle(22);

        scene.world().removeItemsFromBelt(util.grid().at(3, 1, 2));
        class_2338[] positions = new class_2338[]{util.grid().at(2, 3, 2), util.grid().at(1, 3, 2), util.grid().at(1, 2, 2), util.grid().at(
            2,
            1,
            2
        ), util.grid().at(1, 1, 2)};

        scene.world().setCraftingResult(util.grid().at(1, 1, 2), new class_1799(class_1802.field_8691, 3));
        for (class_2338 pos : positions) {
            scene.world().modifyBlockEntity(pos, type, mct -> mct.getInventory().insert(planks.method_7972()));
            scene.idle(1);
        }

    }

    public static void covers(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("mechanical_crafter_covers", "Covering slots of Mechanical Crafters");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);

        scene.world().setBlock(util.grid().at(2, 2, 2), class_2246.field_10124.method_9564(), false);

        Selection kinetics = util.select().fromTo(3, 1, 2, 3, 1, 5);
        scene.world().setKineticSpeed(util.select().fromTo(1, 2, 2, 3, 1, 2), 0);

        scene.world().showSection(util.select().position(3, 2, 2), class_2350.field_11034);
        scene.idle(5);
        scene.world().showSection(util.select().position(2, 1, 2), class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(util.select().position(1, 2, 2), class_2350.field_11039);
        scene.idle(5);

        class_1799 iron = new class_1799(class_1802.field_8620);

        Class<MechanicalCrafterBlockEntity> type = MechanicalCrafterBlockEntity.class;
        scene.world().modifyBlockEntity(util.grid().at(3, 2, 2), type, mct -> mct.getInventory().insert(iron.method_7972()));
        scene.idle(5);
        scene.world().modifyBlockEntity(util.grid().at(2, 1, 2), type, mct -> mct.getInventory().insert(iron.method_7972()));
        scene.idle(5);
        scene.world().modifyBlockEntity(util.grid().at(1, 2, 2), type, mct -> mct.getInventory().insert(iron.method_7972()));
        scene.idle(5);

        Selection emptyCrafter = util.select().position(2, 2, 2);
        scene.overlay().showOutlineWithText(emptyCrafter, 90).attachKeyFrame().colored(PonderPalette.RED)
            .text("Some recipes will require additional Crafters to bridge gaps in the path").placeNearTarget();
        scene.idle(70);
        scene.world().restoreBlocks(emptyCrafter);
        scene.world().setCraftingResult(util.grid().at(2, 2, 2), new class_1799(class_1802.field_8550));
        scene.world().showSection(emptyCrafter, class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(util.select().position(2, 3, 2), class_2350.field_11033);
        scene.world().showSection(kinetics, class_2350.field_11043);
        scene.idle(5);
        scene.world().setKineticSpeed(util.select().fromTo(3, 1, 2, 1, 2, 2), -32);
        scene.world().setKineticSpeed(util.select().position(3, 1, 2).add(emptyCrafter), 32);

        scene.idle(20);

        scene.overlay().showText(90).attachKeyFrame().colored(PonderPalette.GREEN)
            .pointAt(util.vector().blockSurface(util.grid().at(2, 2, 2), class_2350.field_11043))
            .text("Using Slot Covers, Crafters can be set to act as an Empty Slot in the arrangement").placeNearTarget();
        scene.idle(100);
        scene.overlay().showControls(util.vector().blockSurface(util.grid().at(2, 2, 2), class_2350.field_11043).method_1031(0.5, 0, 0), Pointing.RIGHT, 50)
            .withItem(AllItems.CRAFTER_SLOT_COVER.method_7854()).rightClick();
        scene.idle(7);
        scene.world().modifyBlockEntityNBT(emptyCrafter, type, compound -> compound.method_10556("Cover", true));
        scene.idle(130);

        scene.overlay().showControls(util.vector().blockSurface(util.grid().at(2, 3, 2), class_2350.field_11039), Pointing.LEFT, 40)
            .withItem(new class_1799(class_1802.field_8550));
        scene.idle(50);
        scene.world().showSection(util.select().position(4, 2, 2), class_2350.field_11033);

        scene.world().connectCrafterInvs(util.grid().at(3, 2, 2), util.grid().at(2, 2, 2));
        scene.idle(5);
        scene.world().connectCrafterInvs(util.grid().at(2, 1, 2), util.grid().at(2, 2, 2));
        scene.idle(5);
        scene.world().connectCrafterInvs(util.grid().at(1, 2, 2), util.grid().at(2, 2, 2));
        scene.idle(10);

        scene.overlay().showOutlineWithText(util.select().fromTo(3, 2, 2, 1, 2, 2).add(util.select().position(2, 1, 2)), 80).attachKeyFrame()
            .pointAt(util.vector().blockSurface(util.grid().at(2, 2, 2), class_2350.field_11043))
            .text("Shared Inputs created with the Wrench at the back can also reach across covered Crafters").placeNearTarget();
        scene.idle(60);

        ElementLink<EntityElement> ingot = scene.world().createItemEntity(util.vector().centerOf(4, 4, 2), util.vector().of(0, 0.2, 0), iron);
        scene.idle(17);
        scene.world().modifyEntity(ingot, class_1297::method_31472);
        scene.world().modifyBlockEntity(util.grid().at(3, 2, 2), type, mct -> mct.getInventory().insert(iron.method_7972()));
        ingot = scene.world().createItemEntity(util.vector().centerOf(4, 4, 2), util.vector().of(0, 0.2, 0), iron);
        scene.idle(17);
        scene.world().modifyEntity(ingot, class_1297::method_31472);
        scene.world().modifyBlockEntity(util.grid().at(2, 1, 2), type, mct -> mct.getInventory().insert(iron.method_7972()));
        ingot = scene.world().createItemEntity(util.vector().centerOf(4, 4, 2), util.vector().of(0, 0.2, 0), iron);
        scene.idle(17);
        scene.world().modifyEntity(ingot, class_1297::method_31472);
        scene.world().modifyBlockEntity(util.grid().at(1, 2, 2), type, mct -> mct.getInventory().insert(iron.method_7972()));

    }

}