package com.zurrtum.create.client.mixin;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.impl.FlwImplXplat;
import com.zurrtum.create.client.flywheel.impl.event.RenderContextImpl;
import com.zurrtum.create.client.flywheel.lib.visualization.VisualizationHelper;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import net.minecraft.class_1297;
import net.minecraft.class_3191;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4599;
import net.minecraft.class_638;
import net.minecraft.class_761;
import net.minecraft.class_9779;
import net.minecraft.class_9922;
import net.minecraft.client.render.*;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.SortedSet;

@Mixin(value = class_761.class, priority = 1001) // Higher priority to go after Sodium
public class FlywheelWorldRendererMixin {
    @Shadow
    @Nullable
    private class_638 world;

    @Shadow
    @Final
    public class_4599 bufferBuilders;

    @Shadow
    @Final
    private Long2ObjectMap<SortedSet<class_3191>> blockBreakingProgressions;

    @Unique
    @Nullable
    private RenderContextImpl flywheel$renderContext;

    @Inject(method = "render", at = @At(value = "INVOKE_ASSIGN", target = "Lnet/minecraft/world/chunk/light/LightingProvider;doLightUpdates()I"))
    private void flywheel$beginRender(
        class_9922 allocator,
        class_9779 tickCounter,
        boolean renderBlockOutline,
        class_4184 camera,
        Matrix4f positionMatrix,
        Matrix4f projectionMatrix,
        GpuBufferSlice fog,
        Vector4f fogColor,
        boolean shouldRenderSky,
        CallbackInfo ci
    ) {
        flywheel$renderContext = RenderContextImpl.create(
            (class_761) (Object) this,
            world,
            bufferBuilders,
            positionMatrix,
            projectionMatrix,
            camera,
            tickCounter.method_60637(false)
        );

        VisualizationManager manager = VisualizationManager.get(world);
        if (manager != null) {
            manager.renderDispatcher().onStartLevelRender(flywheel$renderContext);
        }
    }

    @Inject(method = "render", at = @At("RETURN"))
    private void flywheel$endRender(CallbackInfo ci) {
        flywheel$renderContext = null;
    }

    @Inject(method = "reload()V", at = @At("RETURN"))
    private void flywheel$reload(CallbackInfo ci) {
        if (world != null) {
            FlwImplXplat.INSTANCE.dispatchReloadLevelRendererEvent(world);
        }
    }

    @Inject(method = "renderBlockEntities", at = @At(value = "HEAD"))
    private void flywheel$beforeBlockEntities(CallbackInfo ci) {
        if (flywheel$renderContext != null) {
            VisualizationManager manager = VisualizationManager.get(world);
            if (manager != null) {
                manager.renderDispatcher().afterEntities(flywheel$renderContext);
            }
        }
    }

    @Inject(method = "renderBlockDamage", at = @At(value = "HEAD"))
    private void flywheel$beforeRenderCrumbling(CallbackInfo ci) {
        if (flywheel$renderContext != null) {
            VisualizationManager manager = VisualizationManager.get(world);
            if (manager != null) {
                manager.renderDispatcher().beforeCrumbling(flywheel$renderContext, blockBreakingProgressions);
            }
        }
    }

    @Inject(method = "renderEntity", at = @At("HEAD"), cancellable = true)
    private void flywheel$decideNotToRenderEntity(
        class_1297 entity,
        double cameraX,
        double cameraY,
        double cameraZ,
        float tickProgress,
        class_4587 matrices,
        class_4597 vertexConsumers,
        CallbackInfo ci
    ) {
        if (VisualizationManager.supportsVisualization(entity.method_37908()) && VisualizationHelper.skipVanillaRender(entity)) {
            ci.cancel();
        }
    }
}
