package com.zurrtum.create.client.ponder.foundation;

import com.google.common.base.Strings;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.registry.RegisteredObjectsHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.gui.NavigatableSimiScreen;
import com.zurrtum.create.client.catnip.gui.ScreenOpener;
import com.zurrtum.create.client.ponder.Ponder;
import com.zurrtum.create.client.ponder.enums.PonderKeybinds;
import com.zurrtum.create.client.ponder.foundation.registration.PonderLocalization;
import com.zurrtum.create.client.ponder.foundation.ui.PonderUI;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class PonderTooltipHandler {

    private static final Color borderA = new Color(0x5000ff, false).setImmutable();
    private static final Color borderB = new Color(0x5555ff, false).setImmutable();
    private static final Color borderC = new Color(0xffffff, false).setImmutable();

    public static boolean enable = true;

    static LerpedFloat holdKeyProgress = LerpedFloat.linear().startWithValue(0);
    static class_1799 hoveredStack = class_1799.field_8037;
    static class_1799 trackingStack = class_1799.field_8037;
    static boolean subject = false;
    static boolean deferTick = false;

    public static final String HOLD_TO_PONDER = PonderLocalization.UI_PREFIX + "hold_to_ponder";
    public static final String SUBJECT = PonderLocalization.UI_PREFIX + "subject";

    public static void tick() {
        deferTick = true;
    }

    public static void deferredTick() {
        deferTick = false;
        class_310 instance = class_310.method_1551();
        class_437 currentScreen = instance.field_1755;

        if (hoveredStack.method_7960() || trackingStack.method_7960()) {
            trackingStack = class_1799.field_8037;
            holdKeyProgress.startWithValue(0);
            return;
        }

        float value = holdKeyProgress.getValue();

        if (!subject && class_3675.method_15987(instance.method_22683().method_4490(), ponderKeybind().field_1655.method_1444()) && currentScreen != null) {
            if (value >= 1) {
                if (currentScreen instanceof NavigatableSimiScreen)
                    ((NavigatableSimiScreen) currentScreen).centerScalingOnMouse();
                ScreenOpener.transitionTo(PonderUI.of(trackingStack));
                holdKeyProgress.startWithValue(0);
                return;
            }
            holdKeyProgress.setValue(Math.min(1, value + Math.max(.25f, value) * .25f));
        } else
            holdKeyProgress.setValue(Math.max(0, value - .05f));

        hoveredStack = class_1799.field_8037;
    }

    public static void addToTooltip(List<class_2561> toolTip, class_1799 stack) {
        if (!enable)
            return;

        if (NavigatableSimiScreen.isCurrentlyRenderingPreviousScreen())
            return;

        class_310 mc = class_310.method_1551();
        updateHovered(mc, stack);

        if (deferTick)
            deferredTick();

        if (trackingStack != stack)
            return;

        // TODO - Checkover
        float renderPartialTicks = AnimationTickHolder.getPartialTicksUI(mc.method_61966());
        class_2561 component = subject ? Ponder.lang().translate(SUBJECT).component().method_27692(class_124.field_1060) : makeProgressBar(Math.min(
            1,
            holdKeyProgress.getValue(renderPartialTicks) * 8 / 7f
        ));
        if (toolTip.size() < 2)
            toolTip.add(component);
        else
            toolTip.add(1, component);
    }

    protected static void updateHovered(class_310 instance, class_1799 stack) {
        class_437 currentScreen = instance.field_1755;
        boolean inPonderUI = currentScreen instanceof PonderUI;

        class_1799 prevStack = trackingStack;
        hoveredStack = class_1799.field_8037;
        subject = false;

        if (inPonderUI) {
            PonderUI ponderUI = (PonderUI) currentScreen;
            class_1799 uiSubject = ponderUI.getSubject();
            if (!uiSubject.method_7960() && stack.method_31574(uiSubject.method_7909()))
                subject = true;
        }

        if (stack.method_7960())
            return;
        if (!PonderIndex.getSceneAccess().doScenesExistForId(RegisteredObjectsHelper.getKeyOrThrow(stack.method_7909())))
            return;

        if (prevStack.method_7960() || !prevStack.method_31574(stack.method_7909()))
            holdKeyProgress.startWithValue(0);

        hoveredStack = stack;
        trackingStack = stack;
    }

    public static Optional<Couple<Color>> handleTooltipColor(class_1799 stack) {
        if (trackingStack != stack)
            return Optional.empty();

        if (holdKeyProgress.getValue() == 0)
            return Optional.empty();

        // TODO - Checkover
        float renderPartialTicks = AnimationTickHolder.getPartialTicksUI(class_310.method_1551().method_61966());

        Color startC;
        Color endC;
        float progress = Math.min(1, holdKeyProgress.getValue(renderPartialTicks) * 8 / 7f);

        startC = getSmoothColorForProgress(progress);
        endC = getSmoothColorForProgress(progress);

        return Optional.of(Couple.create(startC, endC));

    }

    private static Color getSmoothColorForProgress(float progress) {
        if (progress < 0.5)
            return borderA.mixWith(borderB, progress * 2);
        return borderB.mixWith(borderC, (progress - .5f) * 2);
    }

    private static class_2561 makeProgressBar(float progress) {
        class_5250 holdW = Ponder.lang()
            .translate(HOLD_TO_PONDER, ((class_5250) ponderKeybind().method_16007()).method_27692(class_124.field_1080))
            .style(class_124.field_1063).component();

        class_327 fontRenderer = class_310.method_1551().field_1772;
        float charWidth = fontRenderer.method_1727("|");
        float tipWidth = fontRenderer.method_27525(holdW);

        int total = (int) (tipWidth / charWidth);
        int current = (int) (progress * total);

        if (progress > 0) {
            String bars = "";
            bars += class_124.field_1080 + Strings.repeat("|", current);
            if (progress < 1)
                bars += class_124.field_1063 + Strings.repeat("|", total - current);
            return class_2561.method_43470(bars);
        }

        return holdW;
    }

    protected static class_304 ponderKeybind() {
        return PonderKeybinds.PONDER;
    }

}