package com.zurrtum.create.client.ponder.foundation.instruction;

import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.client.ponder.api.element.MinecartElement;
import com.zurrtum.create.client.ponder.api.level.PonderLevel;
import com.zurrtum.create.client.ponder.foundation.PonderScene;
import com.zurrtum.create.client.ponder.foundation.element.AnimatedSceneElementBase;
import net.minecraft.class_1688;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import net.minecraft.class_898;
import org.jetbrains.annotations.Nullable;

public class MinecartElementImpl extends AnimatedSceneElementBase implements MinecartElement {

    private final class_243 location;
    private final LerpedFloat rotation;
    @Nullable
    private class_1688 entity;
    private final MinecartConstructor constructor;
    private final float initialRotation;

    public MinecartElementImpl(class_243 location, float rotation, MinecartConstructor constructor) {
        initialRotation = rotation;
        this.location = location.method_1031(0, 1 / 16f, 0);
        this.constructor = constructor;
        this.rotation = LerpedFloat.angular().startWithValue(rotation);
    }

    @Override
    public void reset(PonderScene scene) {
        super.reset(scene);
        entity.method_23327(0, 0, 0);
        entity.field_6014 = 0;
        entity.field_6036 = 0;
        entity.field_5969 = 0;
        entity.field_6038 = 0;
        entity.field_5971 = 0;
        entity.field_5989 = 0;
        rotation.startWithValue(initialRotation);
    }

    @Override
    public void tick(PonderScene scene) {
        super.tick(scene);
        if (entity == null)
            entity = constructor.create(scene.getWorld(), 0, 0, 0);

        entity.field_6012++;
        entity.method_24830(true);
        entity.field_6014 = entity.method_23317();
        entity.field_6036 = entity.method_23318();
        entity.field_5969 = entity.method_23321();
        entity.field_6038 = entity.method_23317();
        entity.field_5971 = entity.method_23318();
        entity.field_5989 = entity.method_23321();
    }

    @Override
    public void setPositionOffset(class_243 position, boolean immediate) {
        if (entity == null)
            return;
        entity.method_23327(position.field_1352, position.field_1351, position.field_1350);
        if (!immediate)
            return;
        entity.field_6014 = position.field_1352;
        entity.field_6036 = position.field_1351;
        entity.field_5969 = position.field_1350;
    }

    @Override
    public void setRotation(float angle, boolean immediate) {
        if (entity == null)
            return;
        rotation.setValue(angle);
        if (!immediate)
            return;
        rotation.startWithValue(angle);
    }

    @Override
    public class_243 getPositionOffset() {
        return entity != null ? entity.method_19538() : class_243.field_1353;
    }

    @Override
    public class_243 getRotation() {
        return new class_243(0, rotation.getValue(), 0);
    }

    @Override
    public void renderLast(PonderLevel world, class_4597 buffer, class_4587 poseStack, float fade, float pt) {
        class_898 entityrenderermanager = class_310.method_1551().method_1561();
        if (entity == null)
            entity = constructor.create(world, 0, 0, 0);

        poseStack.method_22903();
        poseStack.method_22904(location.field_1352, location.field_1351, location.field_1350);
        poseStack.method_22904(
            class_3532.method_16436(pt, entity.field_6014, entity.method_23317()),
            class_3532.method_16436(pt, entity.field_6036, entity.method_23318()),
            class_3532.method_16436(pt, entity.field_5969, entity.method_23321())
        );

        poseStack.method_22907(class_7833.field_40716.rotationDegrees(rotation.getValue(pt)));

        entityrenderermanager.method_62424(entity, 0, 0, 0, pt, poseStack, buffer, lightCoordsFromFade(fade));
        poseStack.method_22909();
    }

}