package com.zurrtum.create.client.ponder.foundation.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.catnip.gui.UIRenderHelper;
import com.zurrtum.create.client.catnip.gui.render.GpuTexture;
import com.zurrtum.create.client.catnip.render.DefaultSuperRenderTypeBuffer;
import com.zurrtum.create.client.catnip.render.PonderRenderTypes;
import com.zurrtum.create.client.catnip.render.SuperRenderTypeBuffer;
import com.zurrtum.create.client.ponder.foundation.PonderScene;
import com.zurrtum.create.client.ponder.foundation.PonderScene.SceneTransform;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.minecraft.class_10366;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11239;
import net.minecraft.class_11241;
import net.minecraft.class_11246;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class SceneRenderer extends class_11239<SceneRenderState> {
    private static final Vector3f DIFFUSE_LIGHT_0 = new Vector3f(0.4F, -1.0F, 0.7F).normalize();
    private static final Vector3f DIFFUSE_LIGHT_1 = new Vector3f(-0.4F, -0.5F, 0.7F).normalize();
    private static final Int2ObjectMap<GpuTexture> TEXTURES = new Int2ObjectArrayMap<>();
    private final class_4587 matrices = new class_4587();
    private int windowScaleFactor;

    public SceneRenderer(class_4597.class_4598 vertexConsumers) {
        super(vertexConsumers);
    }

    @Override
    public void render(SceneRenderState renderState, class_11246 state, int windowScaleFactor) {
        if (this.windowScaleFactor != windowScaleFactor) {
            this.windowScaleFactor = windowScaleFactor;
            TEXTURES.values().forEach(GpuTexture::close);
            TEXTURES.clear();
        }
        int width = renderState.width() * windowScaleFactor;
        int height = renderState.height() * windowScaleFactor;
        GpuTexture texture = TEXTURES.get(renderState.id());
        if (texture == null) {
            texture = GpuTexture.create(width, height);
            TEXTURES.put(renderState.id(), texture);
        }
        RenderSystem.setProjectionMatrix(field_60042.method_71092(width, height), class_10366.field_54954);
        texture.prepare();
        matrices.method_22903();
        matrices.method_22905(windowScaleFactor, windowScaleFactor, 1);

        class_310 mc = class_310.method_1551();
        class_308 lighting = mc.field_1773.method_71114();
        lighting.method_71035(class_308.class_11274.field_60025, DIFFUSE_LIGHT_0, DIFFUSE_LIGHT_1);
        lighting.method_71034(class_308.class_11274.field_60025);
        renderScene(renderState, matrices);
        lighting.method_71036(mc.field_1687.method_28103().method_29993());

        field_59933.method_22993();
        matrices.method_22909();
        texture.clear();
        state.method_71996(new class_11241(
            class_10799.field_59968,
            class_11231.method_70900(texture.textureView()),
            renderState.method_72127(),
            renderState.comp_4122(),
            renderState.comp_4123(),
            renderState.comp_4124(),
            renderState.comp_4125(),
            0.0F,
            1.0F,
            1.0F,
            0.0F,
            -1,
            null,
            null
        ));
    }

    private void renderScene(SceneRenderState state, class_4587 poseStack) {
        float partialTicks = state.partialTicks();
        SuperRenderTypeBuffer buffer = DefaultSuperRenderTypeBuffer.getInstance();
        PonderScene scene = state.scene();
        poseStack.method_46416(0, 0, -800);
        SceneTransform transform = scene.getTransform();
        transform.updateScreenParams(state.width(), state.height(), state.slide());
        transform.apply(poseStack, partialTicks);
        transform.updateSceneRVE(partialTicks);
        scene.renderScene(buffer, poseStack, partialTicks);
        buffer.draw();

        // kool shadow fx
        if (!scene.shouldHidePlatformShadow()) {
            poseStack.method_22903();
            poseStack.method_46416(scene.getBasePlateOffsetX(), 0, scene.getBasePlateOffsetZ());
            UIRenderHelper.flipForGuiRender(poseStack);

            float flash = state.finishingFlash().getValue(partialTicks) * .9f;
            float alpha = flash;
            flash *= flash;
            flash = ((flash * 2) - 1);
            flash *= flash;
            flash = 1 - flash;

            for (int f = 0; f < 4; f++) {
                poseStack.method_46416(scene.getBasePlateSize(), 0, 0);
                poseStack.method_22903();
                poseStack.method_46416(0, 0, -1 / 1024f);
                if (flash > 0) {
                    poseStack.method_22903();
                    poseStack.method_22905(1, .5f + flash * .75f, 1);
                    fillGradient(
                        field_59933,
                        matrices,
                        0,
                        -1,
                        -scene.getBasePlateSize(),
                        0,
                        0,
                        new Color(0x00_c6ffc9).getRGB(),
                        new Color(0xaa_c6ffc9).scaleAlpha(alpha).getRGB()
                    );
                    poseStack.method_22909();
                }
                poseStack.method_46416(0, 0, 2 / 1024f);
                fillGradient(
                    field_59933,
                    matrices,
                    0,
                    0,
                    -scene.getBasePlateSize(),
                    4,
                    0,
                    new Color(0x66_000000).getRGB(),
                    new Color(0x00_000000).getRGB()
                );
                poseStack.method_22909();
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(-90));
            }
            poseStack.method_22909();
        }

        //TODO
        // coords for debug
        //        if (PonderIndex.editingModeActive() && !state.userViewMode()) {
        //            BlockBox bounds = scene.getBounds();
        //
        //            poseStack.scale(-1, -1, 1);
        //            poseStack.scale(1 / 16f, 1 / 16f, 1 / 16f);
        //            poseStack.translate(1, -8, -1 / 64f);
        //
        //            // X AXIS
        //            poseStack.push();
        //            poseStack.translate(4, -3, 0);
        //            poseStack.translate(0, 0, -2 / 1024f);
        //            int blockCountX = bounds.getBlockCountX();
        //            for (int x = 0; x <= blockCountX; x++) {
        //                poseStack.translate(-16, 0, 0);
        //                graphics.drawString(font, x == blockCountX ? "x" : "" + x, 0, 0, 0xFFFFFFFF, false);
        //            }
        //            poseStack.pop();
        //
        //            // Z AXIS
        //            poseStack.push();
        //            poseStack.scale(-1, 1, 1);
        //            poseStack.translate(0, -3, -4);
        //            poseStack.multiply(RotationAxis.POSITIVE_Y.rotationDegrees(-90));
        //            poseStack.translate(-8, -2, 2 / 64f);
        //            int blockCountZ = bounds.getBlockCountZ();
        //            for (int z = 0; z <= blockCountZ; z++) {
        //                poseStack.translate(16, 0, 0);
        //                graphics.drawString(font, z == blockCountZ ? "z" : "" + z, 0, 0, 0xFFFFFFFF, false);
        //            }
        //            poseStack.pop();
        //
        //            // DIRECTIONS
        //            poseStack.push();
        //            poseStack.translate(blockCountX * -8, 0, blockCountZ * 8);
        //            poseStack.multiply(RotationAxis.POSITIVE_Y.rotationDegrees(-90));
        //            for (Direction d : Iterate.horizontalDirections) {
        //                poseStack.multiply(RotationAxis.POSITIVE_Y.rotationDegrees(90));
        //                poseStack.push();
        //                poseStack.translate(0, 0, blockCountZ * 16);
        //                poseStack.multiply(RotationAxis.POSITIVE_X.rotationDegrees(-90));
        //                graphics.drawString(font, d.name().substring(0, 1), 0, 0, 0x66FFFFFF, false);
        //                graphics.drawString(font, "|", 2, 10, 0x44FFFFFF, false);
        //                graphics.drawString(font, ".", 2, 14, 0x22FFFFFF, false);
        //                poseStack.pop();
        //            }
        //            poseStack.pop();
        //            buffer.draw();
        //        }
    }

    public static void fillGradient(
        class_4597 vertexConsumers,
        class_4587 matrices,
        int x1,
        int y1,
        int x2,
        int y2,
        int z,
        int colorFrom,
        int colorTo
    ) {
        class_4588 buffer = vertexConsumers.getBuffer(PonderRenderTypes.getGui());
        Matrix4f matrix4f = matrices.method_23760().method_23761();
        buffer.method_22918(matrix4f, (float) x1, (float) y1, (float) z).method_39415(colorFrom);
        buffer.method_22918(matrix4f, (float) x1, (float) y2, (float) z).method_39415(colorTo);
        buffer.method_22918(matrix4f, (float) x2, (float) y2, (float) z).method_39415(colorTo);
        buffer.method_22918(matrix4f, (float) x2, (float) y1, (float) z).method_39415(colorFrom);
    }

    @Override
    protected void render(SceneRenderState state, class_4587 matrices) {
    }

    @Override
    protected String method_70906() {
        return "Scene";
    }

    @Override
    public Class<SceneRenderState> method_70903() {
        return SceneRenderState.class;
    }
}
