package com.zurrtum.create.client.ponder.foundation.ui;

import com.zurrtum.create.catnip.registry.RegisteredObjectsHelper;
import com.zurrtum.create.client.catnip.gui.NavigatableSimiScreen;
import com.zurrtum.create.client.catnip.gui.ScreenOpener;
import com.zurrtum.create.client.catnip.gui.UIRenderHelper;
import com.zurrtum.create.client.catnip.gui.element.BoxElement;
import com.zurrtum.create.client.catnip.gui.widget.BoxWidget;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.catnip.lang.ClientFontHelper;
import com.zurrtum.create.client.catnip.layout.LayoutHelper;
import com.zurrtum.create.client.ponder.Ponder;
import com.zurrtum.create.client.ponder.foundation.PonderChapter;
import com.zurrtum.create.client.ponder.foundation.PonderIndex;
import com.zurrtum.create.client.ponder.foundation.PonderTag;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1041;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_768;

public class PonderTagScreen extends AbstractPonderScreen {

    private final PonderTag tag;
    protected final List<ItemEntry> items = new ArrayList<>();
    private final double itemXmult = 0.5;
    @Nullable
    protected class_768 itemArea;
    protected final List<PonderChapter> chapters = new ArrayList<>();
    private final double chapterXmult = 0.5;
    private final double chapterYmult = 0.75;
    @Nullable
    protected class_768 chapterArea;
    private final double mainYmult = 0.15;

    private class_1799 hoveredItem = class_1799.field_8037;

    public PonderTagScreen(class_2960 tag) {
        this.tag = PonderIndex.getTagAccess().getRegisteredTag(tag);
    }

    public PonderTagScreen(PonderTag tag) {
        this.tag = tag;
    }

    @Override
    protected void method_25426() {
        super.method_25426();

        // items
        items.clear();
        PonderIndex.getTagAccess().getItems(tag).stream().map(key -> new ItemEntry(RegisteredObjectsHelper.getItemOrBlock(key), key))
            .filter(entry -> entry.item != null).forEach(items::add);

        if (!tag.getMainItem().method_7960())
            items.removeIf(entry -> entry.item == tag.getMainItem().method_7909());

        int rowCount = class_3532.method_15340((int) Math.ceil(items.size() / 11d), 1, 3);
        LayoutHelper layout = LayoutHelper.centeredHorizontal(items.size(), rowCount, 28, 28, 8);
        itemArea = layout.getArea();
        int itemCenterX = (int) (field_22789 * itemXmult);
        int itemCenterY = getItemsY();

        for (ItemEntry entry : items) {
            PonderButton b = new PonderButton(itemCenterX + layout.getX() + 4, itemCenterY + layout.getY() + 4).showing(new class_1799(entry.item));

            if (PonderIndex.getSceneAccess().doScenesExistForId(entry.key)) {
                b.withCallback((mouseX, mouseY) -> {
                    centerScalingOn(mouseX, mouseY);
                    ScreenOpener.transitionTo(PonderUI.of(new class_1799(entry.item), tag));
                });
            } else {
                b.withBorderColors(entry.key.method_12836().equals("minecraft") ? PonderUI.MISSING_VANILLA_ENTRY : PonderUI.MISSING_MODDED_ENTRY)
                    .animateColors(false);
            }

            method_37063(b);
            layout.next();
        }

        if (!tag.getMainItem().method_7960()) {
            class_2960 registryName = RegisteredObjectsHelper.getKeyOrThrow(tag.getMainItem().method_7909());

            PonderButton b = new PonderButton(itemCenterX - layout.getTotalWidth() / 2 - 48, itemCenterY - 10).showing(tag.getMainItem());
            //b.withCustomBackground(PonderTheme.Key.PONDER_BACKGROUND_IMPORTANT.c());

            if (PonderIndex.getSceneAccess().doScenesExistForId(registryName)) {
                b.withCallback((mouseX, mouseY) -> {
                    centerScalingOn(mouseX, mouseY);
                    ScreenOpener.transitionTo(PonderUI.of(tag.getMainItem(), tag));
                });
            } else {
                b.withBorderColors(registryName.method_12836().equals("minecraft") ? PonderUI.MISSING_VANILLA_ENTRY : PonderUI.MISSING_MODDED_ENTRY)
                    .animateColors(false);
            }

            method_37063(b);
        }

    }

    @Override
    protected void initBackTrackIcon(BoxWidget backTrack) {
        backTrack.showing(tag);
    }

    @Override
    public void method_25393() {
        super.method_25393();
        PonderUI.ponderTicks++;

        hoveredItem = class_1799.field_8037;
        class_1041 w = field_22787.method_22683();
        int mX = (int) (field_22787.field_1729.method_1603() * (double) w.method_4486() / (double) w.method_4480());
        int mY = (int) (field_22787.field_1729.method_1604() * (double) w.method_4502() / (double) w.method_4507());
        for (class_364 child : method_25396()) {
            if (child == backTrack)
                continue;
            if (child instanceof PonderButton button)
                if (button.method_25405(mX, mY)) {
                    hoveredItem = button.getItem();
                }
        }
    }

    @Override
    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWindow(graphics, mouseX, mouseY, partialTicks);
        renderItems(graphics, mouseX, mouseY, partialTicks);

        renderChapters(graphics, mouseX, mouseY, partialTicks);

        Matrix3x2fStack poseStack = graphics.method_51448();
        poseStack.pushMatrix();
        poseStack.translate((float) (field_22789 / 2 - 120), (float) (field_22790 * mainYmult - 40));

        poseStack.pushMatrix();
        //poseStack.translate(0, 0, 800);
        int x = 31 + 20 + 8;
        int y = 31;

        String title = tag.getTitle();

        int streakHeight = 35;
        UIRenderHelper.streak(graphics, 0, x - 4, y - 12 + streakHeight / 2, streakHeight, 240);
        //PonderUI.renderBox(poseStack, 21, 21, 30, 30, false);
        new BoxElement().withBackground(PonderUI.BACKGROUND_FLAT).gradientBorder(PonderUI.COLOR_IDLE).at(21, 21, 100).withBounds(30, 30)
            .render(graphics);

        graphics.method_51439(
            field_22793,
            Ponder.lang().translate(AbstractPonderScreen.PONDERING).component(),
            x,
            y - 6,
            UIRenderHelper.COLOR_TEXT_DARKER.getFirst().getRGB(),
            false
        );
        y += 8;
        x += 0;
        poseStack.translate(x, y);
        graphics.method_51433(field_22793, title, 0, 0, UIRenderHelper.COLOR_TEXT.getFirst().getRGB(), false);
        poseStack.popMatrix();

        poseStack.pushMatrix();
        poseStack.translate(23, 23);
        poseStack.scale(1.66f, 1.66f);
        tag.render(graphics, 0, 0);
        poseStack.popMatrix();
        poseStack.popMatrix();

        poseStack.pushMatrix();
        int w = (int) (field_22789 * .45);
        x = (field_22789 - w) / 2;
        y = getItemsY() - 10 + Math.max(itemArea.method_3320(), 48);

        String desc = tag.getDescription();
        int h = field_22793.method_1713(desc, w);


        //PonderUI.renderBox(poseStack, x - 3, y - 3, w + 6, h + 6, false);
        new BoxElement().withBackground(PonderUI.BACKGROUND_FLAT).gradientBorder(PonderUI.COLOR_IDLE).at(x - 3, y - 3, 90).withBounds(w + 6, h + 6)
            .render(graphics);

        ClientFontHelper.drawSplitString(graphics, field_22793, desc, x, y, w, UIRenderHelper.COLOR_TEXT.getFirst().getRGB());
        poseStack.popMatrix();
    }

    protected void renderItems(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (items.isEmpty())
            return;

        int x = (int) (field_22789 * itemXmult);
        int y = getItemsY();

        String relatedTitle = Ponder.lang().translate(AbstractPonderScreen.ASSOCIATED).string();
        int stringWidth = field_22793.method_1727(relatedTitle);

        Matrix3x2fStack poseStack = graphics.method_51448();
        poseStack.pushMatrix();
        poseStack.translate(x, y);
        new BoxElement().withBackground(PonderUI.BACKGROUND_FLAT).gradientBorder(PonderUI.COLOR_IDLE)
            .at((windowWidth - stringWidth) / 2f - 5, itemArea.method_3322() - 21, 100).withBounds(stringWidth + 10, 10).render(graphics);

        //		UIRenderHelper.streak(0, itemArea.getX() - 10, itemArea.getY() - 20, 20, 180, 0x101010);
        graphics.method_25300(
            field_22793,
            relatedTitle,
            windowWidth / 2,
            itemArea.method_3322() - 20,
            UIRenderHelper.COLOR_TEXT.getFirst().getRGB()
        );

        UIRenderHelper.streak(graphics, 0, 0, 0, itemArea.method_3320() + 10, itemArea.method_3319() / 2 + 75);
        UIRenderHelper.streak(graphics, 180, 0, 0, itemArea.method_3320() + 10, itemArea.method_3319() / 2 + 75);

        poseStack.popMatrix();

    }

    public int getItemsY() {
        return (int) (mainYmult * field_22790 + 85);
    }

    protected void renderChapters(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (chapters.isEmpty())
            return;

        int chapterX = (int) (field_22789 * chapterXmult);
        int chapterY = (int) (field_22790 * chapterYmult);

        Matrix3x2fStack matrices = graphics.method_51448();
        matrices.pushMatrix();
        matrices.translate(chapterX, chapterY);

        UIRenderHelper.streak(graphics, 0, chapterArea.method_3321() - 10, chapterArea.method_3322() - 20, 20, 220);
        graphics.method_51433(
            field_22793,
            "More Topics to Ponder about",
            chapterArea.method_3321() - 5,
            chapterArea.method_3322() - 25,
            UIRenderHelper.COLOR_TEXT_ACCENT.getFirst().getRGB(),
            false
        );

        matrices.popMatrix();
    }

    @Override
    protected void renderWindowForeground(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (!hoveredItem.method_7960()) {
            graphics.method_51446(field_22793, hoveredItem, mouseX, mouseY);
        }
    }

    @Override
    protected String getBreadcrumbTitle() {
        return tag.getTitle();
    }

    public class_1799 getHoveredTooltipItem() {
        return hoveredItem;
    }

    @Override
    public boolean isEquivalentTo(NavigatableSimiScreen other) {
        if (other instanceof PonderTagScreen)
            return tag == ((PonderTagScreen) other).tag;
        return super.isEquivalentTo(other);
    }

    @Override
    public boolean method_25421() {
        return true;
    }

    public PonderTag getTag() {
        return tag;
    }

    @Override
    public void method_25432() {
        super.method_25432();
        hoveredItem = class_1799.field_8037;
        for (class_4068 drawable : field_33816) {
            if (drawable instanceof ElementWidget widget) {
                widget.getRenderElement().clear();
            }
        }
    }

    public record ItemEntry(@Nullable class_1935 item, class_2960 key) {
    }

}