package com.zurrtum.create.client.vanillin.elements;

import com.zurrtum.create.client.flywheel.api.model.Model;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visual.Visual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.LineModelBuilder;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.client.flywheel.lib.visual.util.SmartRecycler;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_765;
import org.joml.Quaternionf;

public final class HitboxElement implements Visual, SimpleDynamicVisual {
    //    010------110
    //    /|       /|
    //   / |      / |
    // 011------111 |
    //  |  |     |  |
    //  | 000----|-100
    //  | /      | /
    //  |/       |/
    // 001------101
    public static final Model BOX_MODEL = new LineModelBuilder(12)
        // Starting from 0, 0, 0
        .line(0, 0, 0, 0, 0, 1).line(0, 0, 0, 0, 1, 0).line(0, 0, 0, 1, 0, 0)
        // Starting from 0, 1, 1
        .line(0, 1, 1, 0, 1, 0).line(0, 1, 1, 0, 0, 1).line(0, 1, 1, 1, 1, 1)
        // Starting from 1, 0, 1
        .line(1, 0, 1, 1, 0, 0).line(1, 0, 1, 1, 1, 1).line(1, 0, 1, 0, 0, 1)
        // Starting from 1, 1, 0
        .line(1, 1, 0, 1, 1, 1).line(1, 1, 0, 1, 0, 0).line(1, 1, 0, 0, 1, 0).build();

    public static final Model LINE_MODEL = new LineModelBuilder(1).line(0, 0, 0, 0, 2, 0).build();

    private final VisualizationContext context;
    private final class_1297 entity;

    private final SmartRecycler<Model, TransformedInstance> recycler;

    private boolean showEyeBox;

    public HitboxElement(VisualizationContext context, class_1297 entity, float partialTick) {
        this.context = context;
        this.entity = entity;
        this.showEyeBox = entity instanceof class_1309;

        this.recycler = new SmartRecycler<>(this::createInstance);

        animate(partialTick);
    }

    public HitboxElement(VisualizationContext context, class_1297 entity, float partialTick, boolean showEyeBox) {
        this(context, entity, partialTick);
        this.showEyeBox = showEyeBox;
    }

    private TransformedInstance createInstance(Model model) {
        TransformedInstance instance = context.instancerProvider().instancer(InstanceTypes.TRANSFORMED, model).createInstance();
        instance.light(class_765.field_32769);
        instance.setChanged();
        return instance;
    }

    public boolean doesShowEyeBox() {
        return showEyeBox;
    }

    public HitboxElement showEyeBox(boolean showEyeBox) {
        this.showEyeBox = showEyeBox;
        return this;
    }

    @Override
    public void beginFrame(DynamicVisual.Context context) {
        animate(context.partialTick());
    }

    @Override
    public void update(float partialTick) {

    }

    @Override
    public void delete() {
        recycler.delete();
    }

    public void animate(float partialTick) {
        recycler.resetCount();

        var shouldRenderHitBoxes = class_310.method_1551().method_1561().method_3958();
        if (shouldRenderHitBoxes && !entity.method_5767() && !class_310.method_1551().method_1555()) {
            double entityX = class_3532.method_16436(partialTick, entity.field_6038, entity.method_23317());
            double entityY = class_3532.method_16436(partialTick, entity.field_5971, entity.method_23318());
            double entityZ = class_3532.method_16436(partialTick, entity.field_5989, entity.method_23321());

            var bb = entity.method_5829();

            var boxX = entityX + bb.field_1323 - entity.method_23317();
            var boxY = entityY + bb.field_1322 - entity.method_23318();
            var boxZ = entityZ + bb.field_1321 - entity.method_23321();

            var widthX = (float) (bb.field_1320 - bb.field_1323);
            var widthY = (float) (bb.field_1325 - bb.field_1322);
            var widthZ = (float) (bb.field_1324 - bb.field_1321);
            recycler.get(BOX_MODEL).setIdentityTransform().translate(boxX, boxY, boxZ).scale(widthX, widthY, widthZ).setChanged();

            // TODO: multipart entities, but forge seems to have an
            //  injection for them so we'll need platform specific code.

            if (showEyeBox) {
                recycler.get(BOX_MODEL).setIdentityTransform().translate(boxX, entityY + entity.method_5751() - 0.01, boxZ)
                    .scale(widthX, 0.02f, widthZ).color(255, 0, 0).setChanged();
            }

            var viewVector = entity.method_5828(partialTick);

            recycler.get(LINE_MODEL).setIdentityTransform().translate(entityX, entityY + entity.method_5751(), entityZ)
                .rotate(new Quaternionf().rotateTo(0, 1, 0, (float) viewVector.field_1352, (float) viewVector.field_1351, (float) viewVector.field_1350)).color(0, 0, 255)
                .setChanged();
        }

        recycler.discardExtra();
    }
}
