package com.zurrtum.create.compat.rei;

import com.zurrtum.create.AllFluids;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.Create;
import com.zurrtum.create.compat.rei.display.*;
import com.zurrtum.create.content.equipment.sandPaper.SandPaperPolishingRecipe;
import com.zurrtum.create.content.fluids.transfer.EmptyingRecipe;
import com.zurrtum.create.content.fluids.transfer.FillingRecipe;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCraftingRecipe;
import com.zurrtum.create.content.kinetics.crusher.CrushingRecipe;
import com.zurrtum.create.content.kinetics.deployer.ItemApplicationRecipe;
import com.zurrtum.create.content.kinetics.deployer.ManualApplicationRecipe;
import com.zurrtum.create.content.kinetics.fan.processing.HauntingRecipe;
import com.zurrtum.create.content.kinetics.fan.processing.SplashingRecipe;
import com.zurrtum.create.content.kinetics.millstone.MillingRecipe;
import com.zurrtum.create.content.kinetics.mixer.CompactingRecipe;
import com.zurrtum.create.content.kinetics.mixer.MixingRecipe;
import com.zurrtum.create.content.kinetics.mixer.PotionRecipe;
import com.zurrtum.create.content.kinetics.press.PressingRecipe;
import com.zurrtum.create.content.kinetics.saw.CuttingRecipe;
import com.zurrtum.create.content.processing.sequenced.SequencedAssemblyRecipe;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.DisplaySerializerRegistry;
import me.shedaniel.rei.api.common.entry.comparison.FluidComparatorRegistry;
import me.shedaniel.rei.api.common.plugins.REICommonPlugin;
import me.shedaniel.rei.api.common.registry.display.ServerDisplayRegistry;
import me.shedaniel.rei.plugin.common.displays.crafting.CraftingDisplay;
import net.minecraft.class_1867;
import net.minecraft.class_3859;
import net.minecraft.class_3861;
import net.minecraft.class_3862;
import net.minecraft.class_3955;
import net.minecraft.recipe.*;

import java.util.Objects;

import static com.zurrtum.create.Create.MOD_ID;

public class ReiCommonPlugin implements REICommonPlugin {
    public static final CategoryIdentifier<CraftingDisplay> AUTOMATIC_PACKING = CategoryIdentifier.of(MOD_ID, "automatic_packing");
    public static final CategoryIdentifier<CompactingDisplay> PACKING = CategoryIdentifier.of(MOD_ID, "packing");
    public static final CategoryIdentifier<PressingDisplay> PRESSING = CategoryIdentifier.of(MOD_ID, "pressing");
    public static final CategoryIdentifier<CraftingDisplay> AUTOMATIC_SHAPELESS = CategoryIdentifier.of(MOD_ID, "automatic_shapeless");
    public static final CategoryIdentifier<MixingDisplay> MIXING = CategoryIdentifier.of(MOD_ID, "mixing");
    public static final CategoryIdentifier<MillingDisplay> MILLING = CategoryIdentifier.of(MOD_ID, "milling");
    public static final CategoryIdentifier<SawingDisplay> SAWING = CategoryIdentifier.of(MOD_ID, "sawing");
    public static final CategoryIdentifier<CrushingDisplay> CRUSHING = CategoryIdentifier.of(MOD_ID, "crushing");
    public static final CategoryIdentifier<ManualApplicationDisplay> ITEM_APPLICATION = CategoryIdentifier.of(MOD_ID, "item_application");
    public static final CategoryIdentifier<DeployingDisplay> DEPLOYING = CategoryIdentifier.of(MOD_ID, "deploying");
    public static final CategoryIdentifier<DrainingDisplay> DRAINING = CategoryIdentifier.of(MOD_ID, "draining");
    public static final CategoryIdentifier<MechanicalCraftingDisplay> MECHANICAL_CRAFTING = CategoryIdentifier.of(MOD_ID, "mechanical_crafting");
    public static final CategoryIdentifier<SpoutFillingDisplay> SPOUT_FILLING = CategoryIdentifier.of(MOD_ID, "spout_filling");
    public static final CategoryIdentifier<SandpaperPolishingDisplay> SANDPAPER_POLISHING = CategoryIdentifier.of(MOD_ID, "sandpaper_polishing");
    public static final CategoryIdentifier<SequencedAssemblyDisplay> SEQUENCED_ASSEMBLY = CategoryIdentifier.of(MOD_ID, "sequenced_assembly");
    public static final CategoryIdentifier<BlockCuttingDisplay> BLOCK_CUTTING = CategoryIdentifier.of(MOD_ID, "block_cutting");
    public static final CategoryIdentifier<FanBlastingDisplay> FAN_BLASTING = CategoryIdentifier.of(MOD_ID, "fan_blasting");
    public static final CategoryIdentifier<FanHauntingDisplay> FAN_HAUNTING = CategoryIdentifier.of(MOD_ID, "fan_haunting");
    public static final CategoryIdentifier<FanSmokingDisplay> FAN_SMOKING = CategoryIdentifier.of(MOD_ID, "fan_smoking");
    public static final CategoryIdentifier<FanWashingDisplay> FAN_WASHING = CategoryIdentifier.of(MOD_ID, "fan_washing");
    public static final CategoryIdentifier<PotionDisplay> AUTOMATIC_BREWING = CategoryIdentifier.of(MOD_ID, "automatic_brewing");

    @Override
    public void registerDisplays(ServerDisplayRegistry registry) {
        registry.beginRecipeFiller(class_3955.class).fill(AutoCompactingDisplay::of);
        registry.beginRecipeFiller(CompactingRecipe.class).filterType(AllRecipeTypes.COMPACTING).fill(CompactingDisplay::new);
        registry.beginRecipeFiller(PressingRecipe.class).filterType(AllRecipeTypes.PRESSING).fill(PressingDisplay::new);
        registry.beginRecipeFiller(class_1867.class).fill(AutoMixingDisplay::of);
        registry.beginRecipeFiller(MixingRecipe.class).fill(MixingDisplay::new);
        registry.beginRecipeFiller(MillingRecipe.class).fill(MillingDisplay::new);
        registry.beginRecipeFiller(CuttingRecipe.class).fill(SawingDisplay::new);
        registry.beginRecipeFiller(CrushingRecipe.class).fill(CrushingDisplay::of);
        registry.beginRecipeFiller(MillingRecipe.class).fill(CrushingDisplay::of);
        registry.beginRecipeFiller(ManualApplicationRecipe.class).fill(ManualApplicationDisplay::new);
        registry.beginRecipeFiller(ItemApplicationRecipe.class).fill(DeployingDisplay::of);
        registry.beginRecipeFiller(SandPaperPolishingRecipe.class).fill(DeployingDisplay::of);
        registry.beginRecipeFiller(EmptyingRecipe.class).fill(DrainingDisplay::new);
        registry.beginRecipeFiller(MechanicalCraftingRecipe.class).fill(MechanicalCraftingDisplay::new);
        registry.beginRecipeFiller(FillingRecipe.class).fill(SpoutFillingDisplay::new);
        registry.beginRecipeFiller(SandPaperPolishingRecipe.class).fill(SandpaperPolishingDisplay::new);
        registry.beginRecipeFiller(SequencedAssemblyRecipe.class).fill(SequencedAssemblyDisplay::new);
        registry.beginRecipeFiller(class_3859.class).fill(FanBlastingDisplay::of);
        registry.beginRecipeFiller(class_3861.class).fill(FanBlastingDisplay::of);
        registry.beginRecipeFiller(HauntingRecipe.class).fill(FanHauntingDisplay::new);
        registry.beginRecipeFiller(class_3862.class).fill(FanSmokingDisplay::of);
        registry.beginRecipeFiller(SplashingRecipe.class).fill(FanWashingDisplay::new);
        registry.beginRecipeFiller(PotionRecipe.class).fill(PotionDisplay::new);
        if (Create.SERVER != null) {
            BlockCuttingDisplay.register(registry);
        }
    }

    @Override
    public void registerDisplaySerializer(DisplaySerializerRegistry registry) {
        registry.register(
            AUTOMATIC_PACKING.getIdentifier().method_48331("/default/shapeless"),
            AutoCompactingDisplay.ShapelessDisplay.SERIALIZER
        );
        registry.register(AUTOMATIC_PACKING.getIdentifier().method_48331("/default/shaped"), AutoCompactingDisplay.ShapedDisplay.SERIALIZER);
        registry.register(
            AUTOMATIC_PACKING.getIdentifier().method_48331("/client/shaped"),
            AutoCompactingDisplay.CraftingDisplayShaped.SERIALIZER
        );
        registry.register(
            AUTOMATIC_PACKING.getIdentifier().method_48331("/client/shapeless"),
            AutoCompactingDisplay.CraftingDisplayShapeless.SERIALIZER
        );
        registry.register(PACKING.getIdentifier(), CompactingDisplay.SERIALIZER);
        registry.register(PRESSING.getIdentifier(), PressingDisplay.SERIALIZER);
        registry.register(AUTOMATIC_SHAPELESS.getIdentifier().method_48331("/default/shapeless"), AutoMixingDisplay.ShapelessDisplay.SERIALIZER);
        registry.register(
            AUTOMATIC_SHAPELESS.getIdentifier().method_48331("/client/shapeless"),
            AutoMixingDisplay.CraftingDisplayShapeless.SERIALIZER
        );
        registry.register(MIXING.getIdentifier(), MixingDisplay.SERIALIZER);
        registry.register(MILLING.getIdentifier(), MillingDisplay.SERIALIZER);
        registry.register(SAWING.getIdentifier(), SawingDisplay.SERIALIZER);
        registry.register(CRUSHING.getIdentifier(), CrushingDisplay.SERIALIZER);
        registry.register(ITEM_APPLICATION.getIdentifier(), ManualApplicationDisplay.SERIALIZER);
        registry.register(DEPLOYING.getIdentifier(), DeployingDisplay.SERIALIZER);
        registry.register(DRAINING.getIdentifier(), DrainingDisplay.SERIALIZER);
        registry.register(MECHANICAL_CRAFTING.getIdentifier(), MechanicalCraftingDisplay.SERIALIZER);
        registry.register(SPOUT_FILLING.getIdentifier(), SpoutFillingDisplay.SERIALIZER);
        registry.register(SANDPAPER_POLISHING.getIdentifier(), SandpaperPolishingDisplay.SERIALIZER);
        registry.register(SEQUENCED_ASSEMBLY.getIdentifier(), SequencedAssemblyDisplay.SERIALIZER);
        registry.register(BLOCK_CUTTING.getIdentifier(), BlockCuttingDisplay.SERIALIZER);
        registry.register(FAN_BLASTING.getIdentifier(), FanBlastingDisplay.SERIALIZER);
        registry.register(FAN_HAUNTING.getIdentifier(), FanHauntingDisplay.SERIALIZER);
        registry.register(FAN_SMOKING.getIdentifier(), FanSmokingDisplay.SERIALIZER);
        registry.register(FAN_WASHING.getIdentifier(), FanWashingDisplay.SERIALIZER);
        registry.register(AUTOMATIC_BREWING.getIdentifier(), PotionDisplay.SERIALIZER);
    }

    @Override
    public void registerFluidComparators(FluidComparatorRegistry registry) {
        registry.register((context, stack) -> Objects.hash(stack.getFluid(), stack.method_57353()), AllFluids.POTION);
    }
}
