package com.zurrtum.create.content.contraptions;

import com.zurrtum.create.catnip.levelWrappers.WrappedLevel;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3499;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class ContraptionWorld extends WrappedLevel {
    final Contraption contraption;
    private final int minY;
    private final int height;

    public ContraptionWorld(class_1937 world, Contraption contraption) {
        super(world);

        this.contraption = contraption;

        // Include 1 block above/below contraption height range to avoid certain edge-case Starlight crashes with
        // downward-facing mechanical pistons.
        minY = nextMultipleOf16(contraption.bounds.field_1322 - 1);
        height = nextMultipleOf16(contraption.bounds.field_1325 + 1) - minY;
    }

    // https://math.stackexchange.com/questions/291468
    private static int nextMultipleOf16(double a) {
        return (((Math.abs((int) a) - 1) | 15) + 1) * class_3532.method_17822(a);
    }

    @Override
    public class_2680 method_8320(class_2338 pos) {
        class_3499.class_3501 blockInfo = contraption.getBlocks().get(pos);

        if (blockInfo != null)
            return blockInfo.comp_1342();

        return class_2246.field_10124.method_9564();
    }

    @Override
    public @Nullable class_2586 method_8321(class_2338 pos) {
        return contraption.presentBlockEntities.get(pos);
    }

    @Override
    public void method_8486(
        double x,
        double y,
        double z,
        class_3414 sound,
        class_3419 category,
        float volume,
        float pitch,
        boolean distanceDelay
    ) {
        level.method_8486(x, y, z, sound, category, volume, pitch, distanceDelay);
    }

    // Ensure that we provide accurate information about ContraptionWorld height to mods (such as Starlight) which
    // expect Levels to only have blocks located in chunks within their height range.

    @Override
    public int method_31605() {
        return height;
    }

    @Override
    public int method_31607() {
        return minY;
    }
}
