package com.zurrtum.create.content.contraptions.actors.contraptionControls;

import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.animation.LerpedFloat.Chaser;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.IntAttached;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.contraptions.elevator.ElevatorContraption;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_6903;

public class ContraptionControlsMovement extends MovementBehaviour {

    @Override
    public class_1799 canBeDisabledVia(MovementContext context) {
        return null;
    }

    @Override
    public void startMoving(MovementContext context) {
        if (context.contraption instanceof ElevatorContraption && context.blockEntityData != null)
            context.blockEntityData.method_10551("Filter");
    }

    @Override
    public void stopMoving(MovementContext context) {
        class_1799 filter = getFilter(context);
        if (filter != null)
            context.blockEntityData.method_10556(
                "Disabled",
                context.contraption.isActorTypeDisabled(filter) || context.contraption.isActorTypeDisabled(class_1799.field_8037)
            );
    }

    public static boolean isSameFilter(class_1799 stack1, class_1799 stack2) {
        if (stack1.method_7960() && stack2.method_7960())
            return true;
        return class_1799.method_31577(stack1, stack2);
    }

    public static class_1799 getFilter(MovementContext ctx) {
        class_2487 blockEntityData = ctx.blockEntityData;
        if (blockEntityData == null)
            return null;
        class_6903<class_2520> ops = ctx.world.method_30349().method_57093(class_2509.field_11560);
        return blockEntityData.method_67492("Filter", class_1799.field_49266, ops).orElse(class_1799.field_8037);
    }

    public static boolean isDisabledInitially(MovementContext ctx) {
        return ctx.blockEntityData != null && ctx.blockEntityData.method_68566("Disabled", false);
    }

    @Override
    public void tick(MovementContext ctx) {
        if (!ctx.world.method_8608())
            return;

        Contraption contraption = ctx.contraption;
        if (!(contraption instanceof ElevatorContraption ec)) {
            if (!(contraption.presentBlockEntities.get(ctx.localPos) instanceof ContraptionControlsBlockEntity cbe))
                return;
            class_1799 filter = getFilter(ctx);
            int value = contraption.isActorTypeDisabled(filter) || contraption.isActorTypeDisabled(class_1799.field_8037) ? 4 * 45 : 0;
            cbe.indicator.setValue(value);
            cbe.indicator.updateChaseTarget(value);
            cbe.tickAnimations();
            return;
        }

        if (!(ctx.temporaryData instanceof ElevatorFloorSelection))
            ctx.temporaryData = new ElevatorFloorSelection();

        ElevatorFloorSelection efs = (ElevatorFloorSelection) ctx.temporaryData;
        tickFloorSelection(efs, ec);

        if (!(contraption.presentBlockEntities.get(ctx.localPos) instanceof ContraptionControlsBlockEntity cbe))
            return;

        cbe.tickAnimations();

        int currentY = (int) Math.round(contraption.entity.method_23318() + ec.getContactYOffset());
        boolean atTargetY = ec.clientYTarget == currentY;

        LerpedFloat indicator = cbe.indicator;
        float currentIndicator = indicator.getChaseTarget();
        boolean below = atTargetY ? currentIndicator > 0 : ec.clientYTarget <= currentY;

        if (currentIndicator == 0 && !atTargetY) {
            int startingPoint = below ? 181 : -181;
            indicator.setValue(startingPoint);
            indicator.updateChaseTarget(startingPoint);
            cbe.tickAnimations();
            return;
        }

        int currentStage = class_3532.method_15375(((currentIndicator % 360) + 360) % 360);
        if (!atTargetY || currentStage / 45 != 0) {
            float increment = currentStage / 45 == (below ? 4 : 3) ? 2.25f : 33.75f;
            indicator.chase(currentIndicator + (below ? increment : -increment), 45f, Chaser.LINEAR);
            return;
        }

        indicator.setValue(0);
        indicator.updateChaseTarget(0);
    }

    public static void tickFloorSelection(ElevatorFloorSelection efs, ElevatorContraption ec) {
        if (ec.namesList.isEmpty()) {
            efs.currentShortName = "X";
            efs.currentLongName = "No Floors";
            efs.currentIndex = 0;
            efs.targetYEqualsSelection = true;
            return;
        }

        efs.currentIndex = class_3532.method_15340(efs.currentIndex, 0, ec.namesList.size() - 1);
        IntAttached<Couple<String>> entry = ec.namesList.get(efs.currentIndex);
        efs.currentTargetY = entry.getFirst();
        efs.currentShortName = entry.getSecond().getFirst();
        efs.currentLongName = entry.getSecond().getSecond();
        efs.targetYEqualsSelection = efs.currentTargetY == ec.clientYTarget;

        if (ec.isTargetUnreachable(efs.currentTargetY))
            efs.currentLongName = class_2561.method_43471("create.contraption.controls.floor_unreachable").getString();
    }

    public static class ElevatorFloorSelection {
        public int currentIndex = 0;
        public int currentTargetY = 0;
        public boolean targetYEqualsSelection = true;
        public String currentShortName = "";
        public String currentLongName = "";
    }

}
