package com.zurrtum.create.content.contraptions.actors.plough;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.kinetics.base.BlockBreakingMovementBehaviour;
import net.minecraft.block.*;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1540;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2199;
import net.minecraft.class_2246;
import net.minecraft.class_2258;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2404;
import net.minecraft.class_2423;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3726;
import net.minecraft.class_3959;
import net.minecraft.class_3959.class_242;
import net.minecraft.class_3959.class_3960;
import net.minecraft.class_3965;
import net.minecraft.class_8567;
import java.util.Objects;

public class PloughMovementBehaviour extends BlockBreakingMovementBehaviour {

    @Override
    public boolean isActive(MovementContext context) {
        return super.isActive(context) && !VecHelper.isVecPointingTowards(
            context.relativeMotion,
            context.state.method_11654(PloughBlock.field_11177).method_10153()
        );
    }

    @Override
    public void visitNewPosition(MovementContext context, class_2338 pos) {
        super.visitNewPosition(context, pos);
        class_1937 world = context.world;
        if (world.field_9236)
            return;
        class_2338 below = pos.method_10074();
        if (!world.method_8477(below))
            return;

        class_243 vec = VecHelper.getCenterOf(pos);

        class_3965 ray = world.method_17742(new class_3959(vec, vec.method_1031(0, -1, 0), class_3960.field_17559, class_242.field_1348, class_3726.method_16194()));
        if (ray.method_17783() != class_239.class_240.field_1332)
            return;

        class_1838 ctx = new class_1838(world, null, class_1268.field_5808, class_1802.field_8527.method_7854(), ray);
        class_1802.field_8527.method_7884(ctx);
    }

    @Override
    protected void throwEntity(MovementContext context, class_1297 entity) {
        super.throwEntity(context, entity);
        if (!(entity instanceof class_1540 fbe))
            return;
        if (!(fbe.method_6962().method_26204() instanceof class_2199))
            return;
        if (entity.method_18798().method_1033() < 0.25f)
            return;
        entity.method_37908().method_18467(class_1657.class, new class_238(entity.method_24515()).method_1014(32)).stream()
            .map(player -> player instanceof class_3222 serverPlayer ? serverPlayer : null).filter(Objects::nonNull)
            .forEach(AllAdvancements.ANVIL_PLOUGH::trigger);
    }

    @Override
    public class_243 getActiveAreaOffset(MovementContext context) {
        return class_243.method_24954(context.state.method_11654(PloughBlock.field_11177).method_62675()).method_1021(.45);
    }

    @Override
    protected boolean throwsEntities(class_1937 level) {
        return true;
    }

    @Override
    public boolean canBreak(class_1937 world, class_2338 breakingPos, class_2680 state) {
        if (state.method_26215())
            return false;
        if (world.method_8320(breakingPos.method_10074()).method_26204() instanceof class_2344)
            return false;
        if (state.method_26204() instanceof class_2404)
            return false;
        if (state.method_26204() instanceof class_2258)
            return false;
        if (state.method_26204() instanceof class_2423)
            return false;
        //TODO
        //        if (state.getBlock() instanceof ITrackBlock)
        //            return true;
        //        if (state.getBlock() instanceof FakeTrackBlock)
        //            return false;
        return state.method_26220(world, breakingPos).method_1110();
    }

    @Override
    protected void onBlockBroken(MovementContext context, class_2338 pos, class_2680 brokenState) {
        super.onBlockBroken(context, pos, brokenState);

        if (brokenState.method_26204() == class_2246.field_10477 && context.world instanceof class_3218 world) {
            brokenState.method_26189(new class_8567.class_8568(world).method_51874(class_181.field_1224, brokenState)
                .method_51874(class_181.field_1226, context.contraption.entity).method_51874(class_181.field_24424, class_243.method_24953(pos))
                .method_51874(class_181.field_1229, new class_1799(class_1802.field_8699))).forEach(s -> dropItem(context, s));
        }
    }
}
