package com.zurrtum.create.content.contraptions.bearing;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.placement.IPlacementHelper;
import com.zurrtum.create.catnip.placement.PlacementHelpers;
import com.zurrtum.create.catnip.placement.PlacementOffset;
import com.zurrtum.create.foundation.block.WrenchableDirectionalBlock;
import com.zurrtum.create.foundation.utility.BlockHelper;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1820;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;

public class SailBlock extends WrenchableDirectionalBlock {

    public static SailBlock frame(class_2251 properties) {
        return new SailBlock(properties, true, null);
    }

    public static Function<class_2251, SailBlock> withCanvas(class_1767 color) {
        return properties -> new SailBlock(properties, false, color);
    }

    private static final int placementHelperId = PlacementHelpers.register(new PlacementHelper());

    protected final boolean frame;
    protected final class_1767 color;

    protected SailBlock(class_2251 properties, boolean frame, class_1767 color) {
        super(properties);
        this.frame = frame;
        this.color = color;
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2680 state = super.method_9605(context);
        return state.method_11657(field_10927, state.method_11654(field_10927).method_10153());
    }


    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        IPlacementHelper placementHelper = PlacementHelpers.get(placementHelperId);
        if (!player.method_5715() && player.method_7294()) {
            if (placementHelper.matchesItem(stack)) {
                placementHelper.getOffset(player, level, state, pos, hitResult).placeInWorld(level, (class_1747) stack.method_7909(), player, hand);
                return class_1269.field_5812;
            }
        }

        if (stack.method_7909() instanceof class_1820) {
            if (!level.field_9236)
                level.method_8396(null, pos, class_3417.field_14975, class_3419.field_15245, 1.0f, 1.0f);
            applyDye(state, level, pos, hitResult.method_17784(), null);
            return class_1269.field_5812;
        }

        if (frame)
            return class_1269.field_52423;

        class_1767 color = AllItemTags.getDyeColor(stack);
        if (color != null) {
            if (!level.field_9236)
                level.method_8396(null, pos, class_3417.field_28391, class_3419.field_15245, 1.0f, 1.1f - level.field_9229.method_43057() * .2f);
            applyDye(state, level, pos, hitResult.method_17784(), color);
            return class_1269.field_5812;
        }

        return class_1269.field_52423;
    }

    public SailBlock getColorBlock(class_1767 color) {
        return switch (color) {
            case field_7946 -> AllBlocks.ORANGE_SAIL;
            case field_7958 -> AllBlocks.MAGENTA_SAIL;
            case field_7951 -> AllBlocks.LIGHT_BLUE_SAIL;
            case field_7947 -> AllBlocks.YELLOW_SAIL;
            case field_7961 -> AllBlocks.LIME_SAIL;
            case field_7954 -> AllBlocks.PINK_SAIL;
            case field_7944 -> AllBlocks.GRAY_SAIL;
            case field_7967 -> AllBlocks.LIGHT_GRAY_SAIL;
            case field_7955 -> AllBlocks.CYAN_SAIL;
            case field_7945 -> AllBlocks.PURPLE_SAIL;
            case field_7966 -> AllBlocks.BLUE_SAIL;
            case field_7957 -> AllBlocks.BROWN_SAIL;
            case field_7942 -> AllBlocks.GREEN_SAIL;
            case field_7964 -> AllBlocks.RED_SAIL;
            case field_7963 -> AllBlocks.BLACK_SAIL;
            default -> AllBlocks.SAIL;
        };
    }

    public void applyDye(class_2680 state, class_1937 world, class_2338 pos, class_243 hit, @Nullable class_1767 color) {
        class_2680 newState = (color == null ? AllBlocks.SAIL_FRAME : getColorBlock(color)).method_9564();
        newState = BlockHelper.copyProperties(state, newState);

        // Dye the block itself
        if (state != newState) {
            world.method_8501(pos, newState);
            return;
        }

        // Dye all adjacent
        List<class_2350> directions = IPlacementHelper.orderedByDistanceExceptAxis(pos, hit, state.method_11654(field_10927).method_10166());
        for (class_2350 d : directions) {
            class_2338 offset = pos.method_10093(d);
            class_2680 adjacentState = world.method_8320(offset);
            class_2248 block = adjacentState.method_26204();
            if (!(block instanceof SailBlock) || ((SailBlock) block).frame)
                continue;
            if (state.method_11654(field_10927) != adjacentState.method_11654(field_10927))
                continue;
            if (state == adjacentState)
                continue;
            world.method_8501(offset, newState);
            return;
        }

        // Dye all the things
        List<class_2338> frontier = new ArrayList<>();
        frontier.add(pos);
        Set<class_2338> visited = new HashSet<>();
        int timeout = 100;
        while (!frontier.isEmpty()) {
            if (timeout-- < 0)
                break;

            class_2338 currentPos = frontier.remove(0);
            visited.add(currentPos);

            for (class_2350 d : Iterate.directions) {
                if (d.method_10166() == state.method_11654(field_10927).method_10166())
                    continue;
                class_2338 offset = currentPos.method_10093(d);
                if (visited.contains(offset))
                    continue;
                class_2680 adjacentState = world.method_8320(offset);
                class_2248 block = adjacentState.method_26204();
                if (!(block instanceof SailBlock) || ((SailBlock) block).frame && color != null)
                    continue;
                if (adjacentState.method_11654(field_10927) != state.method_11654(field_10927))
                    continue;
                if (state != adjacentState)
                    world.method_8501(offset, newState);
                frontier.add(offset);
                visited.add(offset);
            }
        }
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 p_220053_2_, class_2338 p_220053_3_, class_3726 p_220053_4_) {
        return (frame ? AllShapes.SAIL_FRAME : AllShapes.SAIL).get(state.method_11654(field_10927));
    }

    @Override
    public class_265 method_9549(class_2680 state, class_1922 p_220071_2_, class_2338 p_220071_3_, class_3726 p_220071_4_) {
        return (frame ? AllShapes.SAIL_FRAME_COLLISION : AllShapes.SAIL).get(state.method_11654(field_10927));
    }

    @Override
    protected class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state, boolean includeData) {
        class_1799 pickBlock = super.method_9574(world, pos, state, includeData);
        if (pickBlock.method_7960())
            return AllBlocks.SAIL.method_9574(world, pos, state, includeData);
        return pickBlock;
    }

    @Override
    public void method_9554(class_1937 p_152426_, class_2680 p_152427_, class_2338 p_152428_, class_1297 p_152429_, double p_152430_) {
        if (frame)
            super.method_9554(p_152426_, p_152427_, p_152428_, p_152429_, p_152430_);
        super.method_9554(p_152426_, p_152427_, p_152428_, p_152429_, 0);
    }

    @Override
    public void method_9502(class_1922 p_176216_1_, class_1297 p_176216_2_) {
        if (frame || p_176216_2_.method_21750()) {
            super.method_9502(p_176216_1_, p_176216_2_);
        } else {
            this.bounce(p_176216_2_);
        }
    }

    private void bounce(class_1297 p_226860_1_) {
        class_243 Vector3d = p_226860_1_.method_18798();
        if (Vector3d.field_1351 < 0.0D) {
            double d0 = p_226860_1_ instanceof class_1309 ? 1.0D : 0.8D;
            p_226860_1_.method_18800(Vector3d.field_1352, -Vector3d.field_1351 * (double) 0.26F * d0, Vector3d.field_1350);
        }

    }

    @Override
    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

    public boolean isFrame() {
        return frame;
    }

    public class_1767 getColor() {
        return color;
    }

    private static class PlacementHelper implements IPlacementHelper {
        @Override
        public Predicate<class_1799> getItemPredicate() {
            return stack -> stack.method_31574(AllItems.SAIL) || stack.method_31574(AllItems.SAIL_FRAME);
        }

        @Override
        public Predicate<class_2680> getStatePredicate() {
            return state -> state.method_26204() instanceof SailBlock;
        }

        @Override
        public PlacementOffset getOffset(class_1657 player, class_1937 world, class_2680 state, class_2338 pos, class_3965 ray) {
            List<class_2350> directions = IPlacementHelper.orderedByDistanceExceptAxis(
                pos,
                ray.method_17784(),
                state.method_11654(SailBlock.field_10927).method_10166(),
                dir -> world.method_8320(pos.method_10093(dir)).method_45474()
            );

            if (directions.isEmpty())
                return PlacementOffset.fail();
            else {
                return PlacementOffset.success(pos.method_10093(directions.get(0)), s -> s.method_11657(field_10927, state.method_11654(field_10927)));
            }
        }
    }
}
