package com.zurrtum.create.content.contraptions.behaviour;

import com.zurrtum.create.api.behaviour.interaction.MovingInteractionBehaviour;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3499.class_3501;

public abstract class SimpleBlockMovingInteraction extends MovingInteractionBehaviour {

    @Override
    public boolean handlePlayerInteraction(class_1657 player, class_1268 activeHand, class_2338 localPos, AbstractContraptionEntity contraptionEntity) {
        Contraption contraption = contraptionEntity.getContraption();
        class_3501 info = contraption.getBlocks().get(localPos);

        class_2680 newState = handle(player, contraption, localPos, info.comp_1342());
        if (info.comp_1342() == newState)
            return false;

        setContraptionBlockData(contraptionEntity, localPos, new class_3501(info.comp_1341(), newState, info.comp_1343()));
        if (updateColliders())
            contraption.invalidateColliders();
        return true;
    }

    protected boolean updateColliders() {
        return false;
    }

    protected void playSound(class_1657 player, class_3414 sound, float pitch) {
        player.method_37908().method_8396(player, player.method_24515(), sound, class_3419.field_15245, 0.3f, pitch);
    }

    protected abstract class_2680 handle(class_1657 player, Contraption contraption, class_2338 pos, class_2680 currentState);

}
