package com.zurrtum.create.content.contraptions.behaviour.dispenser;

import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.api.contraption.dispenser.DefaultMountedDispenseBehavior;
import com.zurrtum.create.api.contraption.dispenser.MountedDispenseBehavior;
import com.zurrtum.create.api.contraption.storage.item.MountedItemStorage;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import net.minecraft.class_1263;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_5819;
import net.minecraft.class_6088;

public class DropperMovementBehaviour extends MovementBehaviour {
    @Override
    public void visitNewPosition(MovementContext context, class_2338 pos) {
        if (context.world.field_9236)
            return;

        MountedItemStorage storage = context.getItemStorage();
        if (storage == null)
            return;

        int slot = getSlot(storage, context.world.field_9229, context.contraption.getStorage().getAllItems());
        if (slot == -1) {
            // all slots empty
            failDispense(context, pos);
            return;
        }

        // copy because dispense behaviors will modify it directly
        class_1799 stack = storage.method_5438(slot).method_7972();
        MountedDispenseBehavior behavior = getDispenseBehavior(context, pos, stack);
        class_1799 remainder = behavior.dispense(stack, context, pos);
        storage.method_5447(slot, remainder);
    }

    protected MountedDispenseBehavior getDispenseBehavior(MovementContext context, class_2338 pos, class_1799 stack) {
        return DefaultMountedDispenseBehavior.INSTANCE;
    }

    /**
     * Finds a dispensable slot. Empty slots are skipped and nearly-empty slots are topped off.
     */
    private static int getSlot(MountedItemStorage storage, class_5819 random, class_1263 contraptionInventory) {
        IntList filledSlots = new IntArrayList();
        for (int i = 0, size = storage.method_5439(); i < size; i++) {
            class_1799 stack = storage.method_5438(i);
            if (stack.method_7960())
                continue;

            if (stack.method_7947() == 1 && stack.method_7914() != 1) {
                storage.method_5447(i, class_1799.field_8037);
                boolean fill = tryTopOff(stack, contraptionInventory);
                storage.method_5447(i, stack);
                if (!fill) {
                    continue;
                }
            }

            filledSlots.add(i);
        }

        return switch (filledSlots.size()) {
            case 0 -> -1;
            case 1 -> filledSlots.getInt(0);
            default -> class_156.method_32309(filledSlots, random);
        };
    }

    private static boolean tryTopOff(class_1799 stack, class_1263 from) {
        int count = stack.method_7947();
        int extract = from.extract(stack, stack.method_7914() - count);
        if (extract == 0) {
            return false;
        }
        stack.method_7939(count + extract);
        return true;
    }

    private static void failDispense(MovementContext ctx, class_2338 pos) {
        ctx.world.method_20290(class_6088.field_31159, pos, 0);
    }
}