package com.zurrtum.create.content.contraptions.pulley;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.api.contraption.BlockMovementChecks;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.AssemblyException;
import com.zurrtum.create.content.contraptions.ContraptionCollider;
import com.zurrtum.create.content.contraptions.ControlledContraptionEntity;
import com.zurrtum.create.content.contraptions.piston.LinearActuatorBlockEntity;
import com.zurrtum.create.content.redstone.thresholdSwitch.ThresholdSwitchObservable;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_5250;
import net.minecraft.util.math.*;
import org.jetbrains.annotations.Nullable;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class PulleyBlockEntity extends LinearActuatorBlockEntity implements ThresholdSwitchObservable {

    protected int initialOffset;
    private float prevAnimatedOffset;

    protected class_2338 mirrorParent;
    protected List<class_2338> mirrorChildren;
    public WeakReference<AbstractContraptionEntity> sharedMirrorContraption;

    public PulleyBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public PulleyBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.ROPE_PULLEY, pos, state);
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        double expandY = -offset;
        if (sharedMirrorContraption != null) {
            AbstractContraptionEntity ace = sharedMirrorContraption.get();
            if (ace != null)
                expandY = ace.method_23318() - field_11867.method_10264();
        }
        return super.createRenderBoundingBox().method_1009(0, expandY, 0);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.PULLEY_MAXED);
    }

    @Override
    public void tick() {
        float prevOffset = offset;
        super.tick();

        if (field_11863.method_8608() && mirrorParent != null)
            if (sharedMirrorContraption == null || sharedMirrorContraption.get() == null || !sharedMirrorContraption.get().method_5805()) {
                sharedMirrorContraption = null;
                if (field_11863.method_8321(mirrorParent) instanceof PulleyBlockEntity pte && pte.movedContraption != null)
                    sharedMirrorContraption = new WeakReference<>(pte.movedContraption);
            }

        if (isVirtual())
            prevAnimatedOffset = offset;
        invalidateRenderBoundingBox();

        if (prevOffset < 200 && offset >= 200)
            award(AllAdvancements.PULLEY_MAXED);
    }

    @Override
    protected boolean isPassive() {
        return mirrorParent != null;
    }

    @Nullable
    public AbstractContraptionEntity getAttachedContraption() {
        return mirrorParent != null && sharedMirrorContraption != null ? sharedMirrorContraption.get() : movedContraption;
    }

    @Override
    protected void assemble() throws AssemblyException {
        if (!(field_11863.method_8320(field_11867).method_26204() instanceof PulleyBlock))
            return;
        if (speed == 0 && mirrorParent == null)
            return;
        int maxLength = AllConfigs.server().kinetics.maxRopeLength.get();
        int i = 1;
        while (i <= maxLength) {
            class_2338 ropePos = field_11867.method_10087(i);
            class_2680 ropeState = field_11863.method_8320(ropePos);
            if (!ropeState.method_27852(AllBlocks.ROPE) && !ropeState.method_27852(AllBlocks.PULLEY_MAGNET)) {
                break;
            }
            ++i;
        }
        offset = i - 1;
        if (offset >= getExtensionRange() && getSpeed() > 0)
            return;
        if (offset <= 0 && getSpeed() < 0)
            return;

        // Collect Construct
        if (!field_11863.field_9236 && mirrorParent == null) {
            needsContraption = false;
            class_2338 anchor = field_11867.method_10087(class_3532.method_15375(offset + 1));
            initialOffset = class_3532.method_15375(offset);
            PulleyContraption contraption = new PulleyContraption(initialOffset);
            boolean canAssembleStructure = contraption.assemble(field_11863, anchor);

            if (canAssembleStructure) {
                class_2350 movementDirection = getSpeed() > 0 ? class_2350.field_11033 : class_2350.field_11036;
                if (ContraptionCollider.isCollidingWithWorld(field_11863, contraption, anchor.method_10093(movementDirection), movementDirection))
                    canAssembleStructure = false;
            }

            if (!canAssembleStructure && getSpeed() > 0)
                return;

            removeRopes();

            if (!contraption.getBlocks().isEmpty()) {
                contraption.removeBlocksFromWorld(field_11863, class_2338.field_10980);
                movedContraption = ControlledContraptionEntity.create(field_11863, this, contraption);
                movedContraption.method_5814(anchor.method_10263(), anchor.method_10264(), anchor.method_10260());
                field_11863.method_8649(movedContraption);
                forceMove = true;
                needsContraption = true;

                if (contraption.containsBlockBreakers())
                    award(AllAdvancements.CONTRAPTION_ACTORS);

                for (class_2338 pos : contraption.createColliders(field_11863, class_2350.field_11036)) {
                    if (pos.method_10264() != 0)
                        continue;
                    pos = pos.method_10081(anchor);
                    if (field_11863.method_8321(new class_2338(pos.method_10263(), this.field_11867.method_10264(), pos.method_10260())) instanceof PulleyBlockEntity pbe)
                        pbe.startMirroringOther(this.field_11867);
                }
            }
        }

        if (mirrorParent != null)
            removeRopes();

        clientOffsetDiff = 0;
        running = true;
        sendData();
    }

    private void removeRopes() {
        for (int i = ((int) offset); i > 0; i--) {
            class_2338 offset = field_11867.method_10087(i);
            class_2680 oldState = field_11863.method_8320(offset);
            field_11863.method_8652(offset, oldState.method_26227().method_15759(), class_2248.field_31028 | class_2248.field_31033);
        }
    }

    @Override
    public void disassemble() {
        if (!running && movedContraption == null && mirrorParent == null)
            return;
        offset = getGridOffset(offset);
        if (movedContraption != null)
            resetContraptionToOffset();

        if (!field_11863.field_9236) {
            if (shouldCreateRopes()) {
                if (offset > 0) {
                    class_2338 magnetPos = field_11867.method_10087((int) offset);
                    class_3610 ifluidstate = field_11863.method_8316(magnetPos);
                    if (field_11863.method_8320(magnetPos).method_26214(field_11863, magnetPos) != -1) {

                        field_11863.method_22352(magnetPos, field_11863.method_8320(magnetPos).method_26220(field_11863, magnetPos).method_1110());
                        field_11863.method_8652(
                            magnetPos,
                            AllBlocks.PULLEY_MAGNET.method_9564()
                                .method_11657(class_2741.field_12508, Boolean.valueOf(ifluidstate.method_15772() == class_3612.field_15910)),
                            class_2248.field_31028 | class_2248.field_31033
                        );
                    }
                }

                boolean[] waterlog = new boolean[(int) offset];

                for (boolean destroyPass : Iterate.trueAndFalse) {
                    for (int i = 1; i <= ((int) offset) - 1; i++) {
                        class_2338 ropePos = field_11867.method_10087(i);
                        if (field_11863.method_8320(ropePos).method_26214(field_11863, ropePos) == -1)
                            continue;

                        if (destroyPass) {
                            class_3610 ifluidstate = field_11863.method_8316(ropePos);
                            waterlog[i] = ifluidstate.method_15772() == class_3612.field_15910;
                            field_11863.method_22352(ropePos, field_11863.method_8320(ropePos).method_26220(field_11863, ropePos).method_1110());
                            continue;
                        }

                        field_11863.method_8652(
                            field_11867.method_10087(i),
                            AllBlocks.ROPE.method_9564().method_11657(class_2741.field_12508, waterlog[i]),
                            class_2248.field_31028 | class_2248.field_31033
                        );
                    }
                }

            }

            if (movedContraption != null && mirrorParent == null)
                movedContraption.disassemble();
            notifyMirrorsOfDisassembly();
        }

        if (movedContraption != null)
            movedContraption.method_31472();

        movedContraption = null;
        initialOffset = 0;
        running = false;
        sendData();
    }

    protected boolean shouldCreateRopes() {
        return !field_11865;
    }

    @Override
    protected class_243 toPosition(float offset) {
        if (movedContraption.getContraption() instanceof PulleyContraption contraption) {
            return class_243.method_24954(contraption.anchor).method_1031(0, contraption.getInitialOffset() - offset, 0);

        }
        return class_243.field_1353;
    }

    @Override
    protected void visitNewPosition() {
        super.visitNewPosition();
        if (field_11863.field_9236)
            return;
        if (movedContraption != null)
            return;
        if (getSpeed() <= 0)
            return;

        class_2338 posBelow = field_11867.method_10087((int) (offset + getMovementSpeed()) + 1);
        class_2680 state = field_11863.method_8320(posBelow);
        if (!BlockMovementChecks.isMovementNecessary(state, field_11863, posBelow))
            return;
        if (BlockMovementChecks.isBrittle(state))
            return;

        disassemble();
        assembleNextTick = true;
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        initialOffset = view.method_71424("InitialOffset", 0);
        needsContraption = view.method_71433("NeedsContraption", false);
        super.read(view, clientPacket);

        class_2338 prevMirrorParent = mirrorParent;
        mirrorParent = view.method_71426("MirrorParent", class_2338.field_25064).orElse(null);
        mirrorChildren = view.method_71426("MirrorChildren", CreateCodecs.BLOCK_POS_LIST_CODEC).map(ArrayList::new).orElse(null);

        if (mirrorParent != null) {
            offset = 0;
            if (prevMirrorParent == null || !prevMirrorParent.equals(mirrorParent))
                sharedMirrorContraption = null;
        }

        if (mirrorParent == null)
            sharedMirrorContraption = null;
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        view.method_71465("InitialOffset", initialOffset);
        super.write(view, clientPacket);

        if (mirrorParent != null)
            view.method_71468("MirrorParent", class_2338.field_25064, mirrorParent);
        if (mirrorChildren != null)
            view.method_71468("MirrorChildren", CreateCodecs.BLOCK_POS_LIST_CODEC, mirrorChildren);
    }

    public void startMirroringOther(class_2338 parent) {
        if (parent.equals(field_11867))
            return;
        if (!(field_11863.method_8321(parent) instanceof PulleyBlockEntity pbe))
            return;
        if (pbe.method_11017() != method_11017())
            return;
        if (pbe.mirrorChildren == null)
            pbe.mirrorChildren = new ArrayList<>();
        pbe.mirrorChildren.add(field_11867);
        pbe.notifyUpdate();

        mirrorParent = parent;
        try {
            assemble();
        } catch (AssemblyException e) {
        }
        notifyUpdate();
    }

    public void notifyMirrorsOfDisassembly() {
        if (mirrorChildren == null)
            return;
        for (class_2338 blockPos : mirrorChildren) {
            if (!(field_11863.method_8321(blockPos) instanceof PulleyBlockEntity pbe))
                continue;
            pbe.offset = offset;
            pbe.disassemble();
            pbe.mirrorParent = null;
            pbe.notifyUpdate();
        }
        mirrorChildren.clear();
        notifyUpdate();
    }

    @Override
    protected int getExtensionRange() {
        return Math.max(0, Math.min(AllConfigs.server().kinetics.maxRopeLength.get(), (field_11867.method_10264() - 1) - field_11863.method_31607()));
    }

    @Override
    protected int getInitialOffset() {
        return initialOffset;
    }

    @Override
    protected class_243 toMotionVector(float speed) {
        return new class_243(0, -speed, 0);
    }

    @Override
    public float getInterpolatedOffset(float partialTicks) {
        if (isVirtual())
            return class_3532.method_16439(partialTicks, prevAnimatedOffset, offset);
        boolean moving = running && (movedContraption == null || !movedContraption.isStalled());
        return super.getInterpolatedOffset(moving ? partialTicks : 0.5f);
    }

    public void animateOffset(float forcedOffset) {
        offset = forcedOffset;
    }

    public class_2338 getMirrorParent() {
        return mirrorParent;
    }

    // Threshold switch

    @Override
    public int getCurrentValue() {
        return field_11867.method_10264() - (int) getInterpolatedOffset(.5f);
    }

    @Override
    public int getMinValue() {
        return field_11863.method_31607();
    }

    @Override
    public int getMaxValue() {
        return field_11867.method_10264();
    }

    @Override
    public class_5250 format(int value) {
        return class_2561.method_43469("create.gui.threshold_switch.pulley_y_level", value);
    }

}
