package com.zurrtum.create.content.decoration.copycat;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlockTags;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.foundation.block.*;
import net.minecraft.block.*;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2498;
import net.minecraft.class_2510;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5558;
import net.minecraft.class_6088;
import net.minecraft.world.*;
import org.jetbrains.annotations.Nullable;

public abstract class CopycatBlock extends class_2248 implements IBE<CopycatBlockEntity>, IWrenchable, ResistanceControlBlock, SlipperinessControlBlock, EnchantingControlBlock, AppearanceControlBlock, SoundControlBlock, LightControlBlock {

    public CopycatBlock(class_2251 pProperties) {
        super(pProperties);
    }

    @Nullable
    @Override
    public <S extends class_2586> class_5558<S> method_31645(class_1937 p_153212_, class_2680 p_153213_, class_2591<S> p_153214_) {
        return null;
    }

    @Override
    public class_1269 onSneakWrenched(class_2680 state, class_1838 context) {
        onWrenched(state, context);
        return IWrenchable.super.onSneakWrenched(state, context);
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        return onBlockEntityUse(
            context.method_8045(), context.method_8037(), ufte -> {
                class_1799 consumedItem = ufte.getConsumedItem();
                if (!ufte.hasCustomMaterial())
                    return class_1269.field_5811;
                class_1657 player = context.method_8036();
                if (!player.method_68878())
                    player.method_31548().method_7398(consumedItem);
                context.method_8045().method_20290(class_6088.field_31144, context.method_8037(), class_2248.method_9507(ufte.method_11010()));
                ufte.setMaterial(AllBlocks.COPYCAT_BASE.method_9564());
                ufte.setConsumedItem(class_1799.field_8037);
                return class_1269.field_5812;
            }
        );
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        if (player == null)
            return class_1269.field_52423;

        class_2350 face = hitResult.method_17780();
        class_2680 materialIn = getAcceptedBlockState(level, pos, stack, face);

        if (materialIn != null)
            materialIn = prepareMaterial(level, pos, state, player, hand, hitResult, materialIn);
        if (materialIn == null)
            return class_1269.field_52423;

        class_2680 material = materialIn;
        return onBlockEntityUseItemOn(
            level, pos, ufte -> {
                if (ufte.getMaterial().method_27852(material.method_26204())) {
                    if (!ufte.cycleMaterial())
                        return class_1269.field_52423;
                    ufte.method_10997().method_8396(null, ufte.method_11016(), class_3417.field_14667, class_3419.field_15245, .75f, .95f);
                    return class_1269.field_5812;
                }
                if (ufte.hasCustomMaterial())
                    return class_1269.field_52423;
                if (level.method_8608())
                    return class_1269.field_5812;

                ufte.setMaterial(material);
                ufte.setConsumedItem(stack);
                ufte.method_10997().method_8396(null, ufte.method_11016(), material.method_26231().method_10598(), class_3419.field_15245, 1, .75f);

                if (player.method_68878())
                    return class_1269.field_5812;

                stack.method_7934(1);
                if (stack.method_7960())
                    player.method_6122(hand, class_1799.field_8037);
                return class_1269.field_5812;
            }
        );
    }

    @Override
    public void method_9567(class_1937 pLevel, class_2338 pPos, class_2680 pState, class_1309 pPlacer, class_1799 pStack) {
        if (pPlacer == null)
            return;
        class_1799 offhandItem = pPlacer.method_5998(class_1268.field_5810);
        class_2680 appliedState = getAcceptedBlockState(pLevel, pPos, offhandItem, class_2350.method_10159(pPlacer)[0]);

        if (appliedState == null)
            return;
        withBlockEntityDo(
            pLevel, pPos, ufte -> {
                if (ufte.hasCustomMaterial())
                    return;

                ufte.setMaterial(appliedState);
                ufte.setConsumedItem(offhandItem);

                if (pPlacer instanceof class_1657 player && player.method_68878())
                    return;
                offhandItem.method_7934(1);
                if (offhandItem.method_7960())
                    pPlacer.method_6122(class_1268.field_5810, class_1799.field_8037);
            }
        );
    }

    @Nullable
    public class_2680 getAcceptedBlockState(class_1937 pLevel, class_2338 pPos, class_1799 item, class_2350 face) {
        if (!(item.method_7909() instanceof class_1747 bi))
            return null;

        class_2248 block = bi.method_7711();
        if (block instanceof CopycatBlock)
            return null;

        class_2680 appliedState = block.method_9564();
        boolean hardCodedAllow = isAcceptedRegardless(appliedState);

        if (!appliedState.method_26164(AllBlockTags.COPYCAT_ALLOW) && !hardCodedAllow) {

            if (appliedState.method_26164(AllBlockTags.COPYCAT_DENY))
                return null;
            if (block instanceof class_2343)
                return null;
            if (block instanceof class_2510)
                return null;

            if (pLevel != null) {
                class_265 shape = appliedState.method_26218(pLevel, pPos);
                if (shape.method_1110() || !shape.method_1107().equals(class_259.method_1077().method_1107()))
                    return null;

                class_265 collisionShape = appliedState.method_26220(pLevel, pPos);
                if (collisionShape.method_1110())
                    return null;
            }
        }

        if (face != null) {
            class_2351 axis = face.method_10166();

            if (appliedState.method_28498(class_2741.field_12525))
                appliedState = appliedState.method_11657(class_2741.field_12525, face);
            if (appliedState.method_28498(class_2741.field_12481) && axis != class_2351.field_11052)
                appliedState = appliedState.method_11657(class_2741.field_12481, face);
            if (appliedState.method_28498(class_2741.field_12496))
                appliedState = appliedState.method_11657(class_2741.field_12496, axis);
            if (appliedState.method_28498(class_2741.field_12529) && axis != class_2351.field_11052)
                appliedState = appliedState.method_11657(class_2741.field_12529, axis);
        }

        return appliedState;
    }

    public boolean isAcceptedRegardless(class_2680 material) {
        return false;
    }

    public class_2680 prepareMaterial(
        class_1937 pLevel,
        class_2338 pPos,
        class_2680 pState,
        class_1657 pPlayer,
        class_1268 pHand,
        class_3965 pHit,
        class_2680 material
    ) {
        return material;
    }

    @Override
    public class_2680 method_9576(class_1937 pLevel, class_2338 pPos, class_2680 pState, class_1657 pPlayer) {
        super.method_9576(pLevel, pPos, pState, pPlayer);
        if (pPlayer.method_68878())
            withBlockEntityDo(pLevel, pPos, ufte -> ufte.setConsumedItem(class_1799.field_8037));
        return pState;
    }

    @Override
    public Class<CopycatBlockEntity> getBlockEntityClass() {
        return CopycatBlockEntity.class;
    }

    @Override
    public class_2591<? extends CopycatBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.COPYCAT;
    }

    // Connected Textures

    @Override
    public class_2680 getAppearance(
        class_2680 state,
        class_1920 level,
        class_2338 pos,
        class_2350 side,
        @Nullable class_2680 queryState,
        @Nullable class_2338 queryPos
    ) {
        if (isIgnoredConnectivitySide(level, state, side, pos, queryPos))
            return state;

        class_2680 material = getMaterial(level, pos);
        return material != null ? material : AllBlocks.COPYCAT_BASE.method_9564();
    }

    public boolean isIgnoredConnectivitySide(
        class_1920 reader,
        class_2680 state,
        class_2350 face,
        @Nullable class_2338 fromPos,
        @Nullable class_2338 toPos
    ) {
        return false;
    }

    public abstract boolean canConnectTexturesToward(class_1920 reader, class_2338 fromPos, class_2338 toPos, class_2680 state);

    //

    public static class_2680 getMaterial(class_1922 reader, class_2338 targetPos) {
        if (reader.method_8321(targetPos) instanceof CopycatBlockEntity cbe)
            return cbe.getMaterial();
        return class_2246.field_10124.method_9564();
    }

    public boolean canFaceBeOccluded(class_2680 state, class_2350 face) {
        return false;
    }

    public boolean shouldFaceAlwaysRender(class_2680 state, class_2350 face) {
        return false;
    }

    // Wrapped properties

    @Override
    public class_2498 getSoundGroup(class_4538 level, class_2338 pos) {
        return getMaterial(level, pos).method_26231();
    }

    @Override
    public float getSlipperiness(class_4538 world, class_2338 pos) {
        class_2680 state = getMaterial(world, pos);
        class_2248 material = state.method_26204();
        if (material instanceof SlipperinessControlBlock block) {
            return block.getSlipperiness(world, pos);
        }
        return material.method_9499();
    }

    @Override
    public int getLuminance(class_1922 world, class_2338 pos) {
        return getMaterial(world, pos).method_26213();
    }

    @Override
    public float getResistance(class_1922 level, class_2338 pos) {
        return getMaterial(level, pos).method_26204().method_9520();
    }

    @Override
    protected class_1799 method_9574(class_4538 level, class_2338 pos, class_2680 state, boolean includeData) {
        class_2680 material = getMaterial(level, pos);
        if (material.method_27852(AllBlocks.COPYCAT_BASE))
            return new class_1799(this);
        return material.method_65171(level, pos, includeData);
    }

    @Override
    public class_2680 getEnchantmentPowerProvider(class_1937 world, class_2338 pos) {
        return getMaterial(world, pos);
    }

    @Override
    public void method_9554(class_1937 pLevel, class_2680 pState, class_2338 pPos, class_1297 pEntity, double p_152430_) {
        class_2680 material = getMaterial(pLevel, pPos);
        material.method_26204().method_9554(pLevel, material, pPos, pEntity, p_152430_);
    }

    @Override
    public float method_9594(class_2680 pState, class_1657 pPlayer, class_1922 pLevel, class_2338 pPos) {
        return getMaterial(pLevel, pPos).method_26165(pPlayer, pLevel, pPos);
    }
}