package com.zurrtum.create.content.equipment.extendoGrip;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.content.equipment.armor.BacktankUtil;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

import static com.zurrtum.create.Create.MOD_ID;

public class ExtendoGripItem extends class_1792 {
    public static final class_1322 singleRangeAttributeModifier = new class_1322(
        class_2960.method_60655(
            MOD_ID,
            "single_range_attribute_modifier"
    ), 3, class_1322.class_1323.field_6328
    );
    public static final class_1322 doubleRangeAttributeModifier = new class_1322(
        class_2960.method_60655(
            MOD_ID,
            "double_range_attribute_modifier"
    ), 2, class_1322.class_1323.field_6328
    );
    public static final class_1322 attackKnockbackAttributeModifier = new class_1322(
        class_2960.method_60655(
            MOD_ID,
            "attack_knockback_attribute_modifier"
    ), 4, class_1322.class_1323.field_6328
    );
    public static final class_9285 rangeModifier = class_9285.method_57480()
        .method_57487(class_5134.field_47758, singleRangeAttributeModifier, class_9274.field_49219)
        .method_57487(class_5134.field_47759, singleRangeAttributeModifier, class_9274.field_49219)
        .method_57487(class_5134.field_23722, attackKnockbackAttributeModifier, class_9274.field_49219).method_57486();
    public static final class_9285 doubleRangeModifier = class_9285.method_57480()
        .method_57487(class_5134.field_47758, doubleRangeAttributeModifier, class_9274.field_49217)
        .method_57487(class_5134.field_47759, doubleRangeAttributeModifier, class_9274.field_49217).method_57486();

    public ExtendoGripItem(class_1793 properties) {
        super(properties);
    }

    @Override
    public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
        class_9285 modifiers = stack.method_58694(class_9334.field_49636);
        if (slot == class_1304.field_6173) {
            if (entity instanceof class_1309 livingEntity && livingEntity.method_6118(class_1304.field_6171).method_31574(AllItems.EXTENDO_GRIP)) {
                if (modifiers != doubleRangeModifier) {
                    stack.method_57379(class_9334.field_49636, doubleRangeModifier);
                    livingEntity.field_55951.get(slot).method_57381(class_9334.field_49636);
                    if (entity instanceof class_3222 serverPlayer) {
                        AllAdvancements.EXTENDO_GRIP_DUAL.trigger(serverPlayer);
                    }
                }
            } else {
                applyAttributeModifiers(stack, modifiers, rangeModifier);
                if (entity instanceof class_3222 serverPlayer) {
                    AllAdvancements.EXTENDO_GRIP.trigger(serverPlayer);
                }
            }
        } else {
            applyAttributeModifiers(stack, modifiers, rangeModifier);
        }
    }

    private static void applyAttributeModifiers(class_1799 stack, class_9285 oldComponent, class_9285 newComponent) {
        if (oldComponent != newComponent) {
            stack.method_57379(class_9334.field_49636, newComponent);
        }
    }

    public static void postDamageEntity(class_1657 player) {
        if (damageMainHand(player, player.method_6047())) {
            return;
        }
        damageOffHand(player);
    }

    public static void postPlace(class_1657 player) {
        damageOffHand(player);
    }

    public static void postMine(class_1657 player, class_1799 stack) {
        if (damageMainHand(player, stack)) {
            return;
        }
        damageOffHand(player);
    }

    private static boolean damageMainHand(class_1657 player, class_1799 stack) {
        if (stack.method_31574(AllItems.EXTENDO_GRIP)) {
            damage(player, class_1304.field_6173, stack);
            return true;
        }
        return false;
    }

    private static void damageOffHand(class_1657 player) {
        class_1799 stack = player.method_6079();
        if (stack.method_31574(AllItems.EXTENDO_GRIP)) {
            damage(player, class_1304.field_6171, stack);
        }
    }

    private static void damage(class_1657 player, class_1304 slot, class_1799 stack) {
        if (!BacktankUtil.canAbsorbDamage(player, maxUses())) {
            stack.method_7970(1, player, slot);
        }
    }

    @Override
    public boolean method_31567(class_1799 stack) {
        return BacktankUtil.isBarVisible(stack, maxUses());
    }

    @Override
    public int method_31569(class_1799 stack) {
        return BacktankUtil.getBarWidth(stack, maxUses());
    }

    @Override
    public int method_31571(class_1799 stack) {
        return BacktankUtil.getBarColor(stack, maxUses());
    }

    private static int maxUses() {
        return AllConfigs.server().equipment.maxExtendoGripActions.get();
    }

    public static boolean shouldInteraction(class_1657 player, class_1268 hand, class_1799 stack) {
        if (stack.method_31574(AllItems.EXTENDO_GRIP)) {
            return true;
        }
        return player.method_6118(hand == class_1268.field_5808 ? class_1304.field_6171 : class_1304.field_6173).method_31574(AllItems.EXTENDO_GRIP);
    }
}
