package com.zurrtum.create.content.fluids.drain;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.fluids.transfer.GenericItemEmptying;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.fluids.BucketFluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1264;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;

public class ItemDrainBlockEntity extends SmartBlockEntity {

    public static final int FILLING_TIME = 20;

    public SmartFluidTankBehaviour internalTank;
    public TransportedItemStack heldItem;
    public int processingTicks;
    public Map<class_2350, ItemDrainItemHandler> itemHandlers;

    public ItemDrainBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.ITEM_DRAIN, pos, state);
        itemHandlers = new IdentityHashMap<>();
        for (class_2350 d : Iterate.horizontalDirections) {
            itemHandlers.put(d, new ItemDrainItemHandler(this, d));
        }
    }

    @Override
    public void method_66473(class_2338 pos, class_2680 oldState) {
        super.method_66473(pos, oldState);
        class_1799 heldItemStack = getHeldItemStack();
        if (!heldItemStack.method_7960())
            class_1264.method_5449(field_11863, pos.method_10263(), pos.method_10264(), pos.method_10260(), heldItemStack);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        behaviours.add(new DirectBeltInputBehaviour(this).allowingBeltFunnels().setInsertionHandler(this::tryInsertingFromSide));
        behaviours.add(internalTank = SmartFluidTankBehaviour.single(this, (int) (1.5 * BucketFluidInventory.CAPACITY), ItemDrainFluidHandler::new)
            .allowExtraction().forbidInsertion());
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.DRAIN, AllAdvancements.CHAINED_DRAIN);
    }

    private class_1799 tryInsertingFromSide(TransportedItemStack transportedStack, class_2350 side, boolean simulate) {
        class_1799 inserted = transportedStack.stack;
        class_1799 returned = class_1799.field_8037;

        if (!getHeldItemStack().method_7960())
            return inserted;

        if (inserted.method_7947() > 1 && GenericItemEmptying.canItemBeEmptied(field_11863, inserted)) {
            returned = inserted.method_46651(inserted.method_7947() - 1);
            inserted = inserted.method_46651(1);
        }

        if (simulate)
            return returned;

        transportedStack = transportedStack.copy();
        transportedStack.stack = inserted.method_7972();
        transportedStack.beltPosition = side.method_10166().method_10178() ? .5f : 0;
        transportedStack.prevSideOffset = transportedStack.sideOffset;
        transportedStack.prevBeltPosition = transportedStack.beltPosition;
        setHeldItem(transportedStack, side);
        method_5431();
        sendData();

        return returned;
    }

    public class_1799 getHeldItemStack() {
        return heldItem == null ? class_1799.field_8037 : heldItem.stack;
    }

    @Override
    public void tick() {
        super.tick();

        if (heldItem == null) {
            processingTicks = 0;
            return;
        }

        boolean onClient = field_11863.field_9236 && !isVirtual();

        if (processingTicks > 0) {
            heldItem.prevBeltPosition = .5f;
            boolean wasAtBeginning = processingTicks == FILLING_TIME;
            if (!onClient || processingTicks < FILLING_TIME)
                processingTicks--;
            if (!continueProcessing()) {
                processingTicks = 0;
                notifyUpdate();
                return;
            }
            if (wasAtBeginning != (processingTicks == FILLING_TIME))
                sendData();
            return;
        }

        heldItem.prevBeltPosition = heldItem.beltPosition;
        heldItem.prevSideOffset = heldItem.sideOffset;

        heldItem.beltPosition += itemMovementPerTick();
        if (heldItem.beltPosition > 1) {
            heldItem.beltPosition = 1;

            if (onClient)
                return;

            class_2350 side = heldItem.insertedFrom;

            class_1799 tryExportingToBeltFunnel = getBehaviour(DirectBeltInputBehaviour.TYPE).tryExportingToBeltFunnel(
                heldItem.stack,
                side.method_10153(),
                false
            );
            if (tryExportingToBeltFunnel != null) {
                if (tryExportingToBeltFunnel.method_7947() != heldItem.stack.method_7947()) {
                    if (tryExportingToBeltFunnel.method_7960())
                        heldItem = null;
                    else
                        heldItem.stack = tryExportingToBeltFunnel;
                    notifyUpdate();
                    return;
                }
                if (!tryExportingToBeltFunnel.method_7960())
                    return;
            }

            class_2338 nextPosition = field_11867.method_10093(side);
            DirectBeltInputBehaviour directBeltInputBehaviour = BlockEntityBehaviour.get(field_11863, nextPosition, DirectBeltInputBehaviour.TYPE);
            if (directBeltInputBehaviour == null) {
                if (!BlockHelper.hasBlockSolidSide(field_11863.method_8320(nextPosition), field_11863, nextPosition, side.method_10153())) {
                    class_1799 ejected = heldItem.stack;
                    class_243 outPos = VecHelper.getCenterOf(field_11867).method_1019(class_243.method_24954(side.method_62675()).method_1021(.75));
                    float movementSpeed = itemMovementPerTick();
                    class_243 outMotion = class_243.method_24954(side.method_62675()).method_1021(movementSpeed).method_1031(0, 1 / 8f, 0);
                    outPos.method_1019(outMotion.method_1029());
                    class_1542 entity = new class_1542(field_11863, outPos.field_1352, outPos.field_1351 + 6 / 16f, outPos.field_1350, ejected);
                    entity.method_18799(outMotion);
                    entity.method_6988();
                    entity.field_6037 = true;
                    field_11863.method_8649(entity);

                    heldItem = null;
                    notifyUpdate();
                }
                return;
            }

            if (!directBeltInputBehaviour.canInsertFromSide(side))
                return;

            class_1799 returned = directBeltInputBehaviour.handleInsertion(heldItem.copy(), side, false);

            if (returned.method_7960()) {
                if (field_11863.method_8321(nextPosition) instanceof ItemDrainBlockEntity)
                    award(AllAdvancements.CHAINED_DRAIN);
                heldItem = null;
                notifyUpdate();
                return;
            }

            if (returned.method_7947() != heldItem.stack.method_7947()) {
                heldItem.stack = returned;
                notifyUpdate();
                return;
            }

            return;
        }

        if (heldItem.prevBeltPosition < .5f && heldItem.beltPosition >= .5f) {
            if (!GenericItemEmptying.canItemBeEmptied(field_11863, heldItem.stack))
                return;
            heldItem.beltPosition = .5f;
            if (onClient)
                return;
            processingTicks = FILLING_TIME;
            sendData();
        }

    }

    protected boolean continueProcessing() {
        if (field_11863.field_9236 && !isVirtual())
            return true;
        if (processingTicks < 5)
            return true;
        if (!GenericItemEmptying.canItemBeEmptied(field_11863, heldItem.stack))
            return false;

        Pair<FluidStack, class_1799> emptyItem = GenericItemEmptying.emptyItem(field_11863, heldItem.stack, true);
        FluidStack fluidFromItem = emptyItem.getFirst();

        if (processingTicks > 5) {
            internalTank.allowInsertion();
            int amount = fluidFromItem.getAmount();
            if (internalTank.getPrimaryHandler().countSpace(fluidFromItem) != amount) {
                internalTank.forbidInsertion();
                processingTicks = FILLING_TIME;
                return true;
            }
            internalTank.forbidInsertion();
            return true;
        }

        emptyItem = GenericItemEmptying.emptyItem(field_11863, heldItem.stack.method_7972(), false);
        award(AllAdvancements.DRAIN);

        // Process finished
        class_1799 out = emptyItem.getSecond();
        if (!out.method_7960())
            heldItem.stack = out;
        else
            heldItem = null;
        internalTank.allowInsertion();
        internalTank.getPrimaryHandler().insert(fluidFromItem);
        internalTank.forbidInsertion();
        notifyUpdate();
        return true;
    }

    private float itemMovementPerTick() {
        return 1 / 8f;
    }

    public void setHeldItem(TransportedItemStack heldItem, class_2350 insertedFrom) {
        this.heldItem = heldItem;
        this.heldItem.insertedFrom = insertedFrom;
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        view.method_71465("ProcessingTicks", processingTicks);
        if (heldItem != null)
            view.method_71468("HeldItem", TransportedItemStack.CODEC, heldItem);
        super.write(view, clientPacket);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        heldItem = null;
        processingTicks = view.method_71424("ProcessingTicks", 0);
        heldItem = view.method_71426("HeldItem", TransportedItemStack.CODEC).orElse(null);
        super.read(view, clientPacket);
    }

    public static class ItemDrainFluidHandler extends SmartFluidTankBehaviour.InternalFluidHandler {
        private static final int[] EMPTY_SLOTS = new int[0];

        @SuppressWarnings("OptionalUsedAsFieldOrParameterType")
        public ItemDrainFluidHandler(SmartFluidTankBehaviour behaviour, boolean enforceVariety, Optional<Integer> max) {
            super(behaviour, enforceVariety, max);
        }

        @Override
        public int[] getAvailableSlots(@Nullable class_2350 side) {
            if (side == class_2350.field_11036) {
                return EMPTY_SLOTS;
            }
            return super.getAvailableSlots(side);
        }
    }
}
