package com.zurrtum.create.content.fluids.pipes;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.api.contraption.transformable.TransformableBlock;
import com.zurrtum.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.decoration.encasing.EncasedBlock;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.content.fluids.FluidPropagator;
import com.zurrtum.create.content.fluids.FluidTransportBehaviour;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.foundation.advancement.AdvancementBehaviour;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.NeighborUpdateListeningBlock;
import org.jetbrains.annotations.Nullable;

import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_1953;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2429;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2746;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_4209;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_6088;
import net.minecraft.class_9904;

import static net.minecraft.class_2741.*;

public class EncasedPipeBlock extends class_2248 implements IWrenchable, SpecialBlockItemRequirement, IBE<FluidPipeBlockEntity>, EncasedBlock, TransformableBlock, NeighborUpdateListeningBlock {
    public static final Map<class_2350, class_2746> FACING_TO_PROPERTY_MAP = class_2429.field_11329;

    private final class_2248 casing;

    public EncasedPipeBlock(class_2251 properties, class_2248 casing) {
        super(properties);
        this.casing = casing;
        method_9590(method_9564().method_11657(field_12489, false).method_11657(field_12540, false).method_11657(field_12546, false).method_11657(field_12519, false).method_11657(field_12527, false)
            .method_11657(field_12487, false));
    }

    public static EncasedPipeBlock copper(class_2251 properties) {
        return new EncasedPipeBlock(properties, AllBlocks.COPPER_CASING);
    }

    @Override
    protected void method_9515(class_2690<class_2248, class_2680> builder) {
        builder.method_11667(field_12489, field_12487, field_12540, field_12527, field_12519, field_12546);
        super.method_9515(builder);
    }

    @Override
    public void method_9567(class_1937 pLevel, class_2338 pPos, class_2680 pState, class_1309 pPlacer, class_1799 pStack) {
        super.method_9567(pLevel, pPos, pState, pPlacer, pStack);
        AdvancementBehaviour.setPlacedBy(pLevel, pPos, pPlacer);
    }

    @Override
    public void method_66388(class_2680 state, class_3218 world, class_2338 pos, boolean isMoving) {
        if (!world.field_9236)
            FluidPropagator.propagateChangedPipe(world, pos, state);
        if (state.method_31709())
            world.method_8544(pos);
    }

    @Override
    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean isMoving) {
        if (!world.field_9236 && state != oldState)
            world.method_64311(pos, this, 1, class_1953.field_9310);
    }

    @Override
    protected class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state, boolean includeData) {
        return AllItems.FLUID_PIPE.method_7854();
    }

    @Override
    public void neighborUpdate(class_2680 state, class_1937 world, class_2338 pos, class_2248 otherBlock, class_2338 neighborPos, boolean isMoving) {
        class_2350 d = FluidPropagator.validateNeighbourChange(state, world, pos, otherBlock, neighborPos, isMoving);
        if (d == null)
            return;
        if (!state.method_11654(FACING_TO_PROPERTY_MAP.get(d)))
            return;
        world.method_64311(pos, this, 1, class_1953.field_9310);
    }

    @Override
    public void method_9612(
        class_2680 state,
        class_1937 world,
        class_2338 pos,
        class_2248 otherBlock,
        @Nullable class_9904 wireOrientation,
        boolean isMoving
    ) {
        class_4209.method_19472(world, pos);
    }

    @Override
    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 r) {
        FluidPropagator.propagateChangedPipe(world, pos, state);
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();

        if (world.field_9236)
            return class_1269.field_5812;

        context.method_8045().method_20290(class_6088.field_31144, context.method_8037(), class_2248.method_9507(state));
        class_2680 equivalentPipe = transferSixWayProperties(state, AllBlocks.FLUID_PIPE.method_9564());

        class_2350 firstFound = class_2350.field_11036;
        for (class_2350 d : Iterate.directions)
            if (state.method_11654(FACING_TO_PROPERTY_MAP.get(d))) {
                firstFound = d;
                break;
            }

        FluidTransportBehaviour.cacheFlows(world, pos);
        world.method_8501(pos, AllBlocks.FLUID_PIPE.updateBlockState(equivalentPipe, firstFound, null, world, pos));
        FluidTransportBehaviour.loadFlows(world, pos);
        return class_1269.field_5812;
    }

    public static class_2680 transferSixWayProperties(class_2680 from, class_2680 to) {
        for (class_2350 d : Iterate.directions) {
            class_2746 property = FACING_TO_PROPERTY_MAP.get(d);
            to = to.method_11657(property, from.method_11654(property));
        }
        return to;
    }

    @Override
    public ItemRequirement getRequiredItems(class_2680 state, class_2586 be) {
        return ItemRequirement.of(AllBlocks.FLUID_PIPE.method_9564(), be);
    }

    @Override
    public Class<FluidPipeBlockEntity> getBlockEntityClass() {
        return FluidPipeBlockEntity.class;
    }

    @Override
    public class_2591<? extends FluidPipeBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.ENCASED_FLUID_PIPE;
    }

    @Override
    public class_2248 getCasing() {
        return casing;
    }

    @Override
    public void handleEncasing(class_2680 state, class_1937 level, class_2338 pos, class_1799 heldItem, class_1657 player, class_1268 hand, class_3965 ray) {
        FluidTransportBehaviour.cacheFlows(level, pos);
        level.method_8501(pos, EncasedPipeBlock.transferSixWayProperties(state, method_9564()));
        FluidTransportBehaviour.loadFlows(level, pos);
    }

    @Override
    public class_2680 method_9598(class_2680 pState, class_2470 pRotation) {
        return FluidPipeBlockRotation.rotate(pState, pRotation);
    }

    @Override
    public class_2680 method_9569(class_2680 pState, class_2415 pMirror) {
        return FluidPipeBlockRotation.mirror(pState, pMirror);
    }

    @Override
    public class_2680 transform(class_2680 state, StructureTransform transform) {
        return FluidPipeBlockRotation.transform(state, transform);
    }

}
