package com.zurrtum.create.content.kinetics.base;

import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2680;
import net.minecraft.class_4538;

public interface IRotate extends IWrenchable {

    boolean hasShaftTowards(class_4538 world, class_2338 pos, class_2680 state, class_2350 face);

    class_2351 getRotationAxis(class_2680 state);

    default SpeedLevel getMinimumRequiredSpeedLevel() {
        return SpeedLevel.NONE;
    }

    default boolean hideStressImpact() {
        return false;
    }

    default boolean showCapacityWithAnnotation() {
        return false;
    }

    enum SpeedLevel {
        NONE(class_124.field_1063, 0x000000, 0),
        SLOW(class_124.field_1060, 0x22FF22, 10),
        MEDIUM(class_124.field_1075, 0x0084FF, 20),
        FAST(class_124.field_1076, 0xFF55FF, 30);

        private final class_124 textColor;
        private final int color;
        private final int particleSpeed;

        SpeedLevel(class_124 textColor, int color, int particleSpeed) {
            this.textColor = textColor;
            this.color = color;
            this.particleSpeed = particleSpeed;
        }

        public static SpeedLevel of(float speed) {
            speed = Math.abs(speed);

            if (speed >= AllConfigs.server().kinetics.fastSpeed.get())
                return FAST;
            if (speed >= AllConfigs.server().kinetics.mediumSpeed.get())
                return MEDIUM;
            if (speed >= 1)
                return SLOW;
            return NONE;
        }

        public class_124 getTextColor() {
            return textColor;
        }

        public int getColor() {
            return color;
        }

        public int getParticleSpeed() {
            return particleSpeed;
        }

        public float getSpeedValue() {
            return switch (this) {
                case FAST -> AllConfigs.server().kinetics.fastSpeed.get();
                case MEDIUM -> AllConfigs.server().kinetics.mediumSpeed.get();
                case SLOW -> 1;
                default -> 0;
            };
        }

    }

    enum StressImpact {
        LOW(class_124.field_1054, class_124.field_1060),
        MEDIUM(class_124.field_1065, class_124.field_1054),
        HIGH(class_124.field_1061, class_124.field_1065),
        OVERSTRESSED(class_124.field_1061, class_124.field_1061);

        private final class_124 absoluteColor;
        private final class_124 relativeColor;

        StressImpact(class_124 absoluteColor, class_124 relativeColor) {
            this.absoluteColor = absoluteColor;
            this.relativeColor = relativeColor;
        }

        public static StressImpact of(double stressPercent) {
            if (stressPercent > 1)
                return StressImpact.OVERSTRESSED;
            if (stressPercent > .75d)
                return StressImpact.HIGH;
            if (stressPercent > .5d)
                return StressImpact.MEDIUM;
            return StressImpact.LOW;
        }

        public static boolean isEnabled() {
            return !AllConfigs.server().kinetics.disableStress.get();
        }

        public class_124 getAbsoluteColor() {
            return absoluteColor;
        }

        public class_124 getRelativeColor() {
            return relativeColor;
        }
    }

}
