package com.zurrtum.create.content.kinetics.belt;

import com.zurrtum.create.AllShapes;
import com.zurrtum.create.catnip.math.VoxelShaper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;

import static net.minecraft.class_2248.method_9541;

public class BeltShapes {

    /*
     * | hi. i made these comments mostly to help me with creating the shapes. but they should also be able to help you understand what i'm doing here if that's why you came here. cheers
     * |
     * |                 belt shape slope south descending
     * |                    generated by makeSlopePart
     * |         z
     * |  y        15 14 13 12 11 10  9  8  7  6  5  4  3  2  1  0   |               |                                                    |                                                           |
     * |            |                                            |   |               |                                                    |                                                           |
     * | +5         |                                            #   |               |            belt shape flat south ending            |            belt shape flat south full                     |
     * | +4         |                                         #  #   |               |             generated by makeFlatEnding            |             generated by makeFlatFull                     |
     * | +3         |                                      #  #  #   | z             |z                                                   |z                                                          |
     * | +2         |                                   #  #  #  #   |  15  14 ...   |  15 14 13 12 11 10  9  8  7  6  5  4  3  2  1  0   |  15 14 13 12 11 10  9  8  7  6  5  4  3  2  1  0          |
     * | +1         |                                #  #  #  #  #   |   |           |   |                                            |   |   |                                            |          |
     * | 15   ------+  -  -  -  -  -  -  -  -  -  #  #  #  #  #  #-- | --+---------- | --+  -  -  -  -  -  -  -  -  -  -  -  -  -  -  +-- | --+  -  -  -  -  -  -  -  -  -  -  -  -  -  -  +---       |
     * | 14         |                          #  #  #  #  #  #  #   |   |           |   |                                            |   |   |                                            |          |
     * | 13         |                       #  #  #  #  #  #  #  #   |   |           |   |                                            |   |   |                                            |          |
     * | 12         |                    #  #  #  #  #  #  #  #  #   |   |           |   |  #  #  #  #  #  #  #  #  #  #  #  #  #  #  |   |   #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #          |
     * | 11         |                 #  #  #  #  #  #  #  #  #  #   |   |           |   #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #   |   #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #          |
     * | 10         |              #  #  #  #  #  #  #  #  #  #  #   |   #           |   #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #   |   #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #          |
     * | 9          |           #  #  #  #  #  #  #  #  #  #  #  |   |   #           |   #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #   |   #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #          |
     * | 8          |        #  #  #  #  #  #  #  #  #  #  #     |   |   #           |   #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #   |   #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #          |
     * | 7          |     #  #  #  #  #  #  #  #  #  #  #        |   |   #           |   #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #   |   #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #          |
     * | 6          |  #  #  #  #  #  #  #  #  #  #  #           |   |   #           |   #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #   |   #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #          |
     * | 5          #  #  #  #  #  #  #  #  #  #  #              |   |   #           |   #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #   |   #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #          |
     * | 4          #  #  #  #  #  #  #  #  #  #                 |   |   #           |   #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #   |   #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #          |
     * | 3          #  #  #  #  #  #  #  #  #                    |   |   #           |   |  #  #  #  #  #  #  #  #  #  #  #  #  #  #  |   |   #  #  #  #  #  #  #  #  #  #  #  #  #  #  #  #          |
     * | 2          #  #  #  #  #  #  #  #                       |   |   #           |   |                                            |   |   |                                            |          |
     * | 1          #  #  #  #  #  #  #                          |   |   #           |   |                                            |   |   |                                            |          |
     * | 0   -------#  #  #  #  #  #  -  -  -  -  -  -  -  -  -  +-- | --#---------- | --+  -  -  -  -  -  -  -  -  -  -  -  -  -  -  +-- | --+  -  -  -  -  -  -  -  -  -  -  -  -  -  -  +---       |
     * |-1          #  #  #  #  #                                |   |   |           |   |                                            |   |   |                                            |          |
     * |-2          #  #  #  #                                   |   |   |           |   |                                            |   |   |                                            |          |
     * |-3          #  #  #                                          |  slice used   |                                                    |                                                           |
     * |-4          #  #                                             |  to create    |                                                    |                                                           |
     * |-5          #                                                |  the stairs   |                                                    |                                                           |
     * |                                  x 1 to 14                  |               |                                                    |                                                           |
     */

    /*
     * |Belt shapes always consist of 2 halves depending on state. This class generated all shapes for belts facing SOUTH and then uses VoxelShapers to fill the remaining 3 Directions
     * |Middle shapes use the same building part in both halved and don't need to be composed
     * |some of these shapes could be skipped and easily achieved by rotating other shapes but i left them in for clarity's sake
     * | Flat Belts:                                    Sloped Belts: (DESC)                           (ASC)
     * |                south half    north half                         south half    north half         south half    north half
     * |
     * |      Middle     flat full     flat full               Middle    slope desc    slope desc          slope asc     slope asc
     * |         End      flat end     flat full                  End     flat end     slope desc           flat end     slope asc
     * |       Start     flat full      flat end                Start    slope desc     flat end           slope asc      flat end
     */

    //Building parts for the shapes
    private static final class_265 SLOPE_DESC_PART = makeSlopePart(false), SLOPE_ASC_PART = makeSlopePart(true), SIDEWAYS_FULL_PART = makeSidewaysFull(), SIDEWAYS_END_PART = makeSidewaysEnding(), FLAT_FULL_PART = makeFlatFull(), FLAT_END_PART = makeFlatEnding();

    private static final class_265 SOUTH_MASK = method_9541(0, -5, 8, 16, 16 + 5, 16);
    private static final class_265 NORTH_MASK = method_9541(0, -5, 0, 16, 16 + 5, 8);

    //Vertical Shapes
    private static final VoxelShaper VERTICAL_FULL = VerticalBeltShaper.make(FLAT_FULL_PART), VERTICAL_END = VerticalBeltShaper.make(compose(
        FLAT_END_PART,
        FLAT_FULL_PART
    )), VERTICAL_START = VerticalBeltShaper.make(compose(FLAT_FULL_PART, FLAT_END_PART));

    //Flat Shapes
    private static final VoxelShaper FLAT_FULL = VoxelShaper.forHorizontalAxis(FLAT_FULL_PART, class_2351.field_11051), FLAT_END = VoxelShaper.forHorizontal(
        compose(
            FLAT_END_PART,
            FLAT_FULL_PART
        ), class_2350.field_11035
    ), FLAT_START = VoxelShaper.forHorizontal(compose(FLAT_FULL_PART, FLAT_END_PART), class_2350.field_11035);

    //Sideways Shapes
    private static final VoxelShaper SIDE_FULL = VoxelShaper.forHorizontalAxis(SIDEWAYS_FULL_PART, class_2351.field_11051), SIDE_END = VoxelShaper.forHorizontal(
        compose(SIDEWAYS_END_PART, SIDEWAYS_FULL_PART),
        class_2350.field_11035
    ), SIDE_START = VoxelShaper.forHorizontal(compose(SIDEWAYS_FULL_PART, SIDEWAYS_END_PART), class_2350.field_11035);

    //Sloped Shapes
    private static final VoxelShaper SLOPE_DESC = VoxelShaper.forHorizontal(SLOPE_DESC_PART, class_2350.field_11035), SLOPE_ASC = VoxelShaper.forHorizontal(
        SLOPE_ASC_PART,
        class_2350.field_11035
    ), SLOPE_DESC_END = VoxelShaper.forHorizontal(
        compose(FLAT_END_PART, SLOPE_DESC_PART),
        class_2350.field_11035
    ), SLOPE_DESC_START = VoxelShaper.forHorizontal(
        compose(SLOPE_DESC_PART, FLAT_END_PART),
        class_2350.field_11035
    ), SLOPE_ASC_END = VoxelShaper.forHorizontal(
        compose(FLAT_END_PART, SLOPE_ASC_PART),
        class_2350.field_11035
    ), SLOPE_ASC_START = VoxelShaper.forHorizontal(compose(SLOPE_ASC_PART, FLAT_END_PART), class_2350.field_11035);

    private static final VoxelShaper PARTIAL_CASING = VoxelShaper.forHorizontal(method_9541(0, 0, 5, 16, 11, 16), class_2350.field_11035);

    static Map<class_2680, class_265> cache = new HashMap<>();
    static Map<class_2680, class_265> collisionCache = new HashMap<>();

    private static class_265 compose(class_265 southPart, class_265 northPart) {
        return class_259.method_1084(
            class_259.method_1082(SOUTH_MASK, southPart, class_247.field_16896),
            class_259.method_1082(NORTH_MASK, northPart, class_247.field_16896)
        );
    }

    private static class_265 makeSlopePart(boolean ascendingInstead) {
        class_265 slice = method_9541(1, 0, 15, 15, 11, 16);
        class_265 result = class_259.method_1073();

        for (int i = 0; i < 16; i++) {

            int yOffset = ascendingInstead ? 10 - i : i - 5;

            result = class_259.method_1084(
                result,//move slice i voxels "right" and i-5 voxels "down"
                slice.method_1096(0, yOffset / 16f, -i / 16f)
            );
        }

        return result;
    }

    private static class_265 makeFlatEnding() {
        return class_259.method_1084(method_9541(1, 4, 0, 15, 12, 16), method_9541(1, 3, 1, 15, 13, 15));
    }

    private static class_265 makeFlatFull() {
        return method_9541(1, 3, 0, 15, 13, 16);
    }

    private static class_265 makeSidewaysEnding() {
        return class_259.method_1084(method_9541(4, 1, 0, 12, 15, 16), method_9541(3, 1, 1, 13, 15, 15));
    }

    private static class_265 makeSidewaysFull() {
        return method_9541(3, 1, 0, 13, 15, 16);
    }

    public static class_265 getShape(class_2680 state) {
        if (cache.containsKey(state))
            return cache.get(state);
        class_265 createdShape = class_259.method_1084(getBeltShape(state), getCasingShape(state));
        cache.put(state, createdShape);
        return createdShape;
    }

    public static class_265 getCollisionShape(class_2680 state) {
        if (collisionCache.containsKey(state))
            return collisionCache.get(state);
        class_265 createdShape = class_259.method_1082(AllShapes.BELT_COLLISION_MASK, getShape(state), class_247.field_16896);
        collisionCache.put(state, createdShape);
        return createdShape;
    }

    private static class_265 getBeltShape(class_2680 state) {
        class_2350 facing = state.method_11654(BeltBlock.HORIZONTAL_FACING);
        class_2351 axis = facing.method_10166();
        BeltPart part = state.method_11654(BeltBlock.PART);
        BeltSlope slope = state.method_11654(BeltBlock.SLOPE);

        //vertical
        if (slope == BeltSlope.VERTICAL) {
            if (part == BeltPart.MIDDLE || part == BeltPart.PULLEY)
                return VERTICAL_FULL.get(axis);
            //vertical ending
            return (part == BeltPart.START ? VERTICAL_START : VERTICAL_END).get(facing);
        }

        //flat part
        if (slope == BeltSlope.HORIZONTAL) {
            if (part == BeltPart.MIDDLE || part == BeltPart.PULLEY)
                return FLAT_FULL.get(axis);
            //flat ending
            return (part == BeltPart.START ? FLAT_START : FLAT_END).get(facing);
        }

        //sideways part
        if (slope == BeltSlope.SIDEWAYS) {
            if (part == BeltPart.MIDDLE || part == BeltPart.PULLEY)
                return SIDE_FULL.get(axis);
            //flat ending
            return (part == BeltPart.START ? SIDE_START : SIDE_END).get(facing);
        }

        //slope
        if (part == BeltPart.MIDDLE || part == BeltPart.PULLEY)
            return (slope == BeltSlope.DOWNWARD ? SLOPE_DESC : SLOPE_ASC).get(facing);
        //sloped ending
        if (part == BeltPart.START)
            return (slope == BeltSlope.DOWNWARD ? SLOPE_DESC_START : SLOPE_ASC_START).get(facing);
        if (part == BeltPart.END)
            return (slope == BeltSlope.DOWNWARD ? SLOPE_DESC_END : SLOPE_ASC_END).get(facing);

        //bad state
        return class_259.method_1073();
    }

    private static class_265 getCasingShape(class_2680 state) {
        if (!state.method_11654(BeltBlock.CASING))
            return class_259.method_1073();

        class_2350 facing = state.method_11654(BeltBlock.HORIZONTAL_FACING);
        BeltPart part = state.method_11654(BeltBlock.PART);
        BeltSlope slope = state.method_11654(BeltBlock.SLOPE);

        if (slope == BeltSlope.VERTICAL)
            return class_259.method_1073();
        if (slope == BeltSlope.SIDEWAYS)
            return class_259.method_1073();

        if (slope == BeltSlope.HORIZONTAL) {
            return AllShapes.CASING_11PX.get(class_2350.field_11036);
        }

        if (part == BeltPart.MIDDLE || part == BeltPart.PULLEY)
            return PARTIAL_CASING.get(slope == BeltSlope.UPWARD ? facing : facing.method_10153());

        if (part == BeltPart.START)
            return slope == BeltSlope.UPWARD ? AllShapes.CASING_11PX.get(class_2350.field_11036) : PARTIAL_CASING.get(facing.method_10153());
        if (part == BeltPart.END)
            return slope == BeltSlope.DOWNWARD ? AllShapes.CASING_11PX.get(class_2350.field_11036) : PARTIAL_CASING.get(facing);

        //something went wrong
        return class_259.method_1077();
    }

    private static class VerticalBeltShaper extends VoxelShaper {

        public static VoxelShaper make(class_265 southBeltShape) {
            return forDirectionsWithRotation(
                rotatedCopy(southBeltShape, new class_243(-90, 0, 0)), class_2350.field_11035, class_2350.class_2353.field_11062,//idk, this can probably be improved :S
                direction -> new class_243(
                    direction.method_10171() == class_2350.class_2352.field_11056 ? 0 : 180,
                    -direction.method_10144(),
                    0
                )
            );
        }
    }

}
