package com.zurrtum.create.content.kinetics.belt.transport;

import com.zurrtum.create.content.kinetics.belt.BeltHelper;
import com.zurrtum.create.content.logistics.funnel.BeltFunnelBlock;
import com.zurrtum.create.content.logistics.funnel.BeltFunnelBlock.Shape;
import com.zurrtum.create.content.logistics.funnel.FunnelBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.zurrtum.create.foundation.item.ItemHelper.ExtractionCountMode;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public class BeltFunnelInteractionHandler {

    public static boolean checkForFunnels(BeltInventory beltInventory, TransportedItemStack currentItem, float nextOffset) {
        boolean beltMovementPositive = beltInventory.beltMovementPositive;
        int firstUpcomingSegment = (int) Math.floor(currentItem.beltPosition);
        int step = beltMovementPositive ? 1 : -1;
        firstUpcomingSegment = class_3532.method_15340(firstUpcomingSegment, 0, beltInventory.belt.beltLength - 1);

        for (int segment = firstUpcomingSegment; beltMovementPositive ? segment <= nextOffset : segment + 1 >= nextOffset; segment += step) {
            class_2338 funnelPos = BeltHelper.getPositionForOffset(beltInventory.belt, segment).method_10084();
            class_1937 world = beltInventory.belt.method_10997();
            class_2680 funnelState = world.method_8320(funnelPos);
            if (!(funnelState.method_26204() instanceof BeltFunnelBlock))
                continue;
            class_2350 funnelFacing = funnelState.method_11654(BeltFunnelBlock.HORIZONTAL_FACING);
            class_2350 movementFacing = beltInventory.belt.getMovementFacing();
            boolean blocking = funnelFacing == movementFacing.method_10153();
            if (funnelFacing == movementFacing)
                continue;
            if (funnelState.method_11654(BeltFunnelBlock.SHAPE) == Shape.PUSHING)
                continue;

            float funnelEntry = segment + .5f;
            if (funnelState.method_11654(BeltFunnelBlock.SHAPE) == Shape.EXTENDED)
                funnelEntry += .499f * (beltMovementPositive ? -1 : 1);
            boolean hasCrossed = nextOffset > funnelEntry && beltMovementPositive || nextOffset < funnelEntry && !beltMovementPositive;
            if (!hasCrossed)
                return false;
            if (blocking)
                currentItem.beltPosition = funnelEntry;

            if (world.field_9236 || funnelState.method_61767(BeltFunnelBlock.POWERED, false))
                if (blocking)
                    return true;
                else
                    continue;

            class_2586 be = world.method_8321(funnelPos);
            if (!(be instanceof FunnelBlockEntity funnelBE))
                return true;

            InvManipulationBehaviour inserting = funnelBE.getBehaviour(InvManipulationBehaviour.TYPE);
            ServerFilteringBehaviour filtering = funnelBE.getBehaviour(ServerFilteringBehaviour.TYPE);

            if (inserting == null || filtering != null && !filtering.test(currentItem.stack))
                if (blocking)
                    return true;
                else
                    continue;

            if (beltInventory.belt.invVersionTracker.stillWaiting(inserting))
                continue;

            int amountToExtract = funnelBE.getAmountToExtract();
            ExtractionCountMode modeToExtract = funnelBE.getModeToExtract();

            class_1799 toInsert = currentItem.stack.method_7972();
            if (amountToExtract > toInsert.method_7947() && modeToExtract != ExtractionCountMode.UPTO)
                if (blocking)
                    return true;
                else
                    continue;

            if (amountToExtract != -1 && modeToExtract != ExtractionCountMode.UPTO) {
                toInsert.method_7939(Math.min(amountToExtract, toInsert.method_7947()));
                class_1799 remainder = inserting.simulate().insert(toInsert);
                if (!remainder.method_7960())
                    if (blocking)
                        return true;
                    else
                        continue;
                else
                    beltInventory.belt.invVersionTracker.awaitNewVersion(inserting);
            }

            class_1799 remainder = inserting.insert(toInsert);
            if (class_1799.method_7973(toInsert, remainder)) {
                beltInventory.belt.invVersionTracker.awaitNewVersion(inserting);
                if (blocking)
                    return true;
                else
                    continue;
            }

            int notFilled = currentItem.stack.method_7947() - toInsert.method_7947();
            if (!remainder.method_7960()) {
                remainder.method_7933(notFilled);
            } else if (notFilled > 0)
                remainder = currentItem.stack.method_46651(notFilled);

            funnelBE.flap(true);
            funnelBE.onTransfer(toInsert);
            currentItem.stack = remainder;
            beltInventory.belt.notifyUpdate();
            if (blocking)
                return true;
        }

        return false;
    }

}
