package com.zurrtum.create.content.kinetics.crafter;

import com.zurrtum.create.*;
import com.zurrtum.create.api.contraption.transformable.TransformableBlockEntity;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.BlockFace;
import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.kinetics.crafter.ConnectedInputHandler.ConnectedInput;
import com.zurrtum.create.content.kinetics.crafter.RecipeGridHandler.GroupedItems;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.edgeInteraction.EdgeInteractionBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2392;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;

import static com.zurrtum.create.content.kinetics.base.HorizontalKineticBlock.HORIZONTAL_FACING;

public class MechanicalCrafterBlockEntity extends KineticBlockEntity implements TransformableBlockEntity {

    public enum Phase {
        IDLE,
        ACCEPTING,
        ASSEMBLING,
        EXPORTING,
        WAITING,
        CRAFTING,
        INSERTING;
    }

    public class CrafterItemHandler implements class_1278 {
        @SuppressWarnings("OptionalUsedAsFieldOrParameterType")
        public static final Optional<Integer> LIMIT = Optional.of(1);
        private static final int[] SLOTS = {0};
        private class_1799 stack = class_1799.field_8037;

        @Override
        public int[] method_5494(class_2350 side) {
            return SLOTS;
        }

        @Override
        public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
            return phase == Phase.IDLE && !covered;
        }

        @Override
        public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
            return false;
        }

        @Override
        public class_1799 onExtract(class_1799 stack) {
            return removeMaxSize(stack, LIMIT);
        }

        @Override
        public int method_5444() {
            return 1;
        }

        @Override
        public int method_5439() {
            return 1;
        }

        @Override
        public class_1799 method_5438(int slot) {
            if (slot != 0) {
                return class_1799.field_8037;
            }
            return stack;
        }

        @Override
        public void method_5447(int slot, class_1799 stack) {
            if (slot == 0) {
                setStack(stack);
            }
        }

        @Override
        public void method_5431() {
            notifyUpdate();
            if (stack.method_7960())
                return;
            if (phase == Phase.IDLE)
                checkCompletedRecipe(false);
        }

        public class_1799 getStack() {
            return stack;
        }

        public void setStack(class_1799 stack) {
            if (!stack.method_7960()) {
                method_10997().method_8396(null, method_11016(), class_3417.field_14667, class_3419.field_15245, .25f, .5f);
            }
            if (stack != class_1799.field_8037) {
                setMaxSize(stack, LIMIT);
            }
            this.stack = stack;
        }

        public void write(class_11372 view) {
            view.method_71468("Stack", class_1799.field_49266, stack);
        }

        public void read(class_11368 view) {
            stack = view.method_71426("Stack", class_1799.field_49266).orElse(class_1799.field_8037);
        }
    }

    protected CrafterItemHandler inventory;
    public GroupedItems groupedItems = new GroupedItems();
    protected ConnectedInput input = new ConnectedInput();
    @Nullable
    protected class_1263 invCap;
    protected boolean reRender;
    public Phase phase;
    public int countDown;
    public boolean covered;
    protected boolean wasPoweredBefore;

    public GroupedItems groupedItemsBeforeCraft; // for rendering on client
    private InvManipulationBehaviour inserting;

    private class_1799 scriptedResult = class_1799.field_8037;

    public MechanicalCrafterBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.MECHANICAL_CRAFTER, pos, state);
        setLazyTickRate(20);
        phase = Phase.IDLE;
        groupedItemsBeforeCraft = new GroupedItems();
        inventory = new CrafterItemHandler();

        // Does not get serialized due to active checking in tick
        wasPoweredBefore = true;
    }

    public class_1263 getInvCapability() {
        if (invCap == null) {
            invCap = input.getItemHandler(method_10997(), method_11016());
        }
        return invCap;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        super.addBehaviours(behaviours);
        inserting = new InvManipulationBehaviour(this, this::getTargetFace);
        behaviours.add(inserting);
        //noinspection deprecation
        behaviours.add(new EdgeInteractionBehaviour(this, ConnectedInputHandler::toggleConnection).connectivity(ConnectedInputHandler::shouldConnect)
            .require(item -> item.method_40131().method_40220(AllItemTags.TOOLS_WRENCH)));
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.CRAFTER, AllAdvancements.CRAFTER_LAZY);
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        if (!class_3532.method_15347(getSpeed(), 0)) {
            award(AllAdvancements.CRAFTER);
            if (Math.abs(getSpeed()) < 5)
                award(AllAdvancements.CRAFTER_LAZY);
        }
    }

    public void blockChanged() {
        removeBehaviour(InvManipulationBehaviour.TYPE);
        inserting = new InvManipulationBehaviour(this, this::getTargetFace);
        attachBehaviourLate(inserting);
    }

    public BlockFace getTargetFace(class_1937 world, class_2338 pos, class_2680 state) {
        return new BlockFace(pos, MechanicalCrafterBlock.getTargetDirection(state));
    }

    public class_2350 getTargetDirection() {
        return MechanicalCrafterBlock.getTargetDirection(method_11010());
    }

    @Override
    public void writeSafe(class_11372 view) {
        super.writeSafe(view);
        if (input == null)
            return;

        input.write(view.method_71461("ConnectedInput"));
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        inventory.write(view);
        input.write(view.method_71461("ConnectedInput"));
        if (groupedItemsBeforeCraft != null) {
            view.method_71468("GroupedItemsBeforeCraft", GroupedItems.CODEC, groupedItemsBeforeCraft);
            groupedItemsBeforeCraft = null;
        }
        view.method_71468("GroupedItems", GroupedItems.CODEC, groupedItems);
        view.method_71469("Phase", phase.name());
        view.method_71465("CountDown", countDown);
        view.method_71472("Cover", covered);

        super.write(view, clientPacket);

        if (clientPacket && reRender) {
            view.method_71472("Redraw", true);
            reRender = false;
        }
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        Phase phaseBefore = phase;
        GroupedItems before = this.groupedItems;

        inventory.read(view);
        input.read(view.method_71434("ConnectedInput"));
        groupedItems = view.method_71426("GroupedItems", GroupedItems.CODEC).orElseThrow();
        phase = Phase.IDLE;
        String name = view.method_71428("Phase", "");
        for (Phase phase : Phase.values())
            if (phase.name().equals(name))
                this.phase = phase;
        countDown = view.method_71424("CountDown", 0);
        covered = view.method_71433("Cover", false);
        super.read(view, clientPacket);
        if (!clientPacket)
            return;
        if (view.method_71433("Redraw", false))
            field_11863.method_8413(method_11016(), method_11010(), method_11010(), 16);
        if (phaseBefore != phase && phase == Phase.CRAFTING) {
            groupedItemsBeforeCraft = view.method_71426("GroupedItemsBeforeCraft", GroupedItems.CODEC).orElse(before);
        }
        if (phaseBefore == Phase.EXPORTING && phase == Phase.WAITING) {
            if (before.onlyEmptyItems())
                return;
            class_2350 facing = method_11010().method_11654(MechanicalCrafterBlock.HORIZONTAL_FACING);
            class_243 vec = class_243.method_24954(facing.method_62675()).method_1021(.75).method_1019(VecHelper.getCenterOf(field_11867));
            class_2350 targetDirection = MechanicalCrafterBlock.getTargetDirection(method_11010());
            vec = vec.method_1019(class_243.method_24954(targetDirection.method_62675()).method_1021(1));
            field_11863.method_8406(class_2398.field_11205, vec.field_1352, vec.field_1351, vec.field_1350, 0, 0, 0);
        }
    }

    public int getCountDownSpeed() {
        if (getSpeed() == 0)
            return 0;
        return class_3532.method_15340((int) Math.abs(getSpeed()), 4, 250);
    }

    @Override
    public void tick() {
        super.tick();

        if (phase == Phase.ACCEPTING)
            return;

        boolean onClient = field_11863.field_9236;
        boolean runLogic = !onClient || isVirtual();

        if (wasPoweredBefore != field_11863.method_49803(field_11867)) {
            wasPoweredBefore = field_11863.method_49803(field_11867);
            if (wasPoweredBefore) {
                if (!runLogic)
                    return;
                checkCompletedRecipe(true);
            }
        }

        if (phase == Phase.ASSEMBLING) {
            countDown -= getCountDownSpeed();
            if (countDown < 0) {
                countDown = 0;
                if (!runLogic)
                    return;
                if (RecipeGridHandler.getTargetingCrafter(this) != null) {
                    phase = Phase.EXPORTING;
                    countDown = groupedItems.onlyEmptyItems() ? 0 : 1000;
                    sendData();
                    return;
                }

                class_1799 result = isVirtual() ? scriptedResult : RecipeGridHandler.tryToApplyRecipe((class_3218) field_11863, groupedItems);

                if (result != null) {
                    List<class_1799> containers = new ArrayList<>();
                    groupedItems.grid.values().forEach(stack -> {
                        class_1799 remainder = stack.method_7909().method_7858();
                        if (!remainder.method_7960())
                            containers.add(remainder);
                    });

                    groupedItemsBeforeCraft = groupedItems;

                    groupedItems = new GroupedItems(result);
                    for (int i = 0; i < containers.size(); i++) {
                        class_1799 stack = containers.get(i);
                        GroupedItems container = new GroupedItems();
                        container.grid.put(Pair.of(i, 0), stack);
                        container.mergeOnto(groupedItems, Pointing.LEFT);
                    }

                    phase = Phase.CRAFTING;
                    countDown = 2000;
                    sendData();
                    return;
                }
                ejectWholeGrid();
                return;
            }
        }

        if (phase == Phase.EXPORTING) {
            countDown -= getCountDownSpeed();

            if (countDown < 0) {
                countDown = 0;
                if (!runLogic)
                    return;

                MechanicalCrafterBlockEntity targetingCrafter = RecipeGridHandler.getTargetingCrafter(this);
                if (targetingCrafter == null) {
                    ejectWholeGrid();
                    return;
                }

                boolean empty = groupedItems.onlyEmptyItems();
                Pointing pointing = method_11010().method_11654(MechanicalCrafterBlock.POINTING);
                groupedItems.mergeOnto(targetingCrafter.groupedItems, pointing);
                groupedItems = new GroupedItems();

                float pitch = targetingCrafter.groupedItems.grid.size() * 1 / 16f + .5f;

                if (!empty)
                    AllSoundEvents.CRAFTER_CLICK.playOnServer(field_11863, field_11867, 1, pitch);

                phase = Phase.WAITING;
                countDown = 0;
                sendData();
                targetingCrafter.continueIfAllPrecedingFinished();
                targetingCrafter.sendData();
                return;
            }
        }

        if (phase == Phase.CRAFTING) {

            if (onClient) {
                class_2350 facing = method_11010().method_11654(MechanicalCrafterBlock.HORIZONTAL_FACING);
                float progress = countDown / 2000f;
                class_243 facingVec = class_243.method_24954(facing.method_62675());
                class_243 vec = facingVec.method_1021(.65).method_1019(VecHelper.getCenterOf(field_11867));
                class_243 offset = VecHelper.offsetRandomly(class_243.field_1353, field_11863.field_9229, .125f).method_18806(VecHelper.axisAlingedPlaneOf(facingVec)).method_1029()
                    .method_1021(progress * .5f).method_1019(vec);
                if (progress > .5f)
                    field_11863.method_8406(class_2398.field_11205, offset.field_1352, offset.field_1351, offset.field_1350, 0, 0, 0);

                if (!groupedItemsBeforeCraft.grid.isEmpty() && progress < .5f) {
                    if (groupedItems.grid.containsKey(Pair.of(0, 0))) {
                        class_1799 stack = groupedItems.grid.get(Pair.of(0, 0));
                        groupedItemsBeforeCraft = new GroupedItems();

                        for (int i = 0; i < 10; i++) {
                            class_243 randVec = VecHelper.offsetRandomly(class_243.field_1353, field_11863.field_9229, .125f)
                                .method_18806(VecHelper.axisAlingedPlaneOf(facingVec)).method_1029().method_1021(.25f);
                            class_243 offset2 = randVec.method_1019(vec);
                            randVec = randVec.method_1021(.35f);
                            field_11863.method_8406(
                                new class_2392(class_2398.field_11218, stack),
                                offset2.field_1352,
                                offset2.field_1351,
                                offset2.field_1350,
                                randVec.field_1352,
                                randVec.field_1351,
                                randVec.field_1350
                            );
                        }
                    }
                }
            }

            int prev = countDown;
            countDown -= getCountDownSpeed();

            if (countDown < 1000 && prev >= 1000) {
                AllSoundEvents.CRAFTER_CLICK.playOnServer(field_11863, field_11867, 1, 2);
                AllSoundEvents.CRAFTER_CRAFT.playOnServer(field_11863, field_11867);
            }

            if (countDown < 0) {
                countDown = 0;
                if (!runLogic)
                    return;
                tryInsert();
                return;
            }
        }

        if (phase == Phase.INSERTING) {
            if (runLogic && isTargetingBelt())
                tryInsert();
        }
    }

    protected boolean isTargetingBelt() {
        DirectBeltInputBehaviour behaviour = getTargetingBelt();
        return behaviour != null && behaviour.canInsertFromSide(getTargetDirection());
    }

    protected DirectBeltInputBehaviour getTargetingBelt() {
        class_2338 targetPos = field_11867.method_10093(getTargetDirection());
        return BlockEntityBehaviour.get(field_11863, targetPos, DirectBeltInputBehaviour.TYPE);
    }

    public void tryInsert() {
        if (!inserting.hasInventory() && !isTargetingBelt()) {
            ejectWholeGrid();
            return;
        }

        boolean chagedPhase = phase != Phase.INSERTING;
        final List<Pair<Integer, Integer>> inserted = new LinkedList<>();

        DirectBeltInputBehaviour behaviour = getTargetingBelt();
        for (Map.Entry<Pair<Integer, Integer>, class_1799> entry : groupedItems.grid.entrySet()) {
            Pair<Integer, Integer> pair = entry.getKey();
            class_1799 stack = entry.getValue();
            BlockFace face = getTargetFace(field_11863, field_11867, method_11010());

            class_1799 remainder = behaviour == null ? inserting.insert(stack.method_7972()) : behaviour.handleInsertion(stack, face.getFace(), false);
            if (!remainder.method_7960()) {
                stack.method_7939(remainder.method_7947());
                continue;
            }

            inserted.add(pair);
        }

        inserted.forEach(groupedItems.grid::remove);
        if (groupedItems.grid.isEmpty())
            ejectWholeGrid();
        else
            phase = Phase.INSERTING;
        if (!inserted.isEmpty() || chagedPhase)
            sendData();
    }

    public void ejectWholeGrid() {
        List<MechanicalCrafterBlockEntity> chain = RecipeGridHandler.getAllCraftersOfChain(this);
        if (chain == null)
            return;
        chain.forEach(MechanicalCrafterBlockEntity::eject);
    }

    public void eject() {
        class_2680 blockState = method_11010();
        boolean present = blockState.method_27852(AllBlocks.MECHANICAL_CRAFTER);
        class_243 vec = present ? class_243.method_24954(blockState.method_11654(HORIZONTAL_FACING).method_62675()).method_1021(.75f) : class_243.field_1353;
        class_243 ejectPos = VecHelper.getCenterOf(field_11867).method_1019(vec);
        groupedItems.grid.forEach((pair, stack) -> dropItem(ejectPos, stack));
        if (!inventory.getStack().method_7960())
            dropItem(ejectPos, inventory.onExtract(inventory.getStack()));
        phase = Phase.IDLE;
        groupedItems = new GroupedItems();
        inventory.setStack(class_1799.field_8037);
        sendData();
    }

    public void dropItem(class_243 ejectPos, class_1799 stack) {
        class_1542 itemEntity = new class_1542(field_11863, ejectPos.field_1352, ejectPos.field_1351, ejectPos.field_1350, stack);
        itemEntity.method_6988();
        field_11863.method_8649(itemEntity);
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (field_11863.field_9236 && !isVirtual())
            return;
        if (phase == Phase.IDLE && craftingItemPresent())
            checkCompletedRecipe(false);
        if (phase == Phase.INSERTING)
            tryInsert();
    }

    public boolean craftingItemPresent() {
        return !inventory.getStack().method_7960();
    }

    public boolean craftingItemOrCoverPresent() {
        return !inventory.getStack().method_7960() || covered;
    }

    public void checkCompletedRecipe(boolean poweredStart) {
        if (getSpeed() == 0)
            return;
        if (field_11863.field_9236 && !isVirtual())
            return;
        List<MechanicalCrafterBlockEntity> chain = RecipeGridHandler.getAllCraftersOfChainIf(
            this,
            poweredStart ? MechanicalCrafterBlockEntity::craftingItemPresent : MechanicalCrafterBlockEntity::craftingItemOrCoverPresent,
            poweredStart
        );
        if (chain == null)
            return;
        chain.forEach(MechanicalCrafterBlockEntity::begin);
    }

    protected void begin() {
        phase = Phase.ACCEPTING;
        groupedItems = new GroupedItems(inventory.onExtract(inventory.getStack()));
        inventory.setStack(class_1799.field_8037);
        if (RecipeGridHandler.getPrecedingCrafters(this).isEmpty()) {
            phase = Phase.ASSEMBLING;
            countDown = 1;
        }
        sendData();
    }

    protected void continueIfAllPrecedingFinished() {
        List<MechanicalCrafterBlockEntity> preceding = RecipeGridHandler.getPrecedingCrafters(this);
        //        if (preceding == null) {
        //            ejectWholeGrid();
        //            return;
        //        }

        for (MechanicalCrafterBlockEntity blockEntity : preceding)
            if (blockEntity.phase != Phase.WAITING)
                return;

        phase = Phase.ASSEMBLING;
        countDown = 1;
    }

    public void connectivityChanged() {
        reRender = true;
        sendData();
        invCap = null;
    }

    public CrafterItemHandler getInventory() {
        return inventory;
    }

    public void setScriptedResult(class_1799 scriptedResult) {
        this.scriptedResult = scriptedResult;
    }

    public ConnectedInput getInput() {
        return input;
    }

    @Override
    public void transform(class_2586 be, StructureTransform transform) {
        input.data.replaceAll(transform::applyWithoutOffset);
        notifyUpdate();
    }
}
