package com.zurrtum.create.content.kinetics.crusher;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllDamageSources;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.processing.recipe.ProcessingInventory;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1264;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_238;
import net.minecraft.class_2388;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_4844;
import net.minecraft.class_5819;
import net.minecraft.class_8786;
import net.minecraft.class_9696;
import net.minecraft.util.math.*;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

public class CrushingWheelControllerBlockEntity extends SmartBlockEntity {

    public class_1297 processingEntity;
    public UUID entityUUID;
    protected boolean searchForEntity;

    public ProcessingInventory inventory;
    public float crushingspeed;

    public CrushingWheelControllerBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.CRUSHING_WHEEL_CONTROLLER, pos, state);
        inventory = new ProcessingInventory(this::itemInserted, d -> processingEntity == null);
    }

    @Override
    public void method_66473(class_2338 pos, class_2680 oldState) {
        super.method_66473(pos, oldState);
        class_1264.method_5451(field_11863, pos, inventory);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        behaviours.add(new DirectBeltInputBehaviour(this).onlyInsertWhen(this::supportsDirectBeltInput));
    }

    private boolean supportsDirectBeltInput(class_2350 side) {
        class_2680 blockState = method_11010();
        if (blockState == null)
            return false;
        class_2350 direction = blockState.method_11654(CrushingWheelControllerBlock.field_10927);
        return direction == class_2350.field_11033 || direction == side;
    }

    @Override
    public void tick() {
        super.tick();
        if (searchForEntity) {
            searchForEntity = false;
            List<class_1297> search = field_11863.method_8333(null, new class_238(method_11016()), e -> entityUUID.equals(e.method_5667()));
            if (search.isEmpty())
                clear();
            else
                processingEntity = search.getFirst();
        }

        if (!isOccupied())
            return;
        if (crushingspeed == 0)
            return;

        float speed = crushingspeed * 4;

        class_243 centerPos = VecHelper.getCenterOf(field_11867);
        class_2350 facing = method_11010().method_11654(CrushingWheelControllerBlock.field_10927);
        int offset = facing.method_10171().method_10181();
        class_243 outSpeed = new class_243(
            (facing.method_10166() == class_2351.field_11048 ? 0.25D : 0.0D) * offset, offset == 1 ? (facing.method_10166() == class_2351.field_11052 ? 0.5D : 0.0D) : 0.0D
            // Increased upwards speed so upwards
            // crushing wheels shoot out the item
            // properly.
            , (facing.method_10166() == class_2351.field_11051 ? 0.25D : 0.0D) * offset
        ); // No downwards speed, so downwards crushing wheels
        // drop the items as before.
        class_243 outPos = centerPos.method_1031(
            (facing.method_10166() == class_2351.field_11048 ? .55f * offset : 0f),
            (facing.method_10166() == class_2351.field_11052 ? .55f * offset : 0f),
            (facing.method_10166() == class_2351.field_11051 ? .55f * offset : 0f)
        );

        if (!hasEntity()) {

            float processingSpeed = class_3532.method_15363(
                (speed) / (!inventory.appliedRecipe ? (float) Math.log(inventory.method_5438(0)
                    .method_7947()) / (float) Math.log(2) : 1), .25f, 20
            );
            inventory.remainingTime -= processingSpeed;
            spawnParticles(inventory.method_5438(0));

            if (field_11863.field_9236)
                return;

            if (inventory.remainingTime < 20 && !inventory.appliedRecipe) {
                applyRecipe();
                inventory.appliedRecipe = true;
                field_11863.method_8413(field_11867, method_11010(), method_11010(), 2 | 16);
                return;
            }

            if (inventory.remainingTime > 0) {
                return;
            }
            inventory.remainingTime = 0;

            // Output Items
            if (facing != class_2350.field_11036) {
                class_2338 nextPos = field_11867.method_10074().method_10079(facing, facing.method_10166() == class_2351.field_11052 ? 0 : 1);

                DirectBeltInputBehaviour behaviour = BlockEntityBehaviour.get(field_11863, nextPos, DirectBeltInputBehaviour.TYPE);
                if (behaviour != null) {
                    boolean changed = false;
                    if (!behaviour.canInsertFromSide(facing))
                        return;
                    for (int slot = 0, size = inventory.method_5439(); slot < size; slot++) {
                        class_1799 stack = inventory.method_5438(slot);
                        if (stack.method_7960())
                            continue;
                        class_1799 remainder = behaviour.handleInsertion(stack, facing, false);
                        if (class_1799.method_7973(remainder, stack))
                            continue;
                        inventory.method_5447(slot, remainder);
                        changed = true;
                    }
                    if (changed) {
                        method_5431();
                        sendData();
                    }
                    return;
                }
            }

            // Eject Items
            for (int slot = 0, size = inventory.method_5439(); slot < size; slot++) {
                class_1799 stack = inventory.method_5438(slot);
                if (stack.method_7960())
                    continue;
                class_1542 entityIn = new class_1542(field_11863, outPos.field_1352, outPos.field_1351, outPos.field_1350, stack);
                entityIn.method_18799(outSpeed);
                AllSynchedDatas.BYPASS_CRUSHING_WHEEL.set(entityIn, Optional.of(field_11867));
                field_11863.method_8649(entityIn);
            }
            inventory.method_5448();
            field_11863.method_8413(field_11867, method_11010(), method_11010(), 2 | 16);

            return;
        }

        if (!processingEntity.method_5805() || !processingEntity.method_5829().method_994(new class_238(field_11867).method_1014(.5f))) {
            clear();
            return;
        }

        double xMotion = ((field_11867.method_10263() + .5f) - processingEntity.method_23317()) / 2f;
        double zMotion = ((field_11867.method_10260() + .5f) - processingEntity.method_23321()) / 2f;
        if (processingEntity.method_5715())
            xMotion = zMotion = 0;
        double movement = Math.max(-speed / 4f, -.5f) * -offset;
        processingEntity.method_18799(new class_243(
            facing.method_10166() == class_2351.field_11048 ? movement : xMotion, facing.method_10166() == class_2351.field_11052 ? movement : 0f // Do
            // not
            // move
            // entities
            // upwards
            // or
            // downwards
            // for
            // horizontal
            // crushers,
            , facing.method_10166() == class_2351.field_11051 ? movement : zMotion
        )); // Or they'll only get their feet crushed.

        if (field_11863.field_9236)
            return;

        if (!(processingEntity instanceof class_1542 itemEntity)) {
            class_243 entityOutPos = outPos.method_1031(
                facing.method_10166() == class_2351.field_11048 ? .5f * offset : 0f,
                facing.method_10166() == class_2351.field_11052 ? .5f * offset : 0f,
                facing.method_10166() == class_2351.field_11051 ? .5f * offset : 0f
            );
            int crusherDamage = AllConfigs.server().kinetics.crushingDamage.get();

            if (processingEntity instanceof class_1309) {
                if ((((class_1309) processingEntity).method_6032() - crusherDamage <= 0) // Takes LivingEntity instances
                    // as exception, so it can
                    // move them before it would
                    // kill them.
                    && (((class_1309) processingEntity).field_6235 <= 0)) { // This way it can actually output the items
                    // to the right spot.
                    processingEntity.method_23327(entityOutPos.field_1352, entityOutPos.field_1351, entityOutPos.field_1350);
                }
            }
            processingEntity.method_64397((class_3218) field_11863, AllDamageSources.get(field_11863).crush, crusherDamage);
            if (!processingEntity.method_5805()) {
                processingEntity.method_23327(entityOutPos.field_1352, entityOutPos.field_1351, entityOutPos.field_1350);
            }
            return;
        }

        itemEntity.method_6982(20);
        if (facing.method_10166() == class_2351.field_11052) {
            if (processingEntity.method_23318() * -offset < (centerPos.field_1351 - .25f) * -offset) {
                intakeItem(itemEntity);
            }
        } else if (facing.method_10166() == class_2351.field_11051) {
            if (processingEntity.method_23321() * -offset < (centerPos.field_1350 - .25f) * -offset) {
                intakeItem(itemEntity);
            }
        } else {
            if (processingEntity.method_23317() * -offset < (centerPos.field_1352 - .25f) * -offset) {
                intakeItem(itemEntity);
            }
        }
    }

    private void intakeItem(class_1542 itemEntity) {
        inventory.method_5448();
        inventory.method_5447(0, itemEntity.method_6983().method_7972());
        itemInserted(inventory.method_5438(0));
        itemEntity.method_31472();
        field_11863.method_8413(field_11867, method_11010(), method_11010(), 2 | 16);
    }

    protected void spawnParticles(class_1799 stack) {
        if (stack == null || stack.method_7960())
            return;

        class_2394 particleData;
        if (stack.method_7909() instanceof class_1747)
            particleData = new class_2388(class_2398.field_11217, ((class_1747) stack.method_7909()).method_7711().method_9564());
        else
            particleData = new class_2392(class_2398.field_11218, stack);

        class_5819 r = field_11863.field_9229;
        int x = field_11867.method_10263();
        int y = field_11867.method_10264();
        int z = field_11867.method_10260();
        for (int i = 0; i < 4; i++) {
            field_11863.method_8406(particleData, x + r.method_43057(), y + r.method_43057(), z + r.method_43057(), 0, 0, 0);
        }
    }

    private void applyRecipe() {
        AbstractCrushingRecipe recipe = findRecipe();

        List<class_1799> list = new ArrayList<>();
        if (recipe != null) {
            class_1799 item = inventory.method_5438(0);
            class_9696 input = new class_9696(item);
            int rolls = item.method_7947();
            inventory.method_5448();
            for (int roll = 0; roll < rolls; roll++) {
                List<class_1799> rolledResults = recipe.craft(input, field_11863.field_9229);
                for (class_1799 stack : rolledResults) {
                    ItemHelper.addToList(stack, list);
                }
            }
            for (int slot = 0, max = Math.min(list.size(), inventory.method_5439() - 1); slot < max; slot++)
                inventory.method_5447(slot + 1, list.get(slot));
        } else {
            inventory.method_5448();
        }

    }

    public AbstractCrushingRecipe findRecipe() {
        class_1863 recipeManager = ((class_3218) field_11863).method_64577();
        class_9696 input = new class_9696(inventory.method_5438(0));
        AbstractCrushingRecipe crushingRecipe = recipeManager.method_8132(AllRecipeTypes.CRUSHING, input, field_11863).map(class_8786::comp_1933)
            .orElse(null);
        if (crushingRecipe == null)
            crushingRecipe = recipeManager.method_8132(AllRecipeTypes.MILLING, input, field_11863).map(class_8786::comp_1933).orElse(null);
        return crushingRecipe;
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        if (hasEntity())
            view.method_71468("Entity", class_4844.field_25122, entityUUID);
        inventory.write(view);
        view.method_71464("Speed", crushingspeed);
        super.write(view, clientPacket);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        view.method_71426("Entity", class_4844.field_25122).ifPresent(uuid -> {
            if (!isOccupied()) {
                entityUUID = uuid;
                searchForEntity = true;
            }
        });
        crushingspeed = view.method_71423("Speed", 0);
        inventory.read(view);
    }

    public void startCrushing(class_1297 entity) {
        processingEntity = entity;
        entityUUID = entity.method_5667();
    }

    private void itemInserted(class_1799 stack) {
        AbstractCrushingRecipe recipe = findRecipe();
        inventory.remainingTime = recipe != null ? recipe.time() : 100;
        inventory.appliedRecipe = false;
    }

    public void clear() {
        processingEntity = null;
        entityUUID = null;
    }

    public boolean isOccupied() {
        return hasEntity() || !inventory.method_5442();
    }

    public boolean hasEntity() {
        return processingEntity != null;
    }

}
