package com.zurrtum.create.content.kinetics.drill;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.content.kinetics.base.BlockBreakingKineticBlockEntity;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.kinetics.drill.CobbleGenOptimisation.CobbleGenBlockConfiguration;
import com.zurrtum.create.content.logistics.chute.ChuteBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2614;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_6088;

public class DrillBlockEntity extends BlockBreakingKineticBlockEntity {

    private CobbleGenBlockConfiguration currentConfig;
    private class_2680 currentOutput;

    public DrillBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.DRILL, pos, state);
        currentOutput = class_2246.field_10124.method_9564();
    }

    @Override
    protected class_2338 getBreakingPos() {
        return method_11016().method_10093(method_11010().method_11654(DrillBlock.FACING));
    }

    @Override
    public void onBlockBroken(class_2680 stateToBreak) {
        if (!optimiseCobbleGen(stateToBreak))
            super.onBlockBroken(stateToBreak);
    }

    public boolean optimiseCobbleGen(class_2680 stateToBreak) {
        DirectBeltInputBehaviour inv = BlockEntityBehaviour.get(field_11863, breakingPos.method_10074(), DirectBeltInputBehaviour.TYPE);
        class_2586 blockEntityBelow = field_11863.method_8321(breakingPos.method_10074());
        class_2586 blockEntityAbove = field_11863.method_8321(breakingPos.method_10084());

        if (inv == null && !(blockEntityBelow instanceof class_2614) && !(blockEntityAbove instanceof ChuteBlockEntity chute && chute.getItemMotion() > 0))
            return false;

        CobbleGenBlockConfiguration config = CobbleGenOptimisation.getConfig(field_11863, field_11867, method_11010().method_11654(DrillBlock.FACING));
        if (config == null)
            return false;
        if (!(field_11863 instanceof class_3218 sl))
            return false;

        class_2338 breakingPos = getBreakingPos();
        if (!config.equals(currentConfig)) {
            currentConfig = config;
            currentOutput = CobbleGenOptimisation.determineOutput(sl, breakingPos, config);
        }

        if (currentOutput.method_26215() || !currentOutput.equals(stateToBreak))
            return false;

        if (inv != null)
            for (class_1799 stack : class_2248.method_9562(stateToBreak, sl, breakingPos, null))
                inv.handleInsertion(stack, class_2350.field_11036, false);
        else if (blockEntityBelow instanceof class_2614 hbe) {
            for (class_1799 stack : class_2248.method_9562(stateToBreak, sl, breakingPos, null))
                hbe.insertExist(stack);
        } else if (blockEntityAbove instanceof ChuteBlockEntity chute && chute.getItemMotion() > 0) {
            for (class_1799 stack : class_2248.method_9562(stateToBreak, sl, breakingPos, null))
                if (chute.getItem().method_7960())
                    chute.setItem(stack, 0);
        }

        field_11863.method_20290(class_6088.field_31144, breakingPos, class_2248.method_9507(stateToBreak));
        return true;
    }

}