package com.zurrtum.create.content.kinetics.press;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.content.kinetics.press.PressingBehaviour.Mode;
import com.zurrtum.create.content.kinetics.press.PressingBehaviour.PressingBehaviourSpecifics;
import com.zurrtum.create.content.processing.basin.BasinBlockEntity;
import com.zurrtum.create.content.processing.basin.BasinInventory;
import com.zurrtum.create.content.processing.basin.BasinOperatingBlockEntity;
import com.zurrtum.create.foundation.advancement.AdvancementBehaviour;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.foundation.recipe.RecipeApplier;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3955;
import net.minecraft.class_8786;
import net.minecraft.class_9696;
import net.minecraft.recipe.*;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class MechanicalPressBlockEntity extends BasinOperatingBlockEntity implements PressingBehaviourSpecifics {

    private static final Object compressingRecipesKey = new Object();

    public PressingBehaviour pressingBehaviour;
    private int tracksCreated;

    public MechanicalPressBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.MECHANICAL_PRESS, pos, state);
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return new class_238(field_11867).method_1012(0, -1.5, 0).method_1012(0, 1, 0);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        super.addBehaviours(behaviours);
        pressingBehaviour = new PressingBehaviour(this);
        behaviours.add(pressingBehaviour);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.PRESS, AllAdvancements.COMPACTING, AllAdvancements.TRACK_CRAFTING);
    }

    public void onItemPressed(class_1799 result) {
        award(AllAdvancements.PRESS);
        if (result.method_31573(AllItemTags.TRACKS))
            tracksCreated += result.method_7947();
        if (tracksCreated >= 1000) {
            award(AllAdvancements.TRACK_CRAFTING);
            tracksCreated = 0;
        }
    }

    public PressingBehaviour getPressingBehaviour() {
        return pressingBehaviour;
    }

    @Override
    public boolean tryProcessInBasin(boolean simulate) {
        applyBasinRecipe();

        Optional<BasinBlockEntity> basin = getBasin();
        if (basin.isPresent()) {
            BasinInventory inputs = basin.get().itemCapability;
            for (int slot = 0; slot < 9; slot++) {
                class_1799 stackInSlot = inputs.method_5438(slot);
                if (stackInSlot.method_7960())
                    continue;
                pressingBehaviour.particleItems.add(stackInSlot);
            }
        }

        return true;
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        super.write(view, clientPacket);
        AdvancementBehaviour behaviour = getBehaviour(AdvancementBehaviour.TYPE);
        if (behaviour != null && behaviour.isOwnerPresent())
            view.method_71465("TracksCreated", tracksCreated);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        tracksCreated = view.method_71424("TracksCreated", 0);
    }

    @Override
    public boolean tryProcessInWorld(class_1542 itemEntity, boolean simulate) {
        class_1799 item = itemEntity.method_6983();
        class_9696 input = new class_9696(item);
        Optional<class_8786<PressingRecipe>> recipe = getRecipe(input);
        if (recipe.isEmpty())
            return false;
        if (simulate)
            return true;

        class_1799 itemCreated = class_1799.field_8037;
        pressingBehaviour.particleItems.add(item);
        if (canProcessInBulk() || item.method_7947() == 1) {
            RecipeApplier.applyCreateRecipeOn(itemEntity, input, recipe.get().comp_1933());
            itemCreated = itemEntity.method_6983().method_7972();
        } else {
            for (class_1799 result : RecipeApplier.applyCreateRecipeOn(field_11863, 1, input, recipe.get().comp_1933())) {
                if (itemCreated.method_7960())
                    itemCreated = result.method_7972();
                class_1542 created = new class_1542(field_11863, itemEntity.method_23317(), itemEntity.method_23318(), itemEntity.method_23321(), result);
                created.method_6988();
                created.method_18799(VecHelper.offsetRandomly(class_243.field_1353, field_11863.field_9229, .05f));
                field_11863.method_8649(created);
            }
            item.method_7934(1);
        }

        if (!itemCreated.method_7960())
            onItemPressed(itemCreated);
        return true;
    }

    @Override
    public boolean tryProcessOnBelt(TransportedItemStack input, List<class_1799> outputList, boolean simulate) {
        class_9696 recipeInput = new class_9696(input.stack);
        Optional<class_8786<PressingRecipe>> recipe = getRecipe(recipeInput);
        if (recipe.isEmpty())
            return false;
        if (simulate)
            return true;
        pressingBehaviour.particleItems.add(input.stack);
        List<class_1799> outputs = RecipeApplier.applyCreateRecipeOn(
            field_11863,
            canProcessInBulk() ? input.stack.method_7947() : 1,
            recipeInput,
            recipe.get().comp_1933()
        );

        for (class_1799 created : outputs) {
            if (!created.method_7960()) {
                onItemPressed(created);
                break;
            }
        }

        outputList.addAll(outputs);
        return true;
    }

    @Override
    public void onPressingCompleted() {
        if (pressingBehaviour.onBasin() && matchBasinRecipe(currentRecipe) && getBasin().filter(BasinBlockEntity::canContinueProcessing).isPresent())
            startProcessingBasin();
        else
            basinChecker.scheduleUpdate();
    }

    public Optional<class_8786<PressingRecipe>> getRecipe(class_9696 input) {
        return ((class_3218) field_11863).method_64577().method_8132(AllRecipeTypes.PRESSING, input, field_11863);
    }

    public static boolean canCompress(class_1860<?> recipe) {
        if (recipe instanceof class_1869 shapedRecipe) {
            return canCompress(shapedRecipe);
        } else if (recipe instanceof class_1867 shapelessRecipe) {
            return canCompress(shapelessRecipe);
        } else {
            return false;
        }
    }

    public static boolean canCompress(class_1869 recipe) {
        List<class_1856> ingredients = new ArrayList<>();
        for (Optional<class_1856> ingredient : recipe.method_61693()) {
            if (ingredient.isPresent()) {
                ingredients.add(ingredient.get());
            } else {
                return false;
            }
        }
        int size = ingredients.size();
        if (size != 4 && size != 9) {
            return false;
        }
        return ItemHelper.matchAllIngredients(ingredients);
    }

    public static boolean canCompress(class_1867 recipe) {
        int size = recipe.field_9047.size();
        if (size != 4 && size != 9) {
            return false;
        }
        return ItemHelper.matchAllIngredients(recipe.field_9047);
    }

    @Override
    protected boolean matchStaticFilters(class_8786<? extends class_1860<?>> recipe) {
        class_1860<?> value = recipe.comp_1933();
        return value instanceof class_3955 && canCompress(value) && !AllRecipeTypes.shouldIgnoreInAutomation(recipe) || value.method_17716() == AllRecipeTypes.COMPACTING;
    }

    @Override
    public float getKineticSpeed() {
        return getSpeed();
    }

    @Override
    public boolean canProcessInBulk() {
        return AllConfigs.server().recipes.bulkPressing.get();
    }

    @Override
    protected Object getRecipeCacheKey() {
        return compressingRecipesKey;
    }

    @Override
    public int getParticleAmount() {
        return 15;
    }

    @Override
    public void startProcessingBasin() {
        if (pressingBehaviour.running && pressingBehaviour.runningTicks <= PressingBehaviour.CYCLE / 2)
            return;
        super.startProcessingBasin();
        pressingBehaviour.start(Mode.BASIN);
    }

    @Override
    protected void onBasinRemoved() {
        pressingBehaviour.particleItems.clear();
        pressingBehaviour.running = false;
        pressingBehaviour.runningTicks = 0;
        sendData();
    }

    @Override
    protected boolean isRunning() {
        return pressingBehaviour.running;
    }

    @Override
    protected Optional<CreateTrigger> getProcessedRecipeTrigger() {
        return Optional.of(AllAdvancements.COMPACTING);
    }

}
