package com.zurrtum.create.content.kinetics.saw;

import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.base.BlockBreakingKineticBlockEntity;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.processing.recipe.ProcessingInventory;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.foundation.recipe.RecipeFinder;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import net.minecraft.block.*;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1264;
import net.minecraft.class_1542;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_2211;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2266;
import net.minecraft.class_2283;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2388;
import net.minecraft.class_2391;
import net.minecraft.class_2392;
import net.minecraft.class_2393;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2523;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_8786;
import net.minecraft.class_9288;
import net.minecraft.class_9696;
import net.minecraft.util.math.*;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public class SawBlockEntity extends BlockBreakingKineticBlockEntity {
    private static final Object cuttingRecipesKey = new Object();

    public ProcessingInventory inventory;
    private int recipeIndex;
    private ServerFilteringBehaviour filtering;

    public class_1799 playEvent;

    public SawBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.SAW, pos, state);
        inventory = new ProcessingInventory(
            this::start,
            direction -> direction != class_2350.field_11033
        ).withSlotLimit(!AllConfigs.server().recipes.bulkCutting.get());
        inventory.remainingTime = -1;
        recipeIndex = 0;
        playEvent = class_1799.field_8037;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        super.addBehaviours(behaviours);
        filtering = new ServerFilteringBehaviour(this).forRecipes();
        behaviours.add(filtering);
        behaviours.add(new DirectBeltInputBehaviour(this).allowingBeltFunnelsWhen(this::canProcess));
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.SAW_PROCESSING);
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        inventory.write(view);
        view.method_71465("RecipeIndex", recipeIndex);
        super.write(view, clientPacket);

        if (!clientPacket || playEvent.method_7960())
            return;
        view.method_71468("PlayEvent", class_1799.field_24671, playEvent);
        playEvent = class_1799.field_8037;
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        inventory.read(view);
        recipeIndex = view.method_71424("RecipeIndex", 0);
        playEvent = view.method_71426("PlayEvent", class_1799.field_24671).orElse(class_1799.field_8037);
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return new class_238(method_11016()).method_1014(.125f);
    }

    @Override
    public void tick() {
        if (shouldRun() && ticksUntilNextProgress < 0)
            destroyNextTick();
        super.tick();

        if (!canProcess())
            return;
        if (getSpeed() == 0)
            return;
        if (inventory.remainingTime == -1) {
            if (!inventory.method_5442() && !inventory.appliedRecipe)
                start(inventory.method_5438(0));
            return;
        }

        float processingSpeed = class_3532.method_15363(Math.abs(getSpeed()) / 24, 1, 128);
        inventory.remainingTime -= processingSpeed;

        if (inventory.remainingTime > 0)
            spawnParticles(inventory.method_5438(0));

        if (inventory.remainingTime < 5 && !inventory.appliedRecipe) {
            if (field_11863.field_9236)
                return;
            playEvent = inventory.method_5438(0);
            applyRecipe();
            inventory.appliedRecipe = true;
            inventory.recipeDuration = 20;
            inventory.remainingTime = 20;
            sendData();
            return;
        }

        if (inventory.remainingTime > 0)
            return;
        inventory.remainingTime = 0;
        class_243 itemMovement = getItemMovementVec();
        class_2350 itemMovementFacing = class_2350.method_10142(itemMovement.field_1352, itemMovement.field_1351, itemMovement.field_1350);

        for (int slot = 0, size = inventory.method_5439(); slot < size; slot++) {
            class_1799 stack = inventory.method_5438(slot);
            if (stack.method_7960())
                continue;
            class_1799 tryExportingToBeltFunnel = getBehaviour(DirectBeltInputBehaviour.TYPE).tryExportingToBeltFunnel(
                inventory.onExtract(stack.method_7972()),
                itemMovementFacing.method_10153(),
                false
            );
            if (tryExportingToBeltFunnel != null) {
                int count = tryExportingToBeltFunnel.method_7947();
                if (count != stack.method_7947()) {
                    if (count == 0) {
                        inventory.method_5447(slot, class_1799.field_8037);
                    } else {
                        stack.method_7939(count);
                    }
                    notifyUpdate();
                    return;
                }
                if (!tryExportingToBeltFunnel.method_7960())
                    return;
            }
        }

        class_2338 nextPos = field_11867.method_10081(class_2338.method_49638(itemMovement));
        DirectBeltInputBehaviour behaviour = BlockEntityBehaviour.get(field_11863, nextPos, DirectBeltInputBehaviour.TYPE);
        if (behaviour != null) {
            boolean changed = false;
            if (!behaviour.canInsertFromSide(itemMovementFacing))
                return;
            if (field_11863.field_9236)
                return;
            for (int slot = 0, size = inventory.method_5439(); slot < size; slot++) {
                class_1799 stack = inventory.method_5438(slot);
                if (stack.method_7960())
                    continue;
                class_1799 remainder = behaviour.handleInsertion(inventory.onExtract(stack.method_7972()), itemMovementFacing, false);
                int count = remainder.method_7947();
                if (count == stack.method_7947())
                    continue;
                if (count == 0) {
                    inventory.method_5447(slot, class_1799.field_8037);
                } else {
                    stack.method_7939(count);
                }
                changed = true;
            }
            if (changed) {
                method_5431();
                sendData();
            }
            return;
        }

        // Eject Items
        class_243 outPos = VecHelper.getCenterOf(field_11867).method_1019(itemMovement.method_1021(.5f).method_1031(0, .5, 0));
        class_243 outMotion = itemMovement.method_1021(.0625).method_1031(0, .125, 0);
        for (int slot = 0, size = inventory.method_5439(); slot < size; slot++) {
            class_1799 stack = inventory.method_5438(slot);
            if (stack.method_7960())
                continue;
            class_1542 entityIn = new class_1542(field_11863, outPos.field_1352, outPos.field_1351, outPos.field_1350, inventory.onExtract(stack));
            entityIn.method_18799(outMotion);
            field_11863.method_8649(entityIn);
        }
        inventory.method_5448();
        field_11863.method_8455(field_11867, method_11010().method_26204());
        inventory.remainingTime = -1;
        sendData();
    }

    @Override
    public void destroy() {
        super.destroy();
        class_1264.method_5451(field_11863, field_11867, inventory);
    }

    public void spawnEventParticles(class_1799 stack) {
        if (stack == null || stack.method_7960())
            return;

        class_2394 particleData = null;
        if (stack.method_7909() instanceof class_1747)
            particleData = new class_2388(class_2398.field_11217, ((class_1747) stack.method_7909()).method_7711().method_9564());
        else
            particleData = new class_2392(class_2398.field_11218, stack);

        class_5819 r = field_11863.field_9229;
        class_243 v = VecHelper.getCenterOf(field_11867).method_1031(0, 5 / 16f, 0);
        for (int i = 0; i < 10; i++) {
            class_243 m = VecHelper.offsetRandomly(new class_243(0, 0.25f, 0), r, .125f);
            field_11863.method_8406(particleData, v.field_1352, v.field_1351, v.field_1350, m.field_1352, m.field_1351, m.field_1351);
        }
    }

    protected void spawnParticles(class_1799 stack) {
        if (stack == null || stack.method_7960())
            return;

        class_2394 particleData = null;
        float speed = 1;
        if (stack.method_7909() instanceof class_1747)
            particleData = new class_2388(class_2398.field_11217, ((class_1747) stack.method_7909()).method_7711().method_9564());
        else {
            particleData = new class_2392(class_2398.field_11218, stack);
            speed = .125f;
        }

        class_5819 r = field_11863.field_9229;
        class_243 vec = getItemMovementVec();
        class_243 pos = VecHelper.getCenterOf(this.field_11867);
        float offset = inventory.recipeDuration != 0 ? inventory.remainingTime / inventory.recipeDuration : 0;
        offset /= 2;
        if (inventory.appliedRecipe)
            offset -= .5f;
        field_11863.method_8406(
            particleData,
            pos.method_10216() + -vec.field_1352 * offset,
            pos.method_10214() + .45f,
            pos.method_10215() + -vec.field_1350 * offset,
            -vec.field_1352 * speed,
            r.method_43057() * speed,
            -vec.field_1350 * speed
        );
    }

    public class_243 getItemMovementVec() {
        boolean alongX = !method_11010().method_11654(SawBlock.AXIS_ALONG_FIRST_COORDINATE);
        int offset = getSpeed() < 0 ? -1 : 1;
        return new class_243(offset * (alongX ? 1 : 0), 0, offset * (alongX ? 0 : -1));
    }

    private void applyRecipe() {
        class_1799 stack = inventory.method_5438(0);
        if (PackageItem.isPackage(stack)) {
            inventory.method_5448();
            inventory.outputAllowInsertion();
            class_9288 contents = stack.method_58695(AllDataComponents.PACKAGE_CONTENTS, class_9288.field_49334);
            inventory.insert(contents.method_57489().toList());
            inventory.outputForbidInsertion();
            return;
        }

        class_9696 input = new class_9696(stack);
        Pair<class_1860<class_9696>, class_1799> pair = updateRecipe(input, false);
        if (pair == null)
            return;

        inventory.remainingTime = 0;
        inventory.recipeDuration = 0;
        inventory.appliedRecipe = false;
        inventory.method_5447(0, class_1799.field_8037);
        class_1799 output = pair.getSecond();
        if (output == null) {
            output = pair.getFirst().method_8116(input, field_11863.method_30349());
        }
        List<class_1799> list = ItemHelper.multipliedOutput(output, stack.method_7947());
        for (int slot = 1, listSize = list.size(), invSize = inventory.method_5439(); slot < invSize; slot++) {
            inventory.method_5447(slot, slot <= listSize ? list.get(slot - 1) : class_1799.field_8037);
        }
        award(AllAdvancements.SAW_PROCESSING);
    }

    private static boolean matchCuttingRecipe(class_8786<? extends class_1860<?>> entry) {
        return entry.comp_1933().method_17716() == AllRecipeTypes.CUTTING && !AllRecipeTypes.shouldIgnoreInAutomation(entry);
    }

    private static boolean matchAllRecipe(class_8786<? extends class_1860<?>> entry) {
        class_3956<? extends class_1860<?>> type = entry.comp_1933().method_17716();
        return (type == AllRecipeTypes.CUTTING || type == class_3956.field_17641) && !AllRecipeTypes.shouldIgnoreInAutomation(entry);
    }

    @Nullable
    @SuppressWarnings("unchecked")
    private Pair<class_1860<class_9696>, class_1799> updateRecipe(class_9696 input, boolean plus) {
        List<class_8786<?>> startedSearch = RecipeFinder.get(
            cuttingRecipesKey,
            (class_3218) field_11863,
            AllConfigs.server().recipes.allowStonecuttingOnSaw.get() ? SawBlockEntity::matchAllRecipe : SawBlockEntity::matchCuttingRecipe
        );
        int index = 0;

        class_1860<class_9696> first = null;
        if (filtering.getFilter().method_7960()) {
            for (class_8786<?> entry : startedSearch) {
                class_1860<class_9696> recipe = (class_1860<class_9696>) entry.comp_1933();
                if (recipe.method_8115(input, field_11863)) {
                    if (first == null) {
                        first = recipe;
                    }
                    if (index == recipeIndex) {
                        if (plus) {
                            recipeIndex++;
                        }
                        return Pair.of(recipe, null);
                    }
                    index++;
                }
            }
        } else {
            class_5455 registryManager = field_11863.method_30349();
            for (class_8786<? extends class_1860<?>> entry : startedSearch) {
                class_1860<class_9696> recipe = (class_1860<class_9696>) entry.comp_1933();
                if (recipe.method_8115(input, field_11863)) {
                    class_1799 output = recipe.method_8116(input, registryManager);
                    if (filtering.test(output)) {
                        return Pair.of(recipe, output);
                    }
                }
            }
        }
        recipeIndex = 0;
        return first == null ? null : Pair.of(first, null);
    }

    public void insertItem(class_1542 entity) {
        if (!canProcess())
            return;
        if (!inventory.method_5442())
            return;
        if (!entity.method_5805())
            return;
        if (field_11863.field_9236)
            return;

        inventory.method_5448();

        class_1799 stack = entity.method_6983();
        int count = stack.method_7947();
        int insert = inventory.insert(stack);
        if (insert == count)
            entity.method_31472();
        else if (insert != 0) {
            stack.method_7934(insert);
            entity.method_6979(stack);
        }
    }

    public void start(class_1799 inserted) {
        if (!canProcess())
            return;
        if (inventory.method_5442())
            return;
        if (field_11863.field_9236)
            return;

        class_9696 input = new class_9696(inventory.method_5438(0));
        Pair<class_1860<class_9696>, class_1799> pair = updateRecipe(input, true);
        int time = 50;

        if (pair == null) {
            inventory.remainingTime = inventory.recipeDuration = 10;
            inventory.appliedRecipe = false;
            sendData();
            return;
        }

        if (pair.getFirst() instanceof CuttingRecipe cuttingRecipe) {
            time = cuttingRecipe.time();
        }

        inventory.remainingTime = time * Math.max(1, (inserted.method_7947() / 5));
        inventory.recipeDuration = inventory.remainingTime;
        inventory.appliedRecipe = false;
        sendData();
    }

    protected boolean canProcess() {
        return method_11010().method_11654(SawBlock.FACING) == class_2350.field_11036;
    }

    // Block Breaker

    @Override
    protected boolean shouldRun() {
        return method_11010().method_11654(SawBlock.FACING).method_10166().method_10179();
    }

    @Override
    protected class_2338 getBreakingPos() {
        return method_11016().method_10093(method_11010().method_11654(SawBlock.FACING));
    }

    @Override
    public void onBlockBroken(class_2680 stateToBreak) {
        //        Optional<AbstractBlockBreakQueue> dynamicTree = TreeCutter.findDynamicTree(stateToBreak.getBlock(), breakingPos);
        //        if (dynamicTree.isPresent()) {
        //            dynamicTree.get().destroyBlocks(world, null, this::dropItemFromCutTree);
        //            return;
        //        }

        super.onBlockBroken(stateToBreak);
        TreeCutter.findTree(field_11863, breakingPos, stateToBreak).destroyBlocks(field_11863, null, this::dropItemFromCutTree);
    }

    public void dropItemFromCutTree(class_2338 pos, class_1799 stack) {
        float distance = (float) Math.sqrt(pos.method_10262(breakingPos));
        class_243 dropPos = VecHelper.getCenterOf(pos);
        class_1542 entity = new class_1542(field_11863, dropPos.field_1352, dropPos.field_1351, dropPos.field_1350, stack);
        entity.method_18799(class_243.method_24954(breakingPos.method_10059(pos)).method_1021(distance / 20f));
        field_11863.method_8649(entity);
    }

    @Override
    public boolean canBreak(class_2680 stateToBreak, float blockHardness) {
        boolean sawable = isSawable(stateToBreak);
        return super.canBreak(stateToBreak, blockHardness) && sawable;
    }

    public static boolean isSawable(class_2680 stateToBreak) {
        if (stateToBreak.method_26164(class_3481.field_15462))
            return false;
        if (TreeCutter.isLog(stateToBreak) || (stateToBreak.method_26164(class_3481.field_15503)))
            return true;
        if (TreeCutter.isRoot(stateToBreak))
            return true;
        class_2248 block = stateToBreak.method_26204();
        if (block instanceof class_2211)
            return true;
        if (block.equals(class_2246.field_46282) || block.equals(class_2246.field_46283))
            return true;
        if (block instanceof class_2266)
            return true;
        if (block instanceof class_2523)
            return true;
        if (block instanceof class_2391)
            return true;
        if (block instanceof class_2393)
            return true;
        if (block instanceof class_2283)
            return true;
        //TODO
        //        if (TreeCutter.canDynamicTreeCutFrom(block))
        //            return true;
        return false;
    }

}
