package com.zurrtum.create.content.logistics.filter;

import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.zurrtum.create.foundation.gui.menu.MenuBase;
import com.zurrtum.create.foundation.gui.menu.MenuProvider;
import com.zurrtum.create.foundation.item.ItemHelper;
import com.zurrtum.create.foundation.recipe.ItemCopyingRecipe.SupportsItemCopying;
import com.zurrtum.create.infrastructure.component.AttributeFilterWhitelistMode;
import com.zurrtum.create.infrastructure.component.ItemAttributeEntry;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5244;
import net.minecraft.class_9129;
import net.minecraft.class_9331;
import net.minecraft.class_9336;

public class FilterItem extends class_1792 implements MenuProvider, SupportsItemCopying {

    private final FilterType type;

    private enum FilterType {
        REGULAR,
        ATTRIBUTE,
        PACKAGE;
    }

    public static FilterItem regular(class_1793 properties) {
        return new FilterItem(FilterType.REGULAR, properties);
    }

    public static FilterItem attribute(class_1793 properties) {
        return new FilterItem(FilterType.ATTRIBUTE, properties);
    }

    public static FilterItem address(class_1793 properties) {
        return new FilterItem(FilterType.PACKAGE, properties);
    }

    private FilterItem(FilterType type, class_1793 properties) {
        super(properties);
        this.type = type;
    }

    @NotNull
    @Override
    public class_1269 method_7884(class_1838 context) {
        if (context.method_8036() == null)
            return class_1269.field_5811;
        return method_7836(context.method_8045(), context.method_8036(), context.method_20287());
    }

    @Override
    public void method_67187(
        class_1799 stack,
        class_1792.class_9635 context,
        class_10712 displayComponent,
        Consumer<class_2561> textConsumer,
        class_1836 type
    ) {
        if (AllClientHandle.INSTANCE.shiftDown())
            return;
        List<class_2561> makeSummary = makeSummary(stack);
        if (makeSummary.isEmpty())
            return;
        textConsumer.accept(class_5244.field_41874);
        makeSummary.forEach(textConsumer);
    }

    private List<class_2561> makeSummary(class_1799 filter) {
        List<class_2561> list = new ArrayList<>();
        if (filter.method_57380().method_57848())
            return list;

        if (type == FilterType.REGULAR) {
            ItemStackHandler filterItems = getFilterItems(filter);
            boolean blacklist = filter.method_58695(AllDataComponents.FILTER_ITEMS_BLACKLIST, false);

            list.add((blacklist ? class_2561.method_43471("create.gui.filter.deny_list") : class_2561.method_43471("create.gui.filter.allow_list")).method_27692(
                class_124.field_1065));
            int count = 0;
            for (int i = 0, size = filterItems.method_5439(); i < size; i++) {
                if (count > 3) {
                    list.add(class_2561.method_43470("- ...").method_27692(class_124.field_1063));
                    break;
                }

                class_1799 filterStack = filterItems.method_5438(i);
                if (filterStack.method_7960())
                    continue;
                list.add(class_2561.method_43470("- ").method_10852(filterStack.method_7964()).method_27692(class_124.field_1080));
                count++;
            }

            if (count == 0)
                return Collections.emptyList();
        }

        if (type == FilterType.ATTRIBUTE) {
            AttributeFilterWhitelistMode whitelistMode = filter.method_58694(AllDataComponents.ATTRIBUTE_FILTER_WHITELIST_MODE);
            list.add((whitelistMode == AttributeFilterWhitelistMode.WHITELIST_CONJ ? class_2561.method_43471(
                "create.gui.attribute_filter.allow_list_conjunctive") : whitelistMode == AttributeFilterWhitelistMode.WHITELIST_DISJ ? class_2561.method_43471(
                "create.gui.attribute_filter.allow_list_disjunctive") : class_2561.method_43471("create.gui.attribute_filter.deny_list")).method_27692(
                class_124.field_1065));

            int count = 0;
            List<ItemAttributeEntry> attributes = filter.method_58695(AllDataComponents.ATTRIBUTE_FILTER_MATCHED_ATTRIBUTES, new ArrayList<>());
            //noinspection DataFlowIssue
            for (ItemAttributeEntry attributeEntry : attributes) {
                ItemAttribute attribute = attributeEntry.attribute();
                if (attribute == null)
                    continue;
                boolean inverted = attributeEntry.inverted();
                if (count > 3) {
                    list.add(class_2561.method_43470("- ...").method_27692(class_124.field_1063));
                    break;
                }
                list.add(class_2561.method_43470("- ").method_10852(attribute.format(inverted)));
                count++;
            }

            if (count == 0)
                return Collections.emptyList();
        }

        if (type == FilterType.PACKAGE) {
            String address = PackageItem.getAddress(filter);
            if (!address.isBlank())
                list.add(class_2561.method_43470("-> ").method_27692(class_124.field_1080).method_10852(class_2561.method_43470(address).method_27692(class_124.field_1065)));
        }

        return list;
    }

    @Override
    public class_1269 method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        if (!player.method_5715() && hand == class_1268.field_5808) {
            if (!world.field_9236 && player instanceof class_3222 serverPlayer)
                openHandledScreen(serverPlayer);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    @Override
    public @Nullable MenuBase<?> createMenu(int id, class_1661 inv, class_1657 player, class_9129 extraData) {
        class_1799 heldItem = player.method_6047();
        class_1799.field_48349.encode(extraData, heldItem);
        if (type == FilterType.REGULAR)
            return new FilterMenu(id, inv, heldItem);
        if (type == FilterType.ATTRIBUTE)
            return new AttributeFilterMenu(id, inv, heldItem);
        if (type == FilterType.PACKAGE)
            return new PackageFilterMenu(id, inv, heldItem);
        return null;
    }

    @Override
    public class_2561 getDisplayName() {
        return method_63680();
    }

    public static ItemStackHandler getFilterItems(class_1799 stack) {
        ItemStackHandler newInv = new ItemStackHandler(18);
        if (AllItems.FILTER != stack.method_7909())
            throw new IllegalArgumentException("Cannot get filter items from non-filter: " + stack);
        if (!stack.method_57826(AllDataComponents.FILTER_ITEMS))
            return newInv;

        //noinspection DataFlowIssue - It's fine:tm: we check if it has the component before doing this
        ItemHelper.fillItemStackHandler(stack.method_58694(AllDataComponents.FILTER_ITEMS), newInv);

        return newInv;
    }

    public static boolean testDirect(class_1799 filter, class_1799 stack, boolean matchNBT) {
        if (matchNBT) {
            if (PackageItem.isPackage(filter) && PackageItem.isPackage(stack))
                return doPackagesHaveSameData(filter, stack);

            return class_1799.method_31577(filter, stack);
        }

        if (PackageItem.isPackage(filter) && PackageItem.isPackage(stack))
            return true;

        return ItemHelper.sameItem(filter, stack);
    }

    public static boolean doPackagesHaveSameData(@NotNull class_1799 a, @NotNull class_1799 b) {
        if (a.method_7960())
            return false;
        if (!class_1799.method_31577(a, b))
            return false;
        for (class_9336<?> component : a.method_57353()) {
            class_9331<?> type = component.comp_2443();
            if (type.equals(AllDataComponents.PACKAGE_ORDER_DATA) || type.equals(AllDataComponents.PACKAGE_ORDER_CONTEXT))
                continue;
            if (!Objects.equals(a.method_58694(type), b.method_58694(type)))
                return false;
        }
        return true;
    }

    @Override
    public class_9331<?> getComponentType() {
        return switch (type) {
            case ATTRIBUTE -> AllDataComponents.ATTRIBUTE_FILTER_MATCHED_ATTRIBUTES;
            case PACKAGE -> AllDataComponents.PACKAGE_ADDRESS;
            case REGULAR -> AllDataComponents.FILTER_ITEMS;
        };
    }

}
