package com.zurrtum.create.content.logistics.packagePort;

import com.zurrtum.create.AllMenuTypes;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.animatedContainer.AnimatedContainerBehaviour;
import com.zurrtum.create.foundation.gui.menu.MenuBase;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;

public class PackagePortMenu extends MenuBase<PackagePortBlockEntity> {
    public PackagePortMenu(int id, class_1661 inv, PackagePortBlockEntity be) {
        super(AllMenuTypes.PACKAGE_PORT, id, inv, be);
        BlockEntityBehaviour.get(be, AnimatedContainerBehaviour.TYPE).startOpen(player);
    }

    @Override
    public class_1799 method_7601(class_1657 player, int index) {
        class_1735 clickedSlot = method_7611(index);
        if (!clickedSlot.method_7681())
            return class_1799.field_8037;

        class_1799 stack = clickedSlot.method_7677();
        int size = contentHolder.inventory.method_5439();
        boolean success;
        if (index < size) {
            success = !method_7616(stack, size, field_7761.size(), false);
        } else
            success = !method_7616(stack, 0, size, false);

        return success ? class_1799.field_8037 : stack;
    }

    @Override
    protected void initAndReadInventory(PackagePortBlockEntity contentHolder) {
    }

    @Override
    protected void addSlots() {
        class_1263 inventory = contentHolder.inventory;
        int x = 27;
        int y = 9;

        for (int row = 0; row < 2; row++)
            for (int col = 0; col < 9; col++)
                method_7621(new class_1735(inventory, row * 9 + col, x + col * 18, y + row * 18));

        addPlayerSlots(38, 108);
    }

    @Override
    protected void saveData(PackagePortBlockEntity contentHolder) {
    }

    @Override
    public void method_7595(class_1657 playerIn) {
        super.method_7595(playerIn);
        if (!playerIn.method_37908().field_9236)
            BlockEntityBehaviour.get(contentHolder, AnimatedContainerBehaviour.TYPE).stopOpen(playerIn);
    }

}
