package com.zurrtum.create.content.logistics.stockTicker;

import com.zurrtum.create.content.logistics.packager.IdentifiedInventory;
import com.zurrtum.create.content.logistics.packager.InventorySummary;
import com.zurrtum.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.zurrtum.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour.RequestType;
import com.zurrtum.create.content.logistics.packagerLink.LogisticsManager;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public abstract class StockCheckingBlockEntity extends SmartBlockEntity {

    public LogisticallyLinkedBehaviour behaviour;

    public StockCheckingBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        setLazyTickRate(10);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        behaviours.add(behaviour = new LogisticallyLinkedBehaviour(this, false));
    }

    public InventorySummary getRecentSummary() {
        return LogisticsManager.getSummaryOfNetwork(behaviour.freqId, false);
    }

    public InventorySummary getAccurateSummary() {
        return LogisticsManager.getSummaryOfNetwork(behaviour.freqId, true);
    }

    public boolean broadcastPackageRequest(RequestType type, PackageOrder order, @Nullable IdentifiedInventory ignoredHandler, String address) {
        return broadcastPackageRequest(type, PackageOrderWithCrafts.simple(order.stacks()), ignoredHandler, address);
    }

    public boolean broadcastPackageRequest(
        RequestType type,
        PackageOrderWithCrafts order,
        @Nullable IdentifiedInventory ignoredHandler,
        String address
    ) {
        return LogisticsManager.broadcastPackageRequest(behaviour.freqId, type, order, ignoredHandler, address);
    }

}
