package com.zurrtum.create.content.processing.basin;

import com.zurrtum.create.content.processing.recipe.SizedIngredient;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.fluid.FluidIngredient;
import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import it.unimi.dsi.fastutil.ints.IntObjectPair;
import net.minecraft.class_10355;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_3955;
import net.minecraft.class_7225;
import net.minecraft.class_9887;
import net.minecraft.recipe.*;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.function.Function;

public interface BasinRecipe extends class_1860<BasinInput> {
    Map<class_1867, List<SizedIngredient>> SHAPELESS_CACHE = new IdentityHashMap<>();
    Map<class_1869, List<SizedIngredient>> SHAPED_CACHE = new IdentityHashMap<>();

    static boolean matchCraftingRecipe(BasinInput input, class_1867 recipe, class_1937 world) {
        return matchCraftingRecipe(input, recipe, world, SHAPELESS_CACHE, SizedIngredient::of);
    }

    static boolean matchCraftingRecipe(BasinInput input, class_1869 recipe, class_1937 world) {
        return matchCraftingRecipe(input, recipe, world, SHAPED_CACHE, SizedIngredient::of);
    }

    private static <T extends class_3955> boolean matchCraftingRecipe(
        BasinInput input,
        T recipe,
        class_1937 world,
        Map<T, List<SizedIngredient>> ingredientCache,
        Function<T, List<SizedIngredient>> recipeToIngredients
    ) {
        ServerFilteringBehaviour filter = input.filter();
        if (filter == null) {
            return false;
        }
        class_1799 result = recipe.method_8116(null, world.method_30349());
        if (!filter.test(result)) {
            return false;
        }
        List<SizedIngredient> ingredients = ingredientCache.computeIfAbsent(recipe, recipeToIngredients);
        if (ingredients.isEmpty()) {
            return false;
        }
        List<class_1799> outputs = tryCraft(input, ingredients);
        if (outputs == null) {
            return false;
        }
        outputs.add(result);
        return input.acceptOutputs(outputs, List.of(), true);
    }

    @Nullable
    static List<class_1799> tryCraft(BasinInput input, class_1856 ingredient) {
        class_1263 inventory = input.items();
        for (int i = 0, size = inventory.method_5439(); i < size; i++) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960()) {
                continue;
            }
            if (ingredient.method_8093(stack)) {
                List<class_1799> outputs = new ArrayList<>();
                class_1799 remainder = stack.method_7909().method_7858();
                if (remainder != class_1799.field_8037) {
                    outputs.add(remainder);
                }
                return outputs;
            }
        }
        return null;
    }

    @Nullable
    static List<class_1799> tryCraft(BasinInput input, SizedIngredient ingredient) {
        int remainder = ingredient.getCount();
        if (remainder == 1) {
            return tryCraft(input, ingredient.getIngredient());
        }
        class_1263 inventory = input.items();
        List<class_1799> outputs = new ArrayList<>();
        for (int i = 0, size = inventory.method_5439(); i < size; i++) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960()) {
                continue;
            }
            if (ingredient.test(stack)) {
                int extract = Math.min(stack.method_7947(), remainder);
                addRecipeRemainder(stack, extract, outputs);
                if (extract == remainder) {
                    return outputs;
                }
                remainder -= extract;
            }
        }
        return null;
    }

    @Nullable
    static List<class_1799> tryCraft(BasinInput input, List<SizedIngredient> ingredients) {
        int ingredientSize = ingredients.size();
        if (ingredientSize == 0) {
            return new ArrayList<>();
        }
        if (ingredientSize == 1) {
            return tryCraft(input, ingredients.getFirst());
        }
        List<class_1799> usings = new ArrayList<>();
        List<class_1799> inputs = new LinkedList<>();
        int ingredientIndex = 0;
        class_1263 inventory = input.items();
        Find:
        for (int itemIndex = 0, inventorySize = inventory.method_5439(); ingredientIndex < ingredientSize; ingredientIndex++) {
            SizedIngredient ingredient = ingredients.get(ingredientIndex);
            int size = inputs.size();
            int remainder = ingredient.getCount();
            for (; itemIndex < inventorySize; itemIndex++) {
                class_1799 stack = inventory.method_5438(itemIndex);
                if (stack.method_7960()) {
                    continue;
                }
                if (ingredient.test(stack)) {
                    int count = stack.method_7947();
                    if (count > remainder) {
                        usings.add(stack.method_46651(remainder));
                        itemIndex++;
                        continue Find;
                    } else {
                        usings.add(stack);
                        if (count == remainder) {
                            itemIndex++;
                            continue Find;
                        }
                        remainder -= count;
                    }
                } else {
                    inputs.add(stack);
                }
            }
            Iterator<class_1799> iterator = inputs.subList(0, size).iterator();
            while (iterator.hasNext()) {
                class_1799 stack = iterator.next();
                if (ingredient.test(stack)) {
                    iterator.remove();
                    int count = stack.method_7947();
                    if (count > remainder) {
                        usings.add(stack.method_46651(remainder));
                        ingredientIndex++;
                        break Find;
                    } else {
                        usings.add(stack);
                        if (count == remainder) {
                            ingredientIndex++;
                            break Find;
                        }
                        remainder -= count;
                    }
                }
            }
            return null;
        }
        Find:
        for (; ingredientIndex < ingredientSize; ingredientIndex++) {
            SizedIngredient ingredient = ingredients.get(ingredientIndex);
            int remainder = ingredient.getCount();
            Iterator<class_1799> iterator = inputs.iterator();
            while (iterator.hasNext()) {
                class_1799 stack = iterator.next();
                if (ingredient.test(stack)) {
                    iterator.remove();
                    int count = stack.method_7947();
                    if (count > remainder) {
                        usings.add(stack.method_46651(remainder));
                        continue Find;
                    } else {
                        usings.add(stack);
                        if (count == remainder) {
                            continue Find;
                        }
                        remainder -= count;
                    }
                }
            }
            return null;
        }
        List<class_1799> outputs = new ArrayList<>();
        for (class_1799 stack : usings) {
            addRecipeRemainder(stack, stack.method_7947(), outputs);
        }
        return outputs;
    }

    static boolean matchFluidIngredient(BasinInput input, @Nullable FluidIngredient ingredient) {
        if (ingredient == null) {
            return true;
        }
        int remainder = ingredient.amount();
        for (FluidStack stack : input.fluids()) {
            if (ingredient.test(stack)) {
                int amount = stack.getAmount();
                if (amount >= remainder) {
                    return true;
                }
                remainder -= amount;
            }
        }
        return false;
    }

    static boolean matchFluidIngredient(BasinInput input, List<FluidIngredient> ingredients) {
        int ingredientSize = ingredients.size();
        if (ingredientSize == 0) {
            return true;
        }
        if (ingredientSize == 1) {
            return matchFluidIngredient(input, ingredients.getFirst());
        }
        List<FluidStack> inputs = new LinkedList<>();
        int ingredientIndex = 0;
        FluidInventory inventory = input.fluids();
        Find:
        for (int fluidIndex = 0, inventorySize = inventory.size(); ingredientIndex < ingredientSize; ingredientIndex++) {
            FluidIngredient ingredient = ingredients.get(ingredientIndex);
            int size = inputs.size();
            int remainder = ingredient.amount();
            for (; fluidIndex < inventorySize; fluidIndex++) {
                FluidStack stack = inventory.getStack(fluidIndex);
                if (stack.isEmpty()) {
                    continue;
                }
                if (ingredient.test(stack)) {
                    int amount = stack.getAmount();
                    if (amount >= remainder) {
                        fluidIndex++;
                        continue Find;
                    } else {
                        remainder -= amount;
                    }
                } else {
                    inputs.add(stack);
                }
            }
            Iterator<FluidStack> iterator = inputs.subList(0, size).iterator();
            while (iterator.hasNext()) {
                FluidStack stack = iterator.next();
                if (ingredient.test(stack)) {
                    iterator.remove();
                    int count = stack.getAmount();
                    if (count >= remainder) {
                        ingredientIndex++;
                        break Find;
                    } else {
                        remainder -= count;
                    }
                }
            }
            return false;
        }
        Find:
        for (; ingredientIndex < ingredientSize; ingredientIndex++) {
            FluidIngredient ingredient = ingredients.get(ingredientIndex);
            int remainder = ingredient.amount();
            Iterator<FluidStack> iterator = inputs.iterator();
            while (iterator.hasNext()) {
                FluidStack stack = iterator.next();
                if (ingredient.test(stack)) {
                    iterator.remove();
                    int count = stack.getAmount();
                    if (count >= remainder) {
                        continue Find;
                    } else {
                        remainder -= count;
                    }
                }
            }
            return false;
        }
        return true;
    }

    static boolean applyCraftingRecipe(BasinInput input, class_1869 recipe, class_1937 world) {
        return applyCraftingRecipe(input, recipe, world, SHAPED_CACHE, SizedIngredient::of);
    }

    static boolean applyCraftingRecipe(BasinInput input, class_1867 recipe, class_1937 world) {
        return applyCraftingRecipe(input, recipe, world, SHAPELESS_CACHE, SizedIngredient::of);
    }

    private static <T extends class_3955> boolean applyCraftingRecipe(
        BasinInput input,
        T recipe,
        class_1937 world,
        Map<T, List<SizedIngredient>> ingredientCache,
        Function<T, List<SizedIngredient>> recipeToIngredients
    ) {
        List<SizedIngredient> ingredients = ingredientCache.computeIfAbsent(recipe, recipeToIngredients);
        Deque<Runnable> changes = new ArrayDeque<>();
        List<class_1799> outputs = prepareCraft(input, ingredients, changes);
        if (outputs == null) {
            return false;
        }
        outputs.add(recipe.method_8116(null, world.method_30349()));
        if (!input.acceptOutputs(outputs, List.of(), true)) {
            return false;
        }
        changes.forEach(Runnable::run);
        return input.acceptOutputs(outputs, List.of(), false);
    }

    static void addRecipeRemainder(class_1799 stack, int count, List<class_1799> outputs) {
        class_1792 item = stack.method_7909();
        for (int i = 0; i < count; i++) {
            class_1799 remainder = item.method_7858();
            if (remainder != class_1799.field_8037) {
                outputs.add(remainder);
            }
        }
    }

    @Nullable
    static List<class_1799> prepareCraft(BasinInput input, class_1856 ingredient, Deque<Runnable> changes) {
        class_1263 inventory = input.items();
        for (int i = 0, size = inventory.method_5439(); i < size; i++) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960()) {
                continue;
            }
            if (ingredient.method_8093(stack)) {
                int count = stack.method_7947();
                if (count > 1) {
                    int newCount = count - 1;
                    changes.add(() -> {
                        stack.method_7939(newCount);
                        inventory.method_5431();
                    });
                } else {
                    int slot = i;
                    changes.add(() -> {
                        inventory.method_5447(slot, class_1799.field_8037);
                        inventory.method_5431();
                    });
                }
                List<class_1799> outputs = new ArrayList<>();
                class_1799 remainder = stack.method_7909().method_7858();
                if (remainder != class_1799.field_8037) {
                    outputs.add(remainder);
                }
                return outputs;
            }
        }
        return null;
    }

    @Nullable
    static List<class_1799> prepareCraft(BasinInput input, SizedIngredient ingredient, Deque<Runnable> changes) {
        int remainder = ingredient.getCount();
        if (remainder == 1) {
            return prepareCraft(input, ingredient.getIngredient(), changes);
        }
        class_1263 inventory = input.items();
        List<class_1799> outputs = new ArrayList<>();
        for (int i = 0, size = inventory.method_5439(); i < size; i++) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960()) {
                continue;
            }
            if (ingredient.test(stack)) {
                int count = stack.method_7947();
                int using;
                if (count > remainder) {
                    int newCount = count - remainder;
                    changes.add(() -> stack.method_7939(newCount));
                    using = remainder;
                } else {
                    int slot = i;
                    changes.add(() -> inventory.method_5447(slot, class_1799.field_8037));
                    using = count;
                }
                addRecipeRemainder(stack, using, outputs);
                if (using == remainder) {
                    changes.add(inventory::method_5431);
                    return outputs;
                }
                remainder -= using;
            }
        }
        return null;
    }

    @Nullable
    static List<class_1799> prepareCraft(BasinInput input, List<SizedIngredient> ingredients, Deque<Runnable> changes) {
        int ingredientSize = ingredients.size();
        if (ingredientSize == 0) {
            return new ArrayList<>();
        }
        if (ingredientSize == 1) {
            return prepareCraft(input, ingredients.getFirst(), changes);
        }
        List<class_1799> usings = new ArrayList<>();
        List<IntObjectPair<class_1799>> inputs = new LinkedList<>();
        int ingredientIndex = 0;
        class_1263 inventory = input.items();
        Apply:
        for (int itemIndex = 0, inventorySize = inventory.method_5439(); ingredientIndex < ingredientSize; ingredientIndex++) {
            SizedIngredient ingredient = ingredients.get(ingredientIndex);
            int size = inputs.size();
            int remainder = ingredient.getCount();
            for (; itemIndex < inventorySize; itemIndex++) {
                class_1799 stack = inventory.method_5438(itemIndex);
                if (stack.method_7960()) {
                    continue;
                }
                if (ingredient.test(stack)) {
                    int count = stack.method_7947();
                    if (count > remainder) {
                        usings.add(stack.method_46651(remainder));
                        int newCount = count - remainder;
                        changes.add(() -> stack.method_7939(newCount));
                        itemIndex++;
                        continue Apply;
                    } else {
                        usings.add(stack);
                        int slot = itemIndex;
                        changes.add(() -> inventory.method_5447(slot, class_1799.field_8037));
                        if (count == remainder) {
                            itemIndex++;
                            continue Apply;
                        }
                        remainder -= count;
                    }
                } else {
                    inputs.add(IntObjectPair.of(itemIndex, stack));
                }
            }
            Iterator<IntObjectPair<class_1799>> iterator = inputs.subList(0, size).iterator();
            while (iterator.hasNext()) {
                IntObjectPair<class_1799> pair = iterator.next();
                class_1799 stack = pair.right();
                if (ingredient.test(stack)) {
                    iterator.remove();
                    int count = stack.method_7947();
                    if (count > remainder) {
                        usings.add(stack.method_46651(remainder));
                        int newCount = count - remainder;
                        changes.add(() -> stack.method_7939(newCount));
                        ingredientIndex++;
                        break Apply;
                    }
                    usings.add(stack);
                    int slot = pair.leftInt();
                    changes.add(() -> inventory.method_5447(slot, class_1799.field_8037));
                    if (count == remainder) {
                        ingredientIndex++;
                        break Apply;
                    }
                    remainder -= count;
                }
            }
            return null;
        }
        Apply:
        for (; ingredientIndex < ingredientSize; ingredientIndex++) {
            SizedIngredient ingredient = ingredients.get(ingredientIndex);
            int remainder = ingredient.getCount();
            Iterator<IntObjectPair<class_1799>> iterator = inputs.iterator();
            while (iterator.hasNext()) {
                IntObjectPair<class_1799> pair = iterator.next();
                class_1799 stack = pair.right();
                if (ingredient.test(stack)) {
                    iterator.remove();
                    int count = stack.method_7947();
                    if (count > remainder) {
                        usings.add(stack.method_46651(remainder));
                        int newCount = count - remainder;
                        changes.add(() -> stack.method_7939(newCount));
                        continue Apply;
                    }
                    usings.add(stack);
                    int slot = pair.leftInt();
                    changes.add(() -> inventory.method_5447(slot, class_1799.field_8037));
                    if (count == remainder) {
                        continue Apply;
                    }
                    remainder -= count;
                }
            }
            return null;
        }
        changes.add(inventory::method_5431);
        List<class_1799> outputs = new ArrayList<>();
        for (class_1799 stack : usings) {
            addRecipeRemainder(stack, stack.method_7947(), outputs);
        }
        return outputs;
    }

    static boolean prepareFluidCraft(BasinInput input, @Nullable FluidIngredient ingredient, Deque<Runnable> changes) {
        if (ingredient == null) {
            return true;
        }
        FluidInventory inventory = input.fluids();
        int remainder = ingredient.amount();
        int fluidInventorySize = inventory.size();
        for (int fluidIndex = 0; fluidIndex < fluidInventorySize; fluidIndex++) {
            FluidStack stack = inventory.getStack(fluidIndex);
            if (ingredient.test(stack)) {
                int amount = stack.getAmount();
                if (amount > remainder) {
                    int newAmount = amount - remainder;
                    changes.add(() -> {
                        stack.setAmount(newAmount);
                        inventory.markDirty();
                    });
                    return true;
                } else {
                    int slot = fluidIndex;
                    if (remainder == amount) {
                        changes.add(() -> {
                            inventory.setStack(slot, FluidStack.EMPTY);
                            inventory.markDirty();
                        });
                        return true;
                    }
                    changes.add(() -> inventory.setStack(slot, FluidStack.EMPTY));
                    remainder -= amount;
                }
            }
        }
        return false;
    }

    static boolean prepareFluidCraft(BasinInput input, List<FluidIngredient> ingredients, Deque<Runnable> changes) {
        int ingredientSize = ingredients.size();
        if (ingredientSize == 0) {
            return true;
        }
        if (ingredientSize == 1) {
            return prepareFluidCraft(input, ingredients.getFirst(), changes);
        }
        List<IntObjectPair<FluidStack>> inputs = new LinkedList<>();
        int ingredientIndex = 0;
        FluidInventory inventory = input.fluids();
        Apply:
        for (int fluidIndex = 0, inventorySize = inventory.size(); ingredientIndex < ingredientSize; ingredientIndex++) {
            FluidIngredient ingredient = ingredients.get(ingredientIndex);
            int size = inputs.size();
            int remainder = ingredient.amount();
            for (; fluidIndex < inventorySize; fluidIndex++) {
                FluidStack stack = inventory.getStack(fluidIndex);
                if (stack.isEmpty()) {
                    continue;
                }
                if (ingredient.test(stack)) {
                    int count = stack.getAmount();
                    if (count > remainder) {
                        int newAmount = count - remainder;
                        changes.add(() -> stack.setAmount(newAmount));
                        fluidIndex++;
                        continue Apply;
                    } else {
                        int slot = fluidIndex;
                        changes.add(() -> inventory.setStack(slot, FluidStack.EMPTY));
                        if (count == remainder) {
                            fluidIndex++;
                            continue Apply;
                        } else {
                            remainder -= count;
                        }
                    }
                } else {
                    inputs.add(IntObjectPair.of(fluidIndex, stack));
                }
            }
            Iterator<IntObjectPair<FluidStack>> iterator = inputs.subList(0, size).iterator();
            while (iterator.hasNext()) {
                IntObjectPair<FluidStack> pair = iterator.next();
                FluidStack stack = pair.right();
                if (ingredient.test(stack)) {
                    iterator.remove();
                    int count = stack.getAmount();
                    if (count > remainder) {
                        int newAmount = count - remainder;
                        changes.add(() -> stack.setAmount(newAmount));
                        ingredientIndex++;
                        break Apply;
                    } else {
                        int slot = pair.leftInt();
                        changes.add(() -> inventory.setStack(slot, FluidStack.EMPTY));
                        if (count == remainder) {
                            ingredientIndex++;
                            break Apply;
                        } else {
                            remainder -= count;
                        }
                    }
                }
            }
            return false;
        }
        Apply:
        for (; ingredientIndex < ingredientSize; ingredientIndex++) {
            FluidIngredient ingredient = ingredients.get(ingredientIndex);
            int remainder = ingredient.amount();
            Iterator<IntObjectPair<FluidStack>> iterator = inputs.iterator();
            while (iterator.hasNext()) {
                IntObjectPair<FluidStack> pair = iterator.next();
                FluidStack stack = pair.right();
                if (ingredient.test(stack)) {
                    iterator.remove();
                    int count = stack.getAmount();
                    if (count > remainder) {
                        int newAmount = count - remainder;
                        changes.add(() -> stack.setAmount(newAmount));
                        continue Apply;
                    } else {
                        int slot = pair.leftInt();
                        changes.add(() -> inventory.setStack(slot, FluidStack.EMPTY));
                        if (count == remainder) {
                            continue Apply;
                        } else {
                            remainder -= count;
                        }
                    }
                }
            }
            return false;
        }
        changes.add(inventory::markDirty);
        return true;
    }

    int getIngredientSize();

    List<SizedIngredient> getIngredients();

    List<FluidIngredient> getFluidIngredients();

    boolean apply(BasinInput input);

    @Override
    default class_9887 method_61671() {
        return class_9887.field_52597;
    }

    @Override
    default class_10355 method_64668() {
        return null;
    }

    @Override
    default boolean method_8118() {
        return true;
    }

    @Override
    default class_1799 craft(BasinInput input, class_7225.class_7874 registries) {
        return class_1799.field_8037;
    }
}
